/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_TRANSPORT_H_
#define _SML_TRANSPORT_H_

typedef enum SmlTransportEventType {
	SML_TRANSPORT_EVENT_CONNECT_DONE,
	SML_TRANSPORT_EVENT_DISCONNECT_DONE,
	SML_TRANSPORT_EVENT_ERROR,
	SML_TRANSPORT_EVENT_DATA
} SmlTransportEventType;

typedef SmlBool (* SmlTransportEventCb) (SmlTransport *tsp, SmlLink *link, SmlTransportEventType type, SmlTransportData *data, SmlError *error, void *userdata);

SmlTransport *smlTransportNew(SmlTransportType type, SmlError **error);
void smlTransportFree(SmlTransport *tsp);
SmlBool smlTransportInitialize(SmlTransport *tsp, const void *config, SmlError **error);
void smlTransportSetEventCallback(SmlTransport *tsp, SmlTransportEventCb callback, void *userdata);
SmlBool smlTransportFinalize(SmlTransport *tsp, SmlError **error);
SmlBool smlTransportConnect(SmlTransport *tsp, SmlError **error);
SmlBool smlTransportDisconnect(SmlTransport *tsp, SmlLink *link, SmlError **error);
SmlBool smlTransportSend(SmlTransport *tsp, SmlLink *link, SmlTransportData *data, SmlError **error);
SmlTransportData *smlTransportDataNew(char *data, unsigned long size, SmlMimeType mimetype, SmlBool ownsData, SmlError **error);
void smlTransportDataRef(SmlTransportData *data);
void smlTransportDataDeref(SmlTransportData *data);
SmlLink *smlLinkNew(SmlTransport *tsp, void *link_data, SmlError **error);
SmlLink *smlLinkFind(SmlTransport *tsp, void *link_data);
void smlLinkRef(SmlLink *link);
void smlLinkDeref(SmlLink *link);
void smlTransportSetError(SmlTransport *tsp, SmlLink *link, SmlError **error);
SmlTransportType smlTransportGetType(SmlTransport *tsp);
SmlTransport *smlManagerGetTransport(SmlManager *manager);

SmlBool smlTransportRunAsync(SmlTransport *tsp, SmlError **error);
void smlTransportStop(SmlTransport *tsp);

#endif //_SML_TRANSPORT_H_
