/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _OBEX_CLIENT_INTERNALS_H_
#define _OBEX_CLIENT_INTERNALS_H_

#include <openobex/obex.h>

#include <termios.h>
#include <sys/ioctl.h>

#define STREAM_CHUNK 4096

typedef struct SmlTransportObexClientEnv {
	SmlTransportObexClientType type;
	SmlTransport *tsp;
	obex_t *obexhandle;
	uint8_t *stream_chunk;
	uint32_t connection_id;
	char *path;
	unsigned int port;

	int fd;
	int state;
	char *databuf;
	int *databuflen;
	int connected;
	struct termios oldtio;

	SmlBool busy;
	SmlBool error;
	SmlMimeType mimetype;
} SmlTransportObexClientEnv;

#endif //_OBEX_CLIENT_INTERNALS_H_
