/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

#include <libsysactivity/libsysactivity.h>

void* stress_get_data_storages(void* arg) {
	int ret;
#ifdef SA_OPEN_DATA_STORAGE
	ret = sa_open_data_storage();
	if (ret != 0) {
		printf("sa_open_data_storage(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	struct sa_data_storage dev;
	ret = sa_get_data_storage("sda", &dev);
	if (ret != 0) {
		printf("sa_get_data_storage(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

	uint16_t number;
	ret = sa_count_data_storages(&number);
	if (ret != 0) {
		printf("sa_count_data_storages(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

	struct sa_data_storage* hds = (struct sa_data_storage*) malloc(number * sizeof(struct sa_data_storage));

	uint16_t written, i;
	for (i = 0; i < 8000; i++) {
		written = 0;
		ret = sa_get_data_storages(hds, number, &written);
		if (ret != 0) {
			printf("sa_get_data_storages(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}
	}
	if (hds != NULL)
		free(hds);
#ifdef SA_CLOSE_DATA_STORAGE
	ret = sa_close_data_storage();
	if (ret != 0) {
		printf("sa_close_data_storage(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return NULL;
}

int main() {
	pthread_t thread1;
	struct timespec delay;
	delay.tv_sec = 0;
	delay.tv_nsec = 1000000;

	pthread_create(&thread1, NULL, stress_get_data_storages, NULL);
	nanosleep(&delay, NULL);
	stress_get_data_storages(NULL);

	return EXIT_SUCCESS;
}
