/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

/* 
	This file shows how to import a MID/MIF data file into a new layer
	and a CSV file as a second attribute table of the layer

	Author: Lubia Vinhas  
*/

#include <TeDatabase.h>
#include <TeAsciiFile.h>
#include <TeImportExport.h>
#include <TeMySQL.h>

int main()
{
     // Database server parameters
     string host = "localhost";
     string dbname = "TerraTeste";
     string user = "root";
     string password = "";

     // Connect to the database
     TeDatabase* db = new TeMySQL();
     if (!db->connect(host, user, password, dbname))
     {
		cout << "Error: " << db->errorMessage() << endl << endl;
		cout << "Press Enter\n";
		return 1;
     }

	string filename = "../data/BairrosRecife.MIF";
	if (db->layerExist("BairrosRecife"))
	{
		cout << "Error: layer \"BairrosRecife\" already exists in the database!\n" << endl;
		db->close();
		cout << "Press Enter\n";
		getchar();
		return 1;
	}

	// Import the MID/MIF file
	TeLayer* newLayer = new TeLayer("BairrosRecife", db, 0);
	// Select the filed ID_ to be the identifier of each neighbourhood
	if (TeImportMIF(newLayer, filename,"BairrosRecife", "ID_")) 
		cout << "MID/MIF file imported to the TerraLib database successfully!\n" << endl;
	else
	{
		cout << "Fail to import the MID/MIF file!\n";
		db->close();
		cout << "Press Enter\n";
		getchar();
		return 1;
	}

	// Import the csv file
	filename = "../data/BairrosRecife2.csv";
	if (db->tableExist("BairrosRecife2"))
	{
		cout << "There is already a table named \"BairrosRecife2\" in the TerraLib database!\n\n";
		cout << "Press Enter\n";
		getchar();
		return 1;
	}

	cout << "Importing a second attribute table from a CSV file...\n";

	// Creates a definition of the columns contained in the CSV file
	TeAttributeList attList;
	TeAttribute column1;
	column1.rep_.name_  = "BAIRRO_ID";
	column1.rep_.type_ = TeSTRING;
	column1.rep_.isPrimaryKey_ = true;
	column1.rep_.numChar_ = 32;
	attList.push_back(column1);

	TeAttribute column2;
	column2.rep_.name_  = "ORDEM";
	column2.rep_.type_ = TeINT;
	attList.push_back(column2);


	TeAttribute column3;
	column3.rep_.name_  = "NOME";
	column3.rep_.type_ = TeSTRING;
	column3.rep_.numChar_ = 32;
	attList.push_back(column3);

	TeAttribute column4;
	column4.rep_.name_  = "NOME_PADRAO";
	column4.rep_.type_ = TeSTRING;
	column4.rep_.numChar_ = 32;
	attList.push_back(column4);

	TeTable attTable2("BairrosRecife2",attList, "BAIRRO_ID","BAIRRO_ID", TeAttrStatic);
	if (!newLayer->createAttributeTable(attTable2))
	{
		cout << "Error creating table \"BairrosRecife2\" in the TerraLib database!\n\n";
		cout << "Press Enter\n";
		getchar();
		return 1;
	}

	TeAsciiFile csvFile(filename);
	while (csvFile.isNotAtEOF())
	{
		TeTableRow trow;
		csvFile.readNStringCSV (trow, 4, ';');
		if (trow.empty())
			break;

		csvFile.findNewLine();
		attTable2.add(trow);
	}
	if (attTable2.size() > 0)
	{
		if (!newLayer->saveAttributeTable(attTable2))
		{
			cout << "Error saving table \"BairrosRecife2\" in the TerraLib database!\n\n";
			cout << "Press Enter\n";
			getchar();
			return 1;
		}
		attTable2.clear();
	}
	cout << "Table successfully imported...\n";


/*	TeLayer* recife = new TeLayer("BairrosRecife",db);
	TeTable attTable2;
	recife->getAttrTablesByName("BairrosRecife2",attTable2);

	TeView* viewrec = new TeView("Recife",user); 
	viewrec->projection(recife->projection());
	if (!db->insertView(viewrec))			// save the view in the database
	{
		cout << "Fail to insert the view \"Recide\" into the database: " << db->errorMessage() << endl;
		db->close();
		cout << endl << "Press Enter\n";
		getchar();
		return 1;
	}
	TeTheme* themerec = new TeTheme("Recife", recife);
	viewrec->add(themerec);
	themerec ->addThemeTable(attTable2);
	themerec->visibleRep(recife->geomRep());
	if (!themerec ->save() || !themerec ->buildCollection()) 
	{
		cout << "Error saving theme \' Recife \': ";
		cout << db->errorMessage() << endl;
		db->close();
		return 0;
	}
	cout << "Theme created ..\n";
*/
	db->close();
	getchar();
	return 0;
}
 
