/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

/**
 *   This file contains the base class for digital image processing
 *   algorithms.
 */

#ifndef TEPDIBOX_HPP
  #define TEPDIBOX_HPP

  #include "TePDISharedPtr.cpp"

  class TePDIBox{
    public :
      typedef TePDISharedPtr< TePDIBox > pointer;
      typedef const TePDISharedPtr< TePDIBox > const_pointer;

      /**
       * Default Constructor
       *
       * @param top_left_x Top left X coord.
       * @param top_left_y Top left Y coord.
       * @param bottom_right_x Bottom right X coord.
       * @param bottom_right_y Bottom right Y coord.
       */
      TePDIBox( unsigned long int top_left_x = 0,
                unsigned long int top_left_y = 0,
                unsigned long int bottom_right_x = 0,
                unsigned long int bottom_right_y = 0 );

      /**
       * Default Destructor
       */
      ~TePDIBox();

      /**
       * Resets the current Box coords.
       *
       * @param top_left_x Top left X coord.
       * @param top_left_y Top left Y coord.
       * @param bottom_right_x Bottom right X coord.
       * @param bottom_right_y Bottom right Y coord.
       */
      void Reset( unsigned long int top_left_x,
                  unsigned long int top_left_y,
                  unsigned long int bottom_right_x,
                  unsigned long int bottom_right_y );
    protected :
      unsigned long int top_left_x_;
      unsigned long int top_left_y_;
      unsigned long int bottom_right_x_;
      unsigned long int bottom_right_y_;
  };

#endif //TEPDIBOX_HPP
