//---------------------------------------------------------------------------
#ifndef ParticaoH
#define ParticaoH



#define SKATER_SEM_POPULACAO 0
#define SKATER_COM_POPULACAO 1


#define SKATER_POR_GRUPO     0
#define SKATER_POR_POPULACAO 1
#define SKATER_POR_AMBOS     2

#include <string>
#include <vector>
using namespace std;

/** Funcao de regionalizacao de um conjunto de poligonos
 *  hasPop: se ha atributo de populacao, que devera ser o ultimo
 *  tipo:   tipo de quebra, por grupo, por populacao ou por ambos
 *  nGrupos: numero de grupos de quebra
 *  popMin:  tamanho minimo da populacao
 *  regSet:  conjunto de areas a serem regionalizadas, com seus atributos
 *  hetDrop: heterogeneidade dado cada uma das divisoes
 **/
bool TeSkaterFunction(bool hasPop, int tipo, int nGrupos, int popMin,
                      TeSTElementSet& regSet, string resName,
                      vector<double>& hetDrop); 

//---------------------------------------------------------------------------
#endif
