#ifdef HAVE_CONFIG_H
# include <config2.h>
#endif

//#include <ti/lib68k.h>
#include "lib68k.h"
#include <SDL/SDL.h>
#include <stdio.h>
#define SCR_X 240
#define SCR_Y 128

SDL_Surface *screen;

int initDisplay(void) 
{
  screen = SDL_SetVideoMode(SCR_X, SCR_Y, 16, SDL_SWSURFACE);
  return (int)screen;
}

void updateLcd(void) 
{
  char *lcdmem;
  unsigned short* p;
  int i,j;
  unsigned char b=0, temp=0;

  lcdmem=ti68k_getLcdPtr();
  if ( SDL_MUSTLOCK(screen) ) 
    {
      if ( SDL_LockSurface(screen) < 0 ) 
	{
	  return;
	}
    }
  if (screen->format->BytesPerPixel!=2) {printf("\nyou're in %d bpp, you must be in 16 bpp\n",screen->format->BytesPerPixel<<3); exit(1);}
  p=(unsigned short*)screen->pixels;
  lcdmem--;
  for (j=0;j<128;j++)
    {
      for (i=0;i<240;i++) 
	{
	  if (!b) temp=*(++lcdmem);
	  b=(b+1)&7;
	  if (temp&128) *p=0;
	  else *p=0xffff;
	  temp<<=1;
	  p++;	
	}			
      p+=(screen->pitch>>1)-screen->w;
    }
  if ( SDL_MUSTLOCK(screen) ) SDL_UnlockSurface(screen);
  SDL_Flip(screen);	
}

int main(int argc, char **argv) 
{
  char romname[256];
  int romOk = 0;
  strcpy(romname,"ti92plus.rom");
  ti68k_loadDefaultConfig();
  if (!ti68k_initLib68k()) return 0;
  if (!initDisplay()) return 0;
  printf("Display open with pitch %d\n",screen->pitch);
  while (!romOk) 
    {
      printf("Opening %s ...",romname);
      if (ti68k_loadRom(romname) != 0) 
	{
	  printf("Can't open rom, enter a file name :\n");
	  scanf("%s",romname);
	}
      else romOk=1;
    }	
  while (1) 
    {
      ti68k_doInstructions(70000);
      updateLcd();
    }
  ti68k_closeLib68k();
  return 0;
}
