#include <stdio.h>

#include "wnasrt.h"
#include "wnmem.h"
#include "wnmlc.h"


local void test_f_malloc_stuff(void)
{
  ptr mem_array[1000];
  int i;

  fprintf(stderr,"testing f_malloc stuff...\n");  

  wn_assert(wn_mem_used() == 0);
  wn_allmem_verify();

  for(i=0;i<1000;++i)
  {
    mem_array[i] = wn_f_malloc(i);
  }

  wn_assert(wn_mem_used() > 0);
  wn_allmem_verify();

  for(i=0;i<1000;++i)
  {
    free(mem_array[i]);
  }

  wn_assert(wn_mem_used() == 0);
  wn_allmem_verify();

  fprintf(stderr,"  ok!!!!!!\n");  
}


local void test_main_stuff(void)
{
  ptr mem_array[1000];
  int i,start_mem_used;

  fprintf(stderr,"testing main stuff...\n");  

  wn_assert(wn_mem_used() == 0);
  wn_allmem_verify();

  wn_gpmake("general_free");

  start_mem_used = wn_mem_used();

  for(i=0;i<1000;++i)
  {
    mem_array[i] = wn_alloc(i);
  }

  wn_allmem_verify();

  for(i=0;i<1000;++i)
  {
    wn_free(mem_array[i]);
  }

  wn_assert(wn_mem_used() == start_mem_used);
  wn_allmem_verify();

  wn_gpfree();

  wn_assert(wn_mem_used() == 0);

  fprintf(stderr,"  ok!!!!!!\n");  
}


void main(void)
{
  test_f_malloc_stuff();
  test_main_stuff();

  exit(0);
}



