/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-popup.h"

#include "mn-popup-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 27 "mn-popup.gob"

#include "config.h"
#include <glib/gi18n.h>
#include "mn-conf.h"
#include "mn-shell.h"

typedef void (*ActionAddFunction) (MNPopup *self);

typedef struct
{
  const char		*id;
  ActionAddFunction	add;
} ActionDefinition;

#line 41 "mn-popup.c"
/* self casting macros */
#define SELF(x) MN_POPUP(x)
#define SELF_CONST(x) MN_POPUP_CONST(x)
#define IS_SELF(x) MN_IS_POPUP(x)
#define TYPE_SELF MN_TYPE_POPUP
#define SELF_CLASS(x) MN_POPUP_CLASS(x)

#define SELF_GET_CLASS(x) MN_POPUP_GET_CLASS(x)

/* self typedefs */
typedef MNPopup Self;
typedef MNPopupClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_popup_init (MNPopup * o) G_GNUC_UNUSED;
static void mn_popup_class_init (MNPopupClass * c) G_GNUC_UNUSED;
static GObject * ___1_mn_popup_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static ActionDefinition * mn_popup_find_action (const char * id) G_GNUC_UNUSED;
static void mn_popup_add_actions (MNPopup * self) G_GNUC_UNUSED;
static void mn_popup_add_open_cb (MNPopup * self) G_GNUC_UNUSED;
static void mn_popup_add_mark_as_read_cb (MNPopup * self) G_GNUC_UNUSED;
static void mn_popup_add_mark_as_spam_cb (MNPopup * self) G_GNUC_UNUSED;
static void mn_popup_add_delete_cb (MNPopup * self) G_GNUC_UNUSED;
static void mn_popup_open_cb (NotifyNotification * notification, char * id, gpointer user_data) G_GNUC_UNUSED;
static void mn_popup_mark_as_read_cb (NotifyNotification * notification, char * id, gpointer user_data) G_GNUC_UNUSED;
static void mn_popup_mark_as_spam_cb (NotifyNotification * notification, char * id, gpointer user_data) G_GNUC_UNUSED;
static void mn_popup_delete_cb (NotifyNotification * notification, char * id, gpointer user_data) G_GNUC_UNUSED;
static void mn_popup_closed_h (NotifyNotification * notification, gpointer user_data) G_GNUC_UNUSED;
static void mn_popup_append_row (GString * body, const char * name, const char * value) G_GNUC_UNUSED;
static int mn_popup_get_conf_timeout (void) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_MESSAGE
};

/* pointer to the class of our parent */
static NotifyNotificationClass *parent_class = NULL;

/* Short form macros */
#define self_find_action mn_popup_find_action
#define self_add_actions mn_popup_add_actions
#define self_add_open_cb mn_popup_add_open_cb
#define self_add_mark_as_read_cb mn_popup_add_mark_as_read_cb
#define self_add_mark_as_spam_cb mn_popup_add_mark_as_spam_cb
#define self_add_delete_cb mn_popup_add_delete_cb
#define self_open_cb mn_popup_open_cb
#define self_mark_as_read_cb mn_popup_mark_as_read_cb
#define self_mark_as_spam_cb mn_popup_mark_as_spam_cb
#define self_delete_cb mn_popup_delete_cb
#define self_closed_h mn_popup_closed_h
#define self_append_row mn_popup_append_row
#define self_get_conf_timeout mn_popup_get_conf_timeout
#define self_show mn_popup_show
#define self_close mn_popup_close
#define self_new mn_popup_new
GType
mn_popup_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPopupClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_popup_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPopup),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_popup_init,
			NULL
		};

		type = g_type_register_static (NOTIFY_TYPE_NOTIFICATION, "MNPopup", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPopup *)g_object_new(mn_popup_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPopup * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPopup *
GET_NEW_VARG (const char *first, ...)
{
	MNPopup *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPopup *)g_object_new_valist (mn_popup_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Popup::dispose"
	MNPopup *self G_GNUC_UNUSED = MN_POPUP (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 44 "mn-popup.gob"
	if(self->_priv->message) { g_object_unref ((gpointer) self->_priv->message); self->_priv->message = NULL; }
#line 152 "mn-popup.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Popup::finalize"
	MNPopup *self G_GNUC_UNUSED = MN_POPUP (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
mn_popup_init (MNPopup * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Popup::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_POPUP,MNPopupPrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_popup_class_init (MNPopupClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Popup::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNPopupPrivate));

	parent_class = g_type_class_ref (NOTIFY_TYPE_NOTIFICATION);

#line 49 "mn-popup.gob"
	g_object_class->constructor = ___1_mn_popup_constructor;
#line 187 "mn-popup.c"
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_object
		("message" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_MESSAGE /* object_type */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Popup::set_property"
{
	MNPopup *self G_GNUC_UNUSED;

	self = MN_POPUP (object);

	switch (property_id) {
	case PROP_MESSAGE:
		{
#line 45 "mn-popup.gob"
{ GObject *___old = (GObject *)self->_priv->message; self->_priv->message = (MNMessage *)g_value_dup_object (VAL); if (___old != NULL) { g_object_unref (G_OBJECT (___old)); } }
#line 224 "mn-popup.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Popup::get_property"
{
	MNPopup *self G_GNUC_UNUSED;

	self = MN_POPUP (object);

	switch (property_id) {
	case PROP_MESSAGE:
		{
#line 45 "mn-popup.gob"
g_value_set_object (VAL, (gpointer)self->_priv->message);
#line 255 "mn-popup.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 49 "mn-popup.gob"
static GObject * 
___1_mn_popup_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 275 "mn-popup.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Popup::constructor"
{
#line 51 "mn-popup.gob"
	
    GObject *object;
    Self *self;
    GString *body;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    body = g_string_new(NULL);
    self_append_row(body, _("Mailbox:"), selfp->message->mailbox->runtime_name);
    if (selfp->message->error)
      self_append_row(body, _("Unreadable message:"), selfp->message->error);
    else
      {
	self_append_row(body, _("From:"), selfp->message->from);
	self_append_row(body, _("Subject:"), selfp->message->subject);
      }

    g_object_set(self,
		 "body", body->str,
		 "icon-name", "stock_mail",
		 NULL);

    if (mn_conf_get_enum_value(MN_TYPE_POPUP_POSITION, MN_CONF_POPUPS_POSITION) == MN_POPUP_POSITION_ATTACHED)
      g_object_set(self, "attach-widget", mn_shell->icon, NULL);

    g_string_free(body, TRUE);

    self_add_actions(self);

    notify_notification_set_timeout(NOTIFY_NOTIFICATION(self), self_get_conf_timeout());

    g_signal_connect(self, "closed", G_CALLBACK(self_closed_h), NULL);

    return object;
  }}
#line 320 "mn-popup.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 88 "mn-popup.gob"
static ActionDefinition * 
mn_popup_find_action (const char * id)
#line 327 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::find_action"
#line 88 "mn-popup.gob"
	g_return_val_if_fail (id != NULL, (ActionDefinition * )0);
#line 332 "mn-popup.c"
{
#line 90 "mn-popup.gob"
	
    static ActionDefinition action_definitions[] = {
      { "open",		mn_popup_add_open_cb },
      { "mark-as-read",	mn_popup_add_mark_as_read_cb },
      { "mark-as-spam",	mn_popup_add_mark_as_spam_cb },
      { "delete",	mn_popup_add_delete_cb }
    };
    int i;

    for (i = 0; i < G_N_ELEMENTS(action_definitions); i++)
      if (! strcmp(action_definitions[i].id, id))
	return &action_definitions[i];

    return NULL;
  }}
#line 350 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 106 "mn-popup.gob"
static void 
mn_popup_add_actions (MNPopup * self)
#line 356 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::add_actions"
#line 106 "mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 106 "mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 363 "mn-popup.c"
{
#line 108 "mn-popup.gob"
	
    GSList *actions;
    GSList *l;

    /*
     * Note that notification-daemon currently assigns icons to
     * actions by prepending "stock_" to the action ID.
     */

    actions = eel_gconf_get_string_list(MN_CONF_POPUPS_ACTIONS);

    MN_LIST_FOREACH(l, actions)
      {
	char *id = l->data;
	ActionDefinition *def;

	def = self_find_action(id);
	if (def)
	  def->add(self);
	else
	  g_warning(_("configuration key %s: there is no action named `%s'"), MN_CONF_POPUPS_ACTIONS, id);
      }

    eel_g_slist_free_deep(actions);
  }}
#line 391 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 134 "mn-popup.gob"
static void 
mn_popup_add_open_cb (MNPopup * self)
#line 397 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::add_open_cb"
#line 134 "mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 134 "mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 404 "mn-popup.c"
{
#line 136 "mn-popup.gob"
	
    if (mn_message_can_open(selfp->message))
      notify_notification_add_action(NOTIFY_NOTIFICATION(self),
				     "mail-open",
				     /* translators: header capitalization */
				     _("Open"),
				     self_open_cb,
				     NULL,
				     NULL);
  }}
#line 417 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 147 "mn-popup.gob"
static void 
mn_popup_add_mark_as_read_cb (MNPopup * self)
#line 423 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::add_mark_as_read_cb"
#line 147 "mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 147 "mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 430 "mn-popup.c"
{
#line 149 "mn-popup.gob"
	
    if (mn_message_can_mark_as_read(selfp->message))
      notify_notification_add_action(NOTIFY_NOTIFICATION(self),
				     "mark",
				     /* translators: header capitalization */
				     _("Mark as Read"),
				     self_mark_as_read_cb,
				     NULL,
				     NULL);
  }}
#line 443 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 160 "mn-popup.gob"
static void 
mn_popup_add_mark_as_spam_cb (MNPopup * self)
#line 449 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::add_mark_as_spam_cb"
#line 160 "mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 160 "mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 456 "mn-popup.c"
{
#line 162 "mn-popup.gob"
	
    if (mn_message_can_mark_as_spam(selfp->message))
      notify_notification_add_action(NOTIFY_NOTIFICATION(self),
				     "spam",
				     /* translators: header capitalization */
				     _("Mark as Spam"),
				     self_mark_as_spam_cb,
				     NULL,
				     NULL);
  }}
#line 469 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 173 "mn-popup.gob"
static void 
mn_popup_add_delete_cb (MNPopup * self)
#line 475 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::add_delete_cb"
#line 173 "mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 173 "mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 482 "mn-popup.c"
{
#line 175 "mn-popup.gob"
	
    if (mn_message_can_delete(selfp->message))
      notify_notification_add_action(NOTIFY_NOTIFICATION(self),
				     "delete",
				     /* translators: header capitalization */
				     _("Delete"),
				     self_delete_cb,
				     NULL,
				     NULL);
  }}
#line 495 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 186 "mn-popup.gob"
static void 
mn_popup_open_cb (NotifyNotification * notification, char * id, gpointer user_data)
#line 501 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::open_cb"
{
#line 188 "mn-popup.gob"
	
    Self *self = SELF(notification);
    GError *err = NULL;

    GDK_THREADS_ENTER();

    if (! mn_message_open(selfp->message, &err))
      {
	mn_error_dialog(NULL, _("Unable to open message"), "%s", err->message);
	g_error_free(err);
      }

    GDK_THREADS_LEAVE();
  }}
#line 520 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 203 "mn-popup.gob"
static void 
mn_popup_mark_as_read_cb (NotifyNotification * notification, char * id, gpointer user_data)
#line 526 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::mark_as_read_cb"
{
#line 205 "mn-popup.gob"
	
    Self *self = SELF(notification);
    GError *err = NULL;

    GDK_THREADS_ENTER();

    if (! mn_message_mark_as_read(selfp->message, &err))
      {
	mn_error_dialog(NULL, _("Unable to mark message as read"), "%s", err->message);
	g_error_free(err);
      }

    GDK_THREADS_LEAVE();
  }}
#line 545 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 220 "mn-popup.gob"
static void 
mn_popup_mark_as_spam_cb (NotifyNotification * notification, char * id, gpointer user_data)
#line 551 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::mark_as_spam_cb"
{
#line 222 "mn-popup.gob"
	
    Self *self = SELF(notification);
    GError *err = NULL;

    GDK_THREADS_ENTER();

    if (! mn_message_mark_as_spam(selfp->message, &err))
      {
	mn_error_dialog(NULL, _("Unable to mark message as spam"), "%s", err->message);
	g_error_free(err);
      }

    GDK_THREADS_LEAVE();
  }}
#line 570 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 237 "mn-popup.gob"
static void 
mn_popup_delete_cb (NotifyNotification * notification, char * id, gpointer user_data)
#line 576 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::delete_cb"
{
#line 239 "mn-popup.gob"
	
    Self *self = SELF(notification);
    GError *err = NULL;

    GDK_THREADS_ENTER();

    if (! mn_message_delete(selfp->message, &err))
      {
	mn_error_dialog(NULL, _("Unable to delete message"), "%s", err->message);
	g_error_free(err);
      }

    GDK_THREADS_LEAVE();
  }}
#line 595 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 254 "mn-popup.gob"
static void 
mn_popup_closed_h (NotifyNotification * notification, gpointer user_data)
#line 601 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::closed_h"
{
#line 256 "mn-popup.gob"
	
    Self *self = SELF(notification);
    self->visible = FALSE;
  }}
#line 610 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 261 "mn-popup.gob"
static void 
mn_popup_append_row (GString * body, const char * name, const char * value)
#line 616 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::append_row"
#line 261 "mn-popup.gob"
	g_return_if_fail (body != NULL);
#line 261 "mn-popup.gob"
	g_return_if_fail (name != NULL);
#line 261 "mn-popup.gob"
	g_return_if_fail (value != NULL);
#line 625 "mn-popup.c"
{
#line 265 "mn-popup.gob"
	
      char *escaped;

      if (*body->str)
	g_string_append_c(body, '\n');

      g_string_append_printf(body, "<span weight=\"bold\">%s</span>", name);

      escaped = g_markup_escape_text(value, -1);
      g_string_append_printf(body, " %s", escaped);
      g_free(escaped);
    }}
#line 640 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 278 "mn-popup.gob"
static int 
mn_popup_get_conf_timeout (void)
#line 646 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::get_conf_timeout"
{
#line 280 "mn-popup.gob"
	
    switch (mn_conf_get_enum_value(MN_TYPE_EXPIRATION_ENABLED, MN_CONF_POPUPS_EXPIRATION_ENABLED))
      {
      case MN_EXPIRATION_ENABLED_DEFAULT:
	return NOTIFY_EXPIRES_DEFAULT;

      case MN_EXPIRATION_ENABLED_FALSE:
	return NOTIFY_EXPIRES_NEVER;

      case MN_EXPIRATION_ENABLED_TRUE:
	return mn_conf_get_milliseconds(MN_CONF_POPUPS_EXPIRATION_DELAY_MINUTES,
					MN_CONF_POPUPS_EXPIRATION_DELAY_SECONDS);

      default:
	g_assert_not_reached();
	return 0;
      }
  }}
#line 669 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 299 "mn-popup.gob"
void 
mn_popup_show (MNPopup * self)
#line 675 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::show"
#line 299 "mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 299 "mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 682 "mn-popup.c"
{
#line 301 "mn-popup.gob"
	
    GError *err = NULL;

    if (! notify_notification_show(NOTIFY_NOTIFICATION(self), &err))
      {
	g_warning(_("unable to show popup: %s"), err->message);
	g_error_free(err);
      }

    self->visible = TRUE;
  }}
#line 696 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 313 "mn-popup.gob"
void 
mn_popup_close (MNPopup * self)
#line 702 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::close"
#line 313 "mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 313 "mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 709 "mn-popup.c"
{
#line 315 "mn-popup.gob"
	
    GError *err = NULL;

    if (! self->visible)
      return;

    if (! notify_notification_close(NOTIFY_NOTIFICATION(self), &err))
      {
	g_warning(_("unable to close popup: %s"), err->message);
	g_error_free(err);
      }
  }}
#line 724 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 328 "mn-popup.gob"
MNPopup * 
mn_popup_new (MNMessage * message)
#line 730 "mn-popup.c"
{
#define __GOB_FUNCTION__ "MN:Popup::new"
#line 328 "mn-popup.gob"
	g_return_val_if_fail (message != NULL, (MNPopup * )0);
#line 328 "mn-popup.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (message), (MNPopup * )0);
#line 737 "mn-popup.c"
{
#line 330 "mn-popup.gob"
	
    /* we set the summary here because libnotify requires it */

    /* translators: header capitalization */
    return GET_NEW_VARG("summary", _("New Message"),
			MN_POPUP_PROP_MESSAGE(message),
			NULL);
  }}
#line 748 "mn-popup.c"
#undef __GOB_FUNCTION__
