.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\" Traducido del portugus por Pablo Saratxaga <srtxg@f2219.n293.z2.fidonet.org>
.\" La seccin "pginas formatadas" ha sido tomada de la version francesa de
.\" esta pgina de manual, traducida por Ren Cougnenc.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.TH man 1 "15/3/1994"
.LO 1
.SH NOMBRE
man \- formatar y mostrar las pginas de manual en-linea
.br
manpath \- determinar el camino de bsqueda inicial para el utilizador
.SH SINOPSIS
man [\-acdfhktw] [\-m sistema] [\-p string] [\-C fich_config] [\-M path]
[\-P paginador] [\-S lista_sec] [seccin] nombre ...
.SH DESCRIPCIN
.B man
formata y muestra las pginas del manual `en-linea'. Esta versin reconoce
las variables de ambiente (environment)
.B MANPATH
y
.B (MAN)PAGER
(vea ms lejos).
Si la
.I seccin
es indicada,
.B man
busca solamente en ella.
Es posible tambin indicar el ordem de bsqueda en las secciones 
y que preprocessamiento efectuar con los manuales, por medio de opciones en la
linea de comando o variables de ambiente.
Si
.I nombre
contiene el carcter `/' tratar primero un fichero con ese nombre, permitiendo
hacer
.B "man ./foo.5"
o mismo
.B "man /cd/foo/bar.1.gz"
para formatar y ver un fichero en particular.
.SH OPCIONES
.TP
.B \-\^C " fich_config"
Indica el fichero de configuracin a usar; por omissin ser usado
@man_config_file@. (Vea man.conf(5).)
.TP
.B \-\^M " path"
Indica la lista de directrios donde buscar los manuales.
Sin esta opcin ser consultada la variable
.B MANPATH.
Si tampoco esta variable estuviera definida, una lista ser obtenida
por consulta de @man_config_file@. Un directrio vacio en MANPATH
representa la lista anterior.
.TP
.B \-\^P " paginador"
Indica cual paginador/visualisador usar. Sin esta opcin tratar
de consultar la variable
.B PAGER.
Normalmente, man usar
.B @pager@.
.TP
.B \-\^S " lista_sec"
Da la lista de secciones (separadas por `:') donde buscar y en que
orden. Esta opcin tiene prioridad sobre la variable
.B MANSECT.
.TP
.B \-\^a
Normalmente man muestra el primer manual que encuentra. Esta opcin
le permite afichar todas las pginas de manual encontradas para la entrada
.B nombre. 
.TP
.B \-\^d
No muestra el manual, afichando varia informacin para debugging.
.TP
.B \-\^f
Equivalente a
.B whatis.
.TP
.B \-\^h
Aficha un breve mensaje de ayuda.
.TP
.B \-\^k
Equivalente a
.B apropos.
.TP
.B \-\^m " sistema"
Indica um conjunto de manuales diferentes aplicables al sistema indicado.
.TP
.B \-\^p " string"
Especifica uma sequencia de preprocesadores a usar antes de nroff o
troff (los formatadores). Algumas instalaciones Linux pueden no tener todos los
preprocesadores. Algunos preprocesadores y las letras a usar para 
indicarlos son:
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
Esta opcin tiene proridad sobre la variable
.B MANROFFSEQ.
.TP
.B \-\^t
Usar
.B @troff@
para formatar las pginas de manual, la salida efectundose por
.B stdout
La salida de este comando
puede necesitar ser processada por otros filtros antes de poder
ser visualisada o imprimida.
.TP
.B \-\^w \fRo\fP \-\-path
No aficha las pginas de manual, pero muestra la(s) localizacin(es) de los
ficheros que se hubieran formatado y mostrado, para la entrada de
.B nombre
indicado. Si no se da ninguna otra opcin muestra la lista de
directrios que serian recorridos por
.B man
durante la bsqueda. Si
.B manpath
es un lazo haci man, entonces "manpath" es equivalente a "man --path".
.B \-\^W
Como \-\^w, pero aficha los nombres de ficheros, uno por linea, sin ninguna
otra informacin. Muy til en comandos shell del estilo:
.ft CW
man -aW man | xargs ls -l
.ft
.SH "PGINAS FORMATADAS"
Afin de ganar tiempo,
.B man
trata de guardar les pginas formatadas
en vez de interpretarlas cada vez que se las pide.
Tradicionalmente, las versiones formatadas de las pginas de REP/manX son
guardadas en REP/catX, pero otras correspondencias entre los
directrios man y los directrios cat pueden ser indicadas en
el fichero  @man_config_file@. Si el directrio \%cat\% correspondiente
no existe, les pginas formatadas no sern guardadas.
.LP
Es posible de hacer
.B man
suid utilisador man. En ese caso, si un directrio cat pertenece
a man y tiene el modo 0755 (solo man puede escribir), y que los ficheros
cat pertenecen tambin a man y tienen el modo 0644 o 0444 (solo
man puede escrir en ellos, o nadie), ningn utilisador normal podr
cambiar las pginas formatadas o poner otros ficheros en el directrio
correspondiente. Si
.B man
no es suid, los directrios cat debrn tener el modo 0777 afin
que todo utilisador pueda dejar el resultado de los formatajes efectuados durante
las consultaciones del manual.
.LP
La opcin -c fuerza el reformataje de una pgina, mismo si un fichero cat
ms reciente que el fichero fuente existe.

.SH AMBIENTE
.TP
.B MANPATH
Si
.B MANPATH
est definido, su valor ser usado como lista de directrios
(manpath) donde pueden estar las entradas del manual.
.TP
.B MANROFFSEQ
Si
.B MANROFFSEQ
est definido, su valor determina los preprocesamientos a aplicar
antes de nroff o troff. Normalmente, las pginas de manual, son
preprocesadas por tbl antes de nroff.
.TP
.B MANSECT
Si
.B MANSECT
existe, su valor indica las secciones a recorrer.
.TP
.B PAGER
Si
.B PAGER
est definido, indicar el programa a usar para mostrar el manual.
Normalmente usar
.B @pager@.
.TP
.B LANG
Si
.B LANG
est definido, su valor indica el nombre del sub-directrio donde
.B man
comenzar la bsqueda de las pginas de manual. Por ejemplo, el comando
\%LANG=es man 1 pepe\% tendr como efecto de hacer una bsqueda de la pgina
pepe en .../es/man1/pepe.1, y si ese fichero no existe,
en .../man1/pepe.1, ( ... indica un directrio del camino de bsqueda).
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
Las variables de ambiente
.B NLSPATH
y
.B LC_MESSAGES
(o
.B LANG
cuando LC_MESSAGES no existe)
juegan un papel en la localisacin del catlogo de mensajes.
Notese que los programas como col(1) que son llamados por
.B man,
tambin utilizan LC_CTYPE.
.TP
.B PATH
.B PATH
es utilizado para la construccin del camino de bsqueda por omisin.
.TP
.B SYSTEM
.B SYSTEM
empleado para obtener los sistemas alternativos por omisin (en vista de
la utilisacin de la opcin
.B \-m
).
.SH "VEA TAMBIN"
apropos(1), whatis(1), less(1), groff(1).
.SH BUGS
.B \-t
solo funciona si existe un programa troff o equivalente.
.SH TRADUCCIN
Pablo Saratxaga, 1996. A partir de la pgina en portugus de 
Vitor Duarte y la pgina en francs de Ren Cougnenc.
