#include "k2.h"

using namespace std;

// **** Functions ****

void k2::init_k2(const char *sp)
{    
    fd = open(sp, O_RDWR | O_NDELAY );
    if (fd < 0)
    {
qDebug("Unable to open the serial port! Exiting");
 exit(-1);
    }  
    // ************* Term I/O setup ******************
    // Clear the entire struct first
    bzero(&oldtio, sizeof(oldtio));
    tcgetattr(fd, &oldtio); // save old port settings
    newtio = oldtio;
    // Control Modes
    newtio.c_cflag = B4800 | CS8 | CREAD | CLOCAL | CSTOPB;
       // Input Modes
    newtio.c_iflag =  IGNBRK;
    // Output Modes
    newtio.c_oflag = 0;
    // Local Modes 
    newtio.c_lflag = 0;
    // Control Chars for non-canonical mode
    newtio.c_cc[VTIME] = 0; // ignore timer 
    newtio.c_cc[VMIN] = 0; // no blocking read 
    
    // Clear out any junk we have not read
    tcflush(fd, TCIFLUSH);
    // Push our settings out
    cfsetspeed(&newtio, B4800);
    tcsetattr(fd,TCSANOW,&newtio);
    
}


QString k2::read_k2(void)
{
    qbuf = "";
    bzero(buf, 3);
    // Begin read loop
    while(1==1){
 mutex.lock();
 erno = read(fd, buf, 1);    
 mutex.unlock();
 if(qbuf2.length() > 0)
 {
 qbuf = qbuf2;
 qbuf2 = "";
 }
 if( buf[0] == ';' )
 { 
     return qbuf; 
 }   
 if(erno == 1){
 qbuf.append(buf[0]);        
    }else{
    // Save what we have so far and return
    qbuf2 = qbuf;
    qbuf = "";
    return qbuf;
    }
    }
}

void k2::cmd_k2( char * dtx)
{
    int slen = strlen(dtx);  
    mutex.lock(); 
    write(fd, dtx, slen); 
    mutex.unlock();    
}

void k2::restoreTerm(void)
{
  tcsetattr(fd, TCSAFLUSH, &oldtio);
  close(fd);  
}
