/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _RTP_PT_H
#define _RTP_PT_H

/* This list of RTP Payload Types tracks IANA's list, which extends
   the list proposed in Internet RFC 1890.  Non-standard PT's that
   aren't in IANA's list, or in RFC 1890, do not belong here. */

#define RTP_PT_PCMU       0
#define RTP_PT_1016       1
#define RTP_PT_G726_32    2
#define RTP_PT_G721       2
#define RTP_PT_GSM        3
#define RTP_PT_G723       4
#define RTP_PT_DVI4_8     5
#define RTP_PT_DVI4_16    6
#define RTP_PT_LPC        7
#define RTP_PT_PCMA       8
#define RTP_PT_G722       9
#define RTP_PT_L16_S      10
#define RTP_PT_L16_M      11
#define RTP_PT_QCELP      12
#define RTP_PT_CN         13
#define RTP_PT_MPA        14
#define RTP_PT_G728       15
#define RTP_PT_DVI4_11    16
#define RTP_PT_DVI4_22    17
#define RTP_PT_G729       18

#define RTP_PT_CelB       25
#define RTP_PT_JPEG       26

#define RTP_PT_nv         28

#define RTP_PT_H261       31
#define RTP_PT_MPV        32
#define RTP_PT_MP2T       33
#define RTP_PT_H263       34

#endif /* _RTP_PT_H */
