/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "mas/mas.h"
#include "mas/mas_core.h"

void
usage( void )
{
    fprintf(stderr, "usage: mashost [-h|-?] [ [-[hostname]] | [+[hostname]] ]\n");
    fprintf(stderr, "       Allow or deny connections from named hosts.\n\n");
    fprintf(stderr, "options:\n");
    fprintf(stderr, "   -            Deny connections from all hosts.\n");
    fprintf(stderr, "   +            Allow connections from all hosts.\n");
    fprintf(stderr, "   -hostname    Deny connections from 'hostname'.\n");
    fprintf(stderr, "   +hostname    Allow connections from 'hostname'.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "NOTE: This security measure is simple to fool.  The command will be\n");
    fprintf(stderr, "      deprecated in the NEAR future.\n");
    fprintf(stderr, "\n");
    exit(2);
}

int32
do_mashost( char *hostname )
{
    static mas_device_t net = 0;
    struct mas_package package;
    int32 err;

    if ( net == 0 )
    {
        err = mas_asm_get_device_by_name( "net", &net );
        if ( err < 0 ) return err;
    }

    masc_setup_package( &package, NULL, 0, 0 );
    masc_push_string( &package, hostname );
    masc_finalize_package( &package );
    err = mas_set( net, "mashost", &package );
    masc_strike_package( &package );
    
    return 0;
}

int main(int argc, char* argv[])
{
    int32 err;
    int i;
    
    masc_log_verbosity( MAS_VERBLVL_DEBUG );

    if ( argc < 2 )
        usage();
    
    err = mas_init();
    if (err < 0)
    {
	printf("\nconnection with server failed.\n");
	exit(1);
    }

    for (i=1; i<argc; i++)
    {
        if ( argv[i][0] != '-' && argv[i][0] != '+' )
        {
            usage();
        }
        else if ( strlen( argv[i] ) == 1 )
        {
            err = do_mashost(argv[i]);
        }
        else if ( strlen( argv[i] ) == 2 )
        {
            switch(argv[i][1])
            {
            case 'h':
            case '?':
            default:
                usage();
                break;
            }
        }
        else
        {
            fprintf( stderr, "FAILED: Only 'allow all' or 'deny all' options are supported currently.\n\n" );
            usage();
        }
    }
    
    exit(0);
}
