/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _CLIENT_COMMON_H_
#define _CLIENT_COMMON_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xmd.h>
#include <X11/cursorfont.h>

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "structs.h"
#include "theme.h"
#include "main_client.h"
#include "docked_client.h"
#include "toolbar_client.h"
#include "dockbar_client.h"
#include "dialog_client.h"
#include "misc.h"

void client_set_state(Client *c, int state);
long client_get_state(Client *c);
void client_deliver_config(client *c);
void client_deliver_delete(client *c);
int client_want_focus(Client *c);
Client *client_get_next(Client* c, Client_type wanted);
Client *client_get_prev(Client* c, Client_type wanted);
void client_init_backing(Client* c, int width, int height);
void client_morph(Client *c, Client_type new_type);

#endif 
