/*-------------------------------------------------------------------------
 * Copyright (c) 2002 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * cards
 *
 * Synopsis:
 *   routines for handling the MathWar cards
 *
 * $Id: cards.c,v 1.2 2002/11/18 16:10:53 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "cards.h"
#include "support.h"

/*
 * Cards values are zero through twenty.  There are twenty-one number
 * cards, and two back cards.  The index is offset by two card backs
 * (IOW, card back one is @ 0, card back two is @ 1, card0 is @ 2, 
 * card1 is @ 3, ..., card20 is @22).
 */
#define MIN_CARD    0
#define MAX_CARD   20
#define NUMCARDS   23
#define IDX_OFFSET  2

#define SHADOW_SIZE  3

/*
 * Module variables
 */
static GdkPixmap *deck[NUMCARDS] = {NULL};

gboolean
load_deck (void)
{
   gboolean ret = TRUE;

   deck[0] = load_pixmap ("card_back1.png");
   ret = ret && (deck[0] != NULL);
   deck[1] = load_pixmap ("card_back2.png");
   ret = ret && (deck[1] != NULL);
   deck[2] = load_pixmap ("card_0.png");
   ret = ret && (deck[2] != NULL);
   deck[3] = load_pixmap ("card_1.png");
   ret = ret && (deck[3] != NULL);
   deck[4] = load_pixmap ("card_2.png");
   ret = ret && (deck[4] != NULL);
   deck[5] = load_pixmap ("card_3.png");
   ret = ret && (deck[5] != NULL);
   deck[6] = load_pixmap ("card_4.png");
   ret = ret && (deck[6] != NULL);
   deck[7] = load_pixmap ("card_5.png");
   ret = ret && (deck[7] != NULL);
   deck[8] = load_pixmap ("card_6.png");
   ret = ret && (deck[8] != NULL);
   deck[9] = load_pixmap ("card_7.png");
   ret = ret && (deck[9] != NULL);
   deck[10] = load_pixmap ("card_8.png");
   ret = ret && (deck[10] != NULL);
   deck[11] = load_pixmap ("card_9.png");
   ret = ret && (deck[11] != NULL);
   deck[12] = load_pixmap ("card_10.png");
   ret = ret && (deck[12] != NULL);
   deck[13] = load_pixmap ("card_11.png");
   ret = ret && (deck[13] != NULL);
   deck[14] = load_pixmap ("card_12.png");
   ret = ret && (deck[14] != NULL);
   deck[15] = load_pixmap ("card_13.png");
   ret = ret && (deck[15] != NULL);
   deck[16] = load_pixmap ("card_14.png");
   ret = ret && (deck[16] != NULL);
   deck[17] = load_pixmap ("card_15.png");
   ret = ret && (deck[17] != NULL);
   deck[18] = load_pixmap ("card_16.png");
   ret = ret && (deck[18] != NULL);
   deck[19] = load_pixmap ("card_17.png");
   ret = ret && (deck[19] != NULL);
   deck[20] = load_pixmap ("card_18.png");
   ret = ret && (deck[20] != NULL);
   deck[21] = load_pixmap ("card_19.png");
   ret = ret && (deck[21] != NULL);
   deck[22] = load_pixmap ("card_20.png");
   ret = ret && (deck[22] != NULL);

   return ret;
}


void
destroy_deck (void)
{
   gint   i;

   for (i = 0; i < NUMCARDS; i++)
      {
      if (deck[i])
         {
         gdk_pixmap_unref (deck[i]);
         }
      }
}


void
draw_card (GdkPixmap *pix, GdkGC *def_gc, GdkGC *shadow_gc,
           gint card, gint x, gint y)
{
   g_return_if_fail (card <= MAX_CARD);
   g_return_if_fail (card >= CARD_BACK_TWO);

   gdk_draw_rectangle (pix, shadow_gc, TRUE,
                       x + SHADOW_SIZE, y + SHADOW_SIZE,
                       CARD_WIDTH, CARD_HEIGHT); 
   gdk_draw_pixmap (pix, def_gc, deck[card + IDX_OFFSET],
                    0, 0, x, y, -1, -1);
   return;
}
