#! /usr/bin/perl
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

package testdbchr;

@ISA = ('Exporter');
@EXPORT = ('new');


BEGIN {
	if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
	}
}

use File::Basename;
use File::Copy;
use File::Path;
use Getopt::Long;
use Sys::Hostname;
use Net::SMTP;
use Net::FTP;
use POSIX;
use qadb;
use IniFile;

if ($^O =~ /MSWin32/i) {
	require File::DosGlob;
	import  File::DosGlob 'glob';
	require WinLink;
	import  WinLink;
	require Win32::TieRegistry;
	import  Win32::TieRegistry;
	require Win32::Process;
	import  Win32::Process;
}

1;

#sub newnew {

	#
	# Basic initialization
	#

#	$self->{'error_text'}  = "";#
#	$self->{'error_code'}  = 0;
#	$self->{'prot_count'}  = 0;
#	$self->{'log_count'}   = 0;
#	$self->{'noset_lcok'}  = 0;
#	$self->{'no_objstat'}  = 0;
#	$self->{'in_chr'}      = 0;
#	
#	#
	# Read machine-specific options
	#
#	my $confname;
#	if ($^O =~ /Win32/i) {
#		$confname = "c:\\maxdb-test\\maxdb-test.ini";	 
#	} else {
#		$confname = "/etc/maxdb-test";
#	}
#	
#	if (!(-r $confname)) {
#		$self->{'error_text'} = "Could not read the Configuration-File $confname";
#		return 0;	
#	}
#	my $etc_ref = IniFile::load($confname);
#
#
#
#}

sub new {
	#
	# Lets get initialized
	#
	
	my $name      = shift;
	my $options   = shift;
	my $sess_opts = shift;
	my $self      = {};
	$self->{'cmdcount'};
	$self->{'path'} = $ENV{'PATH'};
	
	##
	## Basic settings: things we should know about:
	##
	$self->{'versions'}      = ['7402', '7403', '7404', '7405', '7500', '7501', '7600', '8000'];
	$self->{'status'}        = ['DEV', 'COR', 'RAMP', 'HOT'];
	$self->{'profiles'}      = ['workday', 'weekend'];
	$self->{'dir_names'}     = ['01', '02', '03', '04', '05', '06', '07'];
	$self->{'port_base'}     = 9900; # Should be changed to 50100 someday
	$self->{'wa_portbase'}   = 9800;
	$self->{'wa2_portbase'}  = 9700;
	$self->{'nissl_portbase'}= 9600;
	$self->{'hostname'}    = hostname();
	$self->{'error_text'}  = "";
	$self->{'error_code'}  = 0;
	$self->{'prot_count'}  = 0;
	$self->{'log_count'}   = 0;
	$self->{'noset_lcok'}  = 0;
	$self->{'no_objstat'}  = 0;
	$self->{'in_chr'}      = 0;
	$ENV{'RELVER'}           = "R74"; # Well, this will have to be taken into getVersionDep someday.
	$ENV{'MAXCPU'}           = '2';
	
	umask 0000;
	
	if ($^O =~ /MSWin32/i) {
		$self->{'delimit'}       = "\\"; # As we know, Windows uses backslashes
		$self->{'pathsep'}       = ";";
		$self->{'rootdir'}       = "D:\\SAP_DB\\";
		$self->{'rmcmd'}         = "del /s /q ";
		$self->{'xserver_param'} = "";
		$self->{'instwrap'}      = "";
		$self->{'path'}          = "D:\\sapdb\\programs\\bin;d:\\sapdb\\programs\\pgm;D:\\devtool\\perl\\bin;D:\\DEVTOOL\\bin;d:\\devtool\\adminbin;d:\\devtool\\pgm;d:\\devtool\\posix;d:\\devtool\\Perl;d:\\devtool\\python\\bin;" . $self->{'path'};
		$self->{'globtemp'}      = "D:\\temp";
		$ENV{'JTEST_TOOL'}       = "d:\\devtool\\";
		$ENV{'TOOLVARS'}         = "d:\\devtool\\bin\\toolvars.pl";
		$ENV{'TOOL'}             = "d:\\devtool";
		$ENV{'TOOLEXT'}          = ".pl";
		$ENV{'TOOLSHELL'}        = "D:\\devtool\\perl\\bin\\perl";
		$ENV{'PYTHON'}           = "D:\\devtool\\python";
		$ENV{'PERL'}             = "D:\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.1\\";
		$ENV{'PERL5LIB'}        .= $ENV{'TOOL'} . "\\bin;" . $ENV{'TOOL'} ."\\perl;" . $ENV{'TOOL'} ."\\Perl\\site;" . $ENV{'TOOL'} ."\\Perl\\site\\lib";
		$ENV{'ISWDFNACHT'}       = 1;
		$ENV{'PYTHONPATH'}       = "d:\\devtool\\lib\\Python";
	}
	else {
		$self->{'delimit'}       = "/";
		$self->{'pathsep'}       = ":";
		$self->{'rootdir'}       = "/SAP_DB/";
		$self->{'user'}          = "remuser";
		$self->{'group'}         = "lcadm";
		$self->{'instwrap'}      = $self->{'rootdir'} . "TESTDB/tinysudo";
		$self->{'rmcmd'}         = "rm -rf ";
		$self->{'vserverext'}    = ".old";
		$self->{'ininame'}       =  "/usr/spool/sql/ini/SAP_DBTech.ini";
		$self->{'xserver_param'} = " -Y -S ";
		$self->{'path'}          = "/devtool/local/bin:/devtool/TOOL/tool/pgm:/devtool/TOOL/tool/Posix:/usr/bin/X11:.:" . $self->{'path'};
		$self->{'path'}         .= ":/usr/sbin:/sbin:/usr/bin:/bin:/usr/local/bin:/devtool/local/bin:/devtool/TOOL/tool/bin";
		$self->{'globtemp'}      = "/tmp";
		$self->{'libappend'}	 = "/lib";
		$self->{'cpio_param'}    = "";  # cpio_param and cpio_prepare need to be filled with machine specific 
		$self->{'cpio_prepare'}  = "";  # things later
		$self->{'idcmd'}	 = "id";
		$self->{'chr_prefix'}    = "/SAP_DB/chr/";
		$self->{'libpath'}       = "LD_LIBRARY_PATH";
		$ENV{'TOOL'}             = "/devtool/TOOL/tool";
		$ENV{'TOOLEXT'}          = ".pl";
		$ENV{'TOOLSHELL'}        = "/devtool/local/bin/perl";
		$ENV{'PYTHON'}           = "/devtool/TOOL/tool/Python";
		$ENV{'PERL'}             = "/devtool/local";
		$ENV{'PERL5LIB'}         = $ENV{'TOOL'} . "/bin:" . $ENV{'TOOL'} . "/lib/perl5:/devtool/local/lib/perl5";
		$ENV{'RELVER'}           = "R74"; # Well, this will have to be taken into getVersionDep someday.
		$ENV{'JTEST_TOOL'}       = $ENV{'TOOL'};
		$ENV{'TOOLVARS'}         = $ENV{'TOOL'} . "/bin/toolvars";
		$ENV{'ISWDFNACHT'}       = '1';
		$ENV{'PYTHONPATH'}       = "/devtool/TOOL/tool/lib/Python";
		$ENV{'NPERL'}            = "/opt/perl";
		$ENV{'NPERL5LIB'}        = "";
		$ENV{'NTOOLSHELL'}       = "/opt/perl/bin/perl";
		
	}
	
	##################################################################
	# parameter checking
	##################################################################
	
	
	$self->{'hostname'} = hostname();
	
	if ($self->{'hostname'} =~ "^us0062") {
		$self->{'path'}	       .= ":/usr/jdk1.4.2_03/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/WS6U2/SUNWspro/bin:/opt/WS6U2/SUNWspro:/usr/openwin/bin";
		$self->{'bits'}		= "64";
		$self->{'platform'}	= "sun_64";
		$self->{'cpio_param'}	= "c";
		$self->{'cpio_prepare'} = "mount -f proc /proc";
		$self->{'libappend'}	= "/lib/lib64";
		$self->{'use_posix'}	= 1;
		$self->{'idcmd'}	= "id -a";
		$ENV{'BIT64'}		= '1';
	} 
	elsif ($self->{'hostname'} =~ "^us4010") {
		$self->{'path'}	       .= ":/usr/j2se/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/sapmnt/global/tools/compiler/WS6U2/SUNWspro/bin:/usr/openwin/bin";
		$self->{'bits'}		= "64";
		$self->{'platform'}	= "sun_64";
		$self->{'cpio_param'}	= "c";
		$self->{'cpio_prepare'} = "mount -f proc /proc";
		$self->{'libappend'}	= "/lib/lib64";
		$self->{'use_posix'}	= 1;
		$self->{'idcmd'}	= "id -a";
		$ENV{'BIT64'}		= '1';
	}
	elsif ($self->{'hostname'} =~ "^us4150") {
		$self->{'path'}	       .= ":/usr/java/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/sapmnt/global/tools/WS6U2/SUNWspro/bin:/opt/WS6U2/SUNWspro:/usr/openwin/bin";
		$self->{'bits'}		= "64";
		$self->{'platform'}	= "sun_64";
		$self->{'cpio_param'}	= "c";
		$self->{'cpio_prepare'} = "mount -f proc /proc";
		$self->{'libappend'}	= "/lib/lib64";
		$self->{'use_posix'}	= 1;
		$self->{'idcmd'}	= "id -a";
		$ENV{'BIT64'}		= '1';
	}
	elsif ($self->{'hostname'} =~ "^ds0116") {
		$self->{'path'}         .= ":/usr/opt/java141/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}          = "64";
		$self->{'cpio_param'}    = "e";
		$self->{'platform'}      = "alphaosf";
		$ENV{'BIT64'}            = '1';
	}
	elsif ($self->{'hostname'} =~ "^is0025") {
		$self->{'path'}         .= ":/usr/java14_64/jre/sh:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}          = "64";
		$self->{'platform'}      = "rs6000_51_64";
		$self->{'libappend'}	 = "/lib/lib64";
		$self->{'libpath'}       = "LIBPATH";
		$ENV{'BIT64'}            = '1';
	}
	elsif ($self->{'hostname'} =~ "^is0026") {
		$self->{'path'}         .= ":/usr/java131/jre/sh:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}          = "64";
		$self->{'platform'}      = "rs6000_64";
		$self->{'xserver_param'} = " -S "; # This is secialy needed for this release
		$self->{'libappend'}	 = "/lib/lib64";
		$ENV{'BIT64'}            = '1';
		$self->{'libpath'}       = "LIBPATH";
		pop @versions;             # Currently, SAP DB 7.4.3 is only availble von AIX 5, not an AIX 4
	}
	elsif ($self->{'hostname'} =~ "^is0042") {
		$self->{'path'}         .= ":/usr/java14_64/jre/sh:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/vac/bin:/usr/vacpp/bin";
		$self->{'bits'}          = "64";
		$self->{'platform'}      = "rs6000_52_64";
		$self->{'libappend'}	 = "/lib/lib64";
		$self->{'libpath'}       = "LIBPATH";
		$ENV{'BIT64'}            = '1';
	}
	elsif ($self->{'hostname'} =~ "^hs0102") {
		$self->{'path'}          = "/opt/java1.4/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/aCC/bin:/opt/ansic/bin:" . $self->{'path'};
		$self->{'bits'}          = "64";
		$self->{'platform'}      = "hp_64";
		$self->{'libappend'}	 = "/lib/lib64";
		$self->{'cpio_param'}    = "x";
		#
		# Only tempoarily (hopefuly!)
		$ENV{'BIT64'}            = '1';
		$ENV{'UNIX95'}           = "1";
		$ENV{'TZ'}               = "MET-1METDST";
		$ENV{'RTEHSS_VERBOSE'}   = '1';
	}
        elsif ($self->{'hostname'} =~ "^hs0030") {
		$self->{'path'}          = "/opt/java1.4/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/aCC/bin:/opt/ansic/bin:" . $self->{'path'};
		$self->{'bits'}          = "64";
		$self->{'platform'}      = "hp_64";
		$self->{'libappend'}	 = "/lib/lib64";
		$self->{'cpio_param'}    = "x";
		$self->{'use_posix'}	 = 1;
		#
		# Only tempoarily (hopefuly!)
		$ENV{'BIT64'}            = '1';
		$ENV{'UNIX95'}           = "1";
		$ENV{'TZ'}               = "MET-1METDST";
		$ENV{'RTEHSS_VERBOSE'}   = '1';
	}
        elsif ($self->{'hostname'} =~ "^hs0116") {
		$self->{'path'}          = "/opt/java1.4/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/aCC/bin:/opt/ansic/bin:/opt/langtools/bin:" . $self->{'path'};
		$self->{'bits'}          = "64";
		$self->{'platform'}      = "hpia64";
		$self->{'cpio_param'}    = "x";
		$ENV{'BIT64'}            = '1';
		$ENV{'UNIX95'}           = "1";
		$ENV{'TZ'}               = "MET-1METDST";
		$ENV{'RTEHSS_VERBOSE'}   = '1';
	}
        elsif ($self->{'hostname'} =~ "^ld9031") {
		$self->{'path'}    .= ":/usr/lib/java/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}     = "32";
		$self->{'platform'} = "linuxintel";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
		delete $ENV{'BIT64'}; # Someday, this belongs to getHostDep
        }
	elsif ($self->{'hostname'} =~ "^ld0319") {
		$self->{'path'}    .= ":/usr/java/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}     = "32";
		$self->{'platform'} = "linuxintel";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
		delete $ENV{'BIT64'}; # Someday, this belongs to getHostDep
        }
    elsif ($self->{'hostname'} =~ "^ldp001") {
		$self->{'path'}    .= ":/usr/lib/java/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}     = "32";
		$self->{'platform'} = "linux2.6ia32";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
		$ENV{'TZ'}               = "MET-1METDST";
		delete $ENV{'BIT64'}; # Someday, this belongs to getHostDep
    }
	elsif ($self->{'hostname'} =~ "^p65949") {
		$self->{'path'}    .= ":/usr/j2sdk1.4.1_02/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}     = "32";
		$self->{'platform'} = "linuxintel";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		delete $ENV{'BIT64'}; # Someday, this belongs to getHostDep
        }
	elsif ($self->{'hostname'} =~ "^ls3007") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxia64";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/java/j2sdk1.4.2/jre/bin:";
	}
	elsif ($self->{'hostname'} =~ "^ld0406") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxia64";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/java/j2sdk1.4.2_04/bin:/usr/java/j2sdk1.4.2_04/jre/bin:";
	}
	elsif ($self->{'hostname'} =~ "^ldp008") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxia64";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/java/j2sdk1.4.2/jre/bin:";
	}
	elsif ($self->{'hostname'} =~ "^ls3662") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxppc64";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc ; mount -t devpts devpts /dev/pts";
		$self->{'cpio_param'}	= "c";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/lib/java/jre/bin:";
	}
  	elsif ($self->{'hostname'} =~ "^ls3101") {
  		$self->{'bits'}     = "64";
  		$self->{'platform'} = "linuxx86_64";
  		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
  		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/lib/java/jre/bin:";
  	}

	
	elsif ($self->{'hostname'} =~ "^PWDF0238") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\IDE;C:\\Program Files\\";
		$self->{'path'}         .= "Microsoft Visual Studio .NET\\VC7\\BIN;C:\\Program Files\\Microsoft Visual Studio .N";
		$self->{'path'}         .= "ET\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin";
		$self->{'path'}         .= "\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin;C:\\P";
		$self->{'path'}         .= "rogram Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\bin;C:\\WINNT\\Microsoft.NE";
		$self->{'path'}         .= "T\\Framework\\v1.0.3705;";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\INCLUDE;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET\\"
			     . "VC7\\PlatformSDK\\include\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\include;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include\\";
		$ENV{'LIB'}              = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\LIB;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\lib;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.0.3705";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
    }
    	elsif ($self->{'hostname'} =~ "^pwdf2027") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE;C:\\Program F"
					. "iles\\Microsoft Visual Studio .NET 2003\\VC7\\BIN;C:\\Program Files\\Microsoft V"
					. "isual Studio .NET 2003\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studi"
					. "o .NET 2003\\Commsetprerelease;C:\\Program Files\\Microsoft Visual"
					. " Studio .NET 2003\\Common7\\Tools\\bin;C:\\Program Files\\Microsoft Visual Studi"
					. "o .NET 2003\\SDK\\v1.1\\bin;C:\\WINNT\\Microsoft.NET\\Framework\\v1.1.4322;";
		$ENV{'INCLUDE'}         = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\INCLUDE;C:\\P"
					. "rogram Files\\Microsoft Visual Studio .NET 2003\\VC7\\INCLUDE;C:\\Program Files\\"
					. "Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include\\prerelease;C:\\Pr"
					. "ogram Files\\Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include;C:\\Pr"
					. "ogram Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\include;C:\\Program F"
					. "iles\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\include\\";
		$ENV{'LIB'}             = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\LIB;C:\\Progr"
					. "am Files\\Microsoft Visual Studio .NET 2003\\VC7\\LIB;C:\\Program Files\\Microso"
					. "ft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib\\prerelease;C:\\Program Files\\"
					. "Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib;C:\\Program Files\\Mic"
					. "rosoft Visual Studio .NET 2003\\SDK\\v1.1\\lib;C:\\Program Files\\Microsoft Visu"
					. "al Studio .NET 2003\\SDK\\v1.1\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.1.4322";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
		
	}
	elsif ($self->{'hostname'} =~ "^itanium21") {
		$self->{'path'}         .= ";C:\\Program Files (x86)\\Java\\j2sdk1.4.2.beta;C:\\Program Files\\Microsoft Platform SDK\\Bin\\Win64;C:\\Program Files\\Microsoft Platform SDK\\";
		$self->{'path'}         .= "Bin;C:\\Program Files\\Microsoft Platform SDK\\Bin\\WinNT;C:\\WINNT;C:\\WINNT\\system32;D:\\DEVTOOL";
		$self->{'path'}         .= "\\bin;d:\\devtool\\adminbin;d:\\devtool\\pgm;d:\\devtool\\posix;d:\\devtool\\Perl;d:\\devtool\\python\\bin";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Platform SDK\\Include\\prerelease;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\crt;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\crt\\sys;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\mfc;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\atl;C:\\Program Files\\Microsoft Platform SDK\\Include;C:\\Program Files\\Microsoft Platform SDK\\Include\\DShowIDL;C:\\Program Files\\Microsoft Platform SDK\\PATCH\\include";
		$ENV{'ComSpec'}          = "C:\\WINDOWS\\system32\\cmd.exe";
		$ENV{'CPU'}              = "IA64";
		$ENV{'DEBUGMSG'}         = "RETAIL";
		$ENV{'DXSDKROOT'}        = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'INETSDK'}          = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'Lib'}              = "C:\\Program Files\\Microsoft Platform SDK\\Lib\\Prerelease\\IA64;C:\\Program Files\\Microsoft Platform SDK\\Lib\\IA64;C:\\Program Files\\Microsoft Platform SDK\\Lib\\IA64\\mfc;C:\\Program Files\\Microsoft Platform SDK\\PATCH\\lib";
		$ENV{'MSSdk'}            = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'Mstools'}          = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'MSVCVer'}          = "Win64";
		$ENV{'BIT64'}      = '1';
		$self->{'bits'} = "64";
		$self->{'platform'} = "NTia64";
	}
	
	else {
		print "The host $self->{'hostname'} ist not known in the configuration\n(See sub getdep!)\n";
		exit(1);
	}
	
	if (defined ${$options}{'DIR'}) {
		$self->{'dir'}		= ${$options}{'DIR'};
		$self->{'target'}	= $self->{'chr_prefix'} . $self->{'dir'};
		$self->{'localport'}	= int($self->{'port_base'}) + int($self->{'dir'});
		$ENV{'SQLPORT'}         = $self->{'localport'};
		#if (!(-e $self->{'target'})) {
		#	die "Could not find $self->{'target'} as chr-target!\n";
		#}
	}
	
	if (defined ${$options}{'ID'}) {
		if (defined $sess_opts) {
			$self->{'qah'} = qadb->new({'ID' => ${$options}{'ID'}}, $sess_opts );
		} else {
			$self->{'qah'} = qadb->new({'ID' => ${$options}{'ID'}});
		}
		$self->{'qah'}->get_testlist();
		$self->{'version'} = $self->{'qah'}->{'VERSION'};
		$self->{'status'}  = $self->{'qah'}->{'QASTATUS'};
		$self->{'buildpfx'} = $self->{'qah'}->{'BUILDPFX'};
		if (${$options}{'profile'} =~ /weekend/) {
			$self->{'profile'} = 'weekend';
		}
		else {
			$self->{'profile'} = 'workday';
		}
	} else {
		$self->{'version'} = ${$options}{'version'};
		$self->{'status'}  = ${$options}{'status'};
		if (${$options}{'profile'} =~ /weekend/) {
			$self->{'profile'} = 'weekend';
		}
		else {
			$self->{'profile'} = 'workday';
		}
		
		if (defined $sess_opts) {
			$self->{'qah'} = qadb->new_test({'QASTATUS' => $self->{'status'}, 'VERSION' => $self->{'version'}}, $sess_opts);
		} else {
			$self->{'qah'} = qadb->new_test({'QASTATUS' => $self->{'status'}, 'VERSION' => $self->{'version'}});
		}
		if ($self->{'qah'}->{'error_code'} != 0) {
			print "Exiting:\n" . $self->{'qah'}->{'error_text'} . "\n";
			exit(1);
		}
		$self->{'buildpfx'} = $self->{'qah'}->{'BUILDPFX'};
		
	}
	
	$self->{'platform'} = $self->{'qah'}->{'platformname'};
	$ENV{'PLATFORM'} = $self->{'platform'};
	
	$self->{'node'} = $self->{'version'} . $self->{'status'};
	
	
	##################################################################
	# Find out which files to use
	##################################################################
	if (($self->{'status'} =~ /RAMP/) or ($self->{'status'} =~ /HOT/)) {
		$self->{'subdir'}	= "/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}$self->{'buildpfx'}_$self->{'bits'}_" . $self->{'status'};
		$self->{'srcdir'}	= "$self->{'subdir'}/" . $self->{'qah'}->{'LCPOOLID'};
		@files			= (glob "$self->{'subdir'}/" . $self->{'qah'}->{'LCPOOLID'} . "/SAPDB$self->{'version'}*.SAR");
		$self->{'srcfile'}	= pop(@files);
		$self->{'build'}	= substr($self->{'subdir'}, length("/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}"), 2);
	}
	else {
		$self->{'subdir'}	= "/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}_$self->{'bits'}_$self->{'status'}";
		$self->{'srcdir'}	= "$self->{'subdir'}/" . $self->{'qah'}->{'LCPOOLID'};
		@files			= (glob "$self->{'srcdir'}/SAPDB$self->{'version'}*.SAR");
		$self->{'srcfile'}	= pop(@files);
		$self->{'build'}	= substr($self->{'srcfile'}, -6 ,2);
	}

	$self->{'sdbinst'}	= $self->{'srcdir'} . $self->{'delimit'} . "SAPDB_COMPONENTS" . $self->{'delimit'} . "SDBINST";
	
	$self->{'tempdir'}	= $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "tmp";
	$self->{'dbroot'}	= $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "db";
	$self->{'testdir'}	= $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "test";
	$self->{'jtest_root'}	= $self->{'testdir'} . $self->{'delimit'} . "jtest";
	
	#
	# Read the independend program path
	#
	
	$ENV{'PATH'} = $self->{'path'};
	$self->{'indeppath'} = "/SAP_DB/programs";
	
	
	$ENV{'INDEPPATH'}   = $self->{'indeppath'};
	
	if (!($^O =~ /MSWin32/i)) {
		$ENV{'INDEPLIB'}	= $self->{'indeppath'} . $self->{'libappend'};
	}
	
	$self->{'vserver'}  = $self->{'indeppath'} . $self->{'delimit'} . "pgm" . $self->{'delimit'} . "vserver";
	
	$self->{'path'}     = $self->{'testdir'} . $self->{'delimit'} . "pc" . $self->{'delimit'} . "bin" . $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "bin". $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "pgm" . $self->{'pathsep'} . $self->{'path'};
	$ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'PYTHONPATH'} .= $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "misc";
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	


	
	if ((int($self->{'version'} == 7500)) && (($self->{'qah'}->{'IDPLATFORM'} != 16) && ($self->{'qah'}->{'IDPLATFORM'} != 15))) {  # Prevent Precompiler-Installations in linuxx86_64 
		$self->{'sapdbsdk'} = $self->{'indeppath'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . "7403";
	} else {
		$self->{'sapdbsdk'} = $self->{'indeppath'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
	}
	
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	
	$ENV{'SAPDBSDK'}	= $self->{'sapdbsdk'};
	
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	
	$self->{'noset_lcok'}  = 1  if (${$options}{'noset_lcok'}); 
	if (${$options}{'no_objstat'})	{
		$self->{'no_objstat'}  = 1; 
		$self->{'noset_lcok'} = 1;	
	}
	
	for $x (keys(%$self)) {
		print "\tDBG: $x = " . $self->{$x} . "\n";
	}	
	
	return bless $self;
}

sub unlock {
	my $self = shift;
	
	return $self->{'qah'}->unlock();
}

sub lock {
	my $self = shift;
	$self->{'qah'} = $self->{'qah'}->lock();
	
	return 0;
}
#
# Provide a terminal
#
sub term {
	$self = shift;
	$display = shift;
	
	if (defined($display)) {
		$ENV{'DISPLAY'} = $display;
	}
	
	$ENV{'PATH'}		= $self->{'path'};
	$ENV{'HOME'}		= $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}	= $self->{'jtest_root'};
	$ENV{'INSTROOT'}	= $self->{'dbroot'};
	$ENV{'TEST_ROOT'}	= $self->{'testdir'};
	$ENV{'TESTROOT'}	= $self->{'testdir'};
	$ENV{'SAPDBSDK'}	= $self->{'sapdbsdk'};
	$ENV{'TMP'}		= $self->{'tempdir'};
	$ENV{'TEMP'}		= $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	if ($^O =~ /MSWin32/i) {
		system ("cmd");
	}
	else {
		system ("xterm -title \"$self->{'hostname'} - $self->{'version'}$self->{'status'} \" &");
	}
}

sub cmd {
	$self = shift;
	$cmd  = shift;
	
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	
	&doCmd($self, $cmd);
}

##################################################################
# subs
##################################################################
##################################################################
# preClean:
# Throws away current instances, unregisters the installation
# and eraes tempoary and test directorys.
##################################################################
sub preClean {
	$self = shift;
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	
	print "Running pre-clean:\n";
	
	print "\tStopping x_niserver.." . (doCmd($self, "x_niserver stop") == 0 ? "..OK\n" : "..FAILED!\n");
	print "\tRestarting x_server.." . (doCmd($self, "x_server $self->{'xserver_param'} $self->{'localport'}") == 0 ? "..OK\n" : "..FAILED!\n");
	open (DBLIST, 'dbmcli db_enum|');
	my $x = "";
	while (<DBLIST>) {
		if ( /fast/ && /$self->{node}/i ) {
			s/^(\w+)\s+.*$/$1 /;
			$x = $_;
			chomp($x);
			print "\tRemoving instance '$x'..";
			my $succ = 0;
			foreach $y ("control,control", "dbm,dbm", "superdba,colduser") {
				$succ = 1 if (doCmd($self, "dbmcli -u $y -d $x db_stop"));
				$succ = 1 if (doCmd($self, "dbmcli -u $y -d $x db_clear"));
				$succ = 1 if (doCmd($self, "dbmcli -u $y -d $x db_drop"));
			}
			print ".." . ($succ ? "OK\n" : "FAILED!\n");
		}
	}
	
	print "\tStopping x_niserver.." . (doCmd($self, "x_niserver stop") == 0 ? "..OK\n" : "..FAILED!\n");
	print "\tStopping x_server.." . (doCmd($self, "x_server $self->{'xserver_param'} $self->{'localport'} stop") == 0 ? "..OK\n" : "..FAILED!\n");
	
	# If we were called with -noinstall, it is _not_ usefull to
	# deregister the installation.
	if (!($options{'noinstall'})) {
		print "\tUnregistering installation.." . (doCmd($self, "dbmcli inst_unreg $self->{'dbroot'}") == 0 ? "..OK\n" : "..FAILED!\n");
	}
	
	print "\tRemoving temporary files.." . (doCmd($self, "$self->{'rmcmd'} $self->{'tempdir'}" . $self->{'delimit'} . "*") == 0 ? "..OK\n" : "..FAILED!\n");
	
	unless ($^O =~ /MSWin32/i) {
		print "\tRemoving hidden temporary files.." . (doCmd($self, "$self->{'rmcmd'} $self->{'tempdir'}" . $self->{'delimit'} . ".[xX]*") == 0 ? "..OK\n" : "..FAILED!\n");
	}
	
	print "\tRemoving test files.." . (doCmd($self, "$self->{'rmcmd'} $self->{'testdir'}" . $self->{'delimit'} . "* ") == 0 ? "..OK\n" : "..FAILED!\n");
	print "\n";
	return 1;    
}

##################################################################
# installLC:
# installs the LC depending on the informations we have
# already figured out.
##################################################################
sub installLC {
	my $self = shift;
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	my $rc;
	my $sig;
	my $core;
	my $outbuf;
	
	&doCmd($self, "uptime");
	&doCmd($self, "x_server stop");
	if (! $self->{'noset_lcok'}) 	{
		$self->{'qah'}->execDML("UPDATE makes SET lcok = FALSE, IDOBJSTATUS = 1100 WHERE id = $self->{'qah'}->{'ID'}");
	}
	
	#
	# Tempoary for the current 7600COR SQLDBC-only-release
	#
	if (($self->{'version'} =~ /7600/) && ($self->{'qah'}->{'IDPLATFORM'} == 2)) {
		$self->{'inst_param'} = " -b -package \"Base,Database Connectivity\" -dbc_path $self->{'dbroot'} -indep_data /SAP_DB/data -indep_prog $self->{'indeppath'} -o lcown -g lcadm";
		
		&instloginit($self);
		($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
		&instlogwrite($self, "LC installation - Core installation log file");
		
		if ($rc != 0) {
		    send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Core installation failed.", $outbuf);
		}
		return;
	}
        # perform the installation itself
        $self->{'odbcinst_param'} = " -b -profile ODBC ";
        $self->{'inst_param'} = " -b -profile Server  -o lcown -g lcadm -depend $self->{'dbroot'} -indep_prog $self->{'indeppath'} -indep_data /SAP_DB/data ";
	
	
	&instloginit($self);
	
        ($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
	&instlogwrite($self, "LC installation - Core installation log file");
	
        if ($rc != 0) {
            send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Core installation failed.", $outbuf);
        }
	
	
	
	if (int($self->{'version'}) >= 7500) {
		$self->{'loader_param'} = " -b -profile Loader -loader_path $self->{'indeppath'}";
		print "##### Loader ##############################################\n";
		&instloginit($self);
		
		($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'loader_param'} ");
		&instlogwrite($self, "LC installation - Loader installation log file");
		if ($rc != 0) {
			send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Loader installation failed.", $outbuf);
		}
		
		
	}
	
	
	print "##### Webtools ##############################################\n";
	&instloginit($self);
	
	if ($self->{'version'} > 7403)  {
		$self->{'webtool_param'} = " -b -profile Webtools ";
	} else { 
		$self->{'webtool_param'} = " -b -profile Webtools  -o $self->{'user'} -g $self->{'group'}";
	}
	
	($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'webtool_param'} ");
	&instlogwrite($self, "LC installation - Webtools installation log file");
	
	if ($rc != 0) {
		send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Webtools installation failed.", $outbuf);
	}
	
	
	
	&instloginit($self);
	print "##### Testcomponents ########################################\n";
	
	$self->{'test_param'} = "-a " . $self->{'srcdir'} . $self->{'delimit'} . "TEST_COMPONENTS -b -profile all -tstknl_path $self->{'dbroot'} -lc_sim_path $self->{'dbroot'} -test_apps_path $self->{'dbroot'}";
	
	($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'test_param'} ");
	&instlogwrite($self, "LC installation - Testcomponents installation log file");
	
	if ($rc != 0) {
		send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Testcomponents installation failed.", $outbuf);
	}
	
	&instloginit($self);
	print "##### C Precompiler ##########################################\n";
	
	if (int($self->{'version'}) <= 7403) {
		$self->{'cpc_param'} = " -b -profile \"C Precompiler\"  -o $self->{'user'} -g $self->{'group'}";
	} elsif ((int($self->{'version'} == 7500)) && (($self->{'qah'}->{'IDPLATFORM'} != 16) && ($self->{'qah'}->{'IDPLATFORM'} != 15))) {  # Prevent Precompiler-Installations in linuxx86_64
		$self->{'cpc_param'} = " -a " . $self->{'7403DEVsrcdir'} . $self->{'delimit'} . "SAPDB_COMPONENTS -b -profile \"C Precompiler\" ";
	}
	else {
		$self->{'cpc_param'} = " -b -profile \"C Precompiler\" " ;
	}
	
	($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'cpc_param'} ");
	&instlogwrite($self, "LC installation - CPC installation log file");
	
	if ($rc != 0) {
		send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - CPC installation failed.", $outbuf);
	}

	&instloginit($self);
	#####ODBC###############################################################
	# Okay, dann machen wir mal etwas ODBC
	print "##### ODBC #####################################################\n";
	
	# Then install the package we want.
	($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'odbcinst_param'} ");
	&instlogwrite($self, "LC installation - ODBC installation log file");
	
	if ($rc != 0) {
		send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - ODBC installation failed.", $outbuf);
	}
	
	
	$self->{'qah'}->execDML("UPDATE chrs SET idmake = $self->{'qah'}->{'ID'}, idchr_stat = 3 WHERE idserver = $self->{'qah'}->{'IDSERVER'} AND chrcnt = '" . $self->{'dir'} . "'");
	
	
	##### RESTART THE x_server
	
	($rc, $sig, $core, $outbuf) = &doCmd($self, "x_server $self->{'xserver_param'}");
}

##################################################################
# installTF:
# installs the Java TestFrame depending on the informations we
# have already figured out.
##################################################################
sub installTF {
    $self = shift;
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
    $ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
    		$ENV{'SQLPORT'}         = $self->{'localport'};

    $self->update_idobjstatus(1111); 
    
    # Extract alltestpkg.sar :
    my ($rc, $sig, $core, $outbuf) = &doCmd($self, "cd $self->{'tempdir'} && SAPCAR -xvf $self->{'srcdir'}" . $self->{'delimit'} . "test" . $self->{'delimit'} . "jtest" . $self->{'delimit'} . "alltestpkg.sar");
    if ($rc != 0) {
        send_error($self, 1119, $rc, $sig, $core, "Error: TestFrame installation - SAPCAR failed.", $outbuf);
    }
    ($rc, $sig, $core, $outbuf) = &doCmd($self, "cd $self->{'tempdir'} && perl jtinstall.pl -n -jr $self->{'jtest_root'} -ir $self->{'dbroot'}");

    if ($rc != 0) {
        send_error($self, 1119, $rc, $sig, $core, "Error: TestFrame installation - jtinstall failed.", $outbuf);
    }
    else   {   
    	$self->update_idobjstatus(1120); 
    }
    &start_wahttp($self);
}

##################################################################
# runTF:
# run the Java TestFrame.
##################################################################
sub runTF {
	$self = shift;
	my %tests = ();
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	$ENV{'SQLPORT'}          = $self->{'localport'};

	
	&doCmd($self, "irconf -a");
	
	my $testlist;
	if ($self->{'profile'} =~ /weekend/) {
		$testlist = $self->{'qah'}->{weekendtests};
	}
	else {
		$testlist = $self->{'qah'}->{worktests};
	}
	
	foreach my $x (@$testlist) {
		$tests{$x} = $self->{'qah'}->{'testnames'}->{$x};
	}
	
	$myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);
	
	while (($key, $value) = each(%tests)) {
		$tests{$key} = $value . $myNameAppend;
	}
	
	my @testq = keys(%tests);
	
	
	my $qmsg = "The following tests will be performed:<BR><OL>";
	
	foreach $x (@$testlist) {
		$qmsg .= "<LI>$x (" .  $tests{$x} . ")</LI>";
	}
	
	$qmsg .= "</OL>";
	
	$self->{'qah'}->write_log($qmsg);
	
	$self->update_idobjstatus(2000);  ## START OF TESTING
	
	&doCmd($self, "dbmcli dbm_version");
	
	foreach $x (@$testlist) {
		#
		# On Tru64, we got only Client Software to test. This should be tested againt HP-UX for IA64
		if (($self->{'version'} =~ /7600/) && ($self->{'qah'}->{'IDPLATFORM'} == 2)) {
			$cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -n hs0116 -R /SAP_DB/7500RAMP/db -port 7210 -bits $self->{'bits'} -scheduled -monitor -MAKEKEY $self->{'qah'}->{'ID'}  -QA $self->{'status'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{'qah'}->{'CHANGELIST'} -d $tests{$x} $x \n");
			&doCmd($self, $cmd);
			next;
		}
		
		$cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -port $self->{'localport'} -bits $self->{'bits'} -scheduled -monitor -MAKEKEY $self->{'qah'}->{'ID'}  -QA $self->{'status'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{'qah'}->{'CHANGELIST'} -d $tests{$x} $x \n");
		
		&doCmd($self, $cmd);
	}
	
	$self->{'qah'}->write_log("All Tests are done.");
	
	$self->update_idobjstatus(3000);  ## END OF TESTING
	return $self->{qah}->check_lcok();
}

#
# This Method is for performing only a single test-sequence (mostly for debug-purposes)
sub run_single_test {
	$self = shift;
	$testname = shift;
	
	$ENV{'PATH'}         = $self->{'path'};
	$ENV{'HOME'}         = $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}   = $self->{'jtest_root'};
	$ENV{'INSTROOT'}     = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}    = $self->{'testdir'};
	$ENV{'TESTROOT'}     = $self->{'testdir'};
	$ENV{'SAPDBSDK'}     = $self->{'sapdbsdk'};
	$ENV{'TMP'}          = $self->{'tempdir'};
	$ENV{'TEMP'}         = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	
	my %tests            = ();
	
	$tests{"$testname"} = $self->{'qah'}->{'testnames'}->{$testname};
	
	
	$myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);
	while (($key, $value) = each(%tests)) {
		$tests{$key} = $value . $myNameAppend;
	}
	
	my @testq = keys(%tests);
	
	if ($options{'verbose'}) {
		print "The following tests will be performed:\n\n";
		foreach $x (@testq) {
			print "$x\t (Testname = ${tests{$x}})\n";
		}
	}
	
	foreach $x (@testq) {
		$cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -port $self->{'localport'} -bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} -MAKEKEY $self->{'qah'}->{'ID'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{qah}->{'CHANGELIST'} -d $tests{$x} $x \n");
		&doCmd($self, $cmd);
	}
	return;
}

sub run_lowtrack {
    # For letting the SUT run parallel
    $self = shift;
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
    $ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
    
    my %tests = ();
    
    sleep(10);
    my $testlist;
    if ($self->{'profile'} =~ /weekend/) {
        $testlist = $self->{'qah'}->{'lowtests_we'};
    }
    else {
        $testlist = $self->{'qah'}->{'lowtests'};
    }
    
    foreach my $x (@$testlist) {
        $tests{$x} = $self->{'qah'}->{'testnames'}->{$x};
    }
    
    
    $myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);
    
    while (($key, $value) = each(%tests)) {
        $tests{$key} = $value . $myNameAppend;
    }
    
    my @testq = my @testq = keys(%tests);;
    
    if ($options{'verbose'}) {
        print "The following tests will be performed:\n\n";
        foreach $x (@testq) {
            print "$x\t (Testname = ${tests{$x}})\n";
        }
    }

    # Paralell running tests should run in reverted sequences for avoiding
    # lock-problems with conflicting tests (this is mainly done for the
    # oltptest-sequence)

    foreach $x (@testq) {
        $cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -bits $self->{'bits'} -port $self->{'localport'} -scheduled -monitor -QA $self->{'status'} -MAKEKEY $self->{'qah'}->{'ID'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{qah}->{'CHANGELIST'} -d $tests{$x} $x \n");
        &doCmd($self, $cmd);
    }
    
    return 0;
}

#
# Helpers
#

sub doCmd {
	my $self    = shift;
	$kommando = pop(@_);
	my $rc      = 0;
	my $sig     = 0;
	my $core    = 0;
	
	my $outbuf = "CMD: \r\n $kommando \r\n";
	
	if (!($kommando =~ /^..*$/)) {
		return;
	}
	    
	
	if (!($self->{'dry'})) {
		
		$outbuf .= `$kommando 2>&1`;
		
		$rc = ($? >> 8);    # Evaluate return code by dividing by 256
		$signum = ($? & 127);   # get the signal caused the program to abort
		$core = ($? & 128); # get any core errors, if exist
		
		if (length($outbuf) < 1000) {
			$self->{qah}->write_log($outbuf);
		}
		else {
			if (length($kommando) > 299) {
				$kommando = substr($kommando, 0, 290) . "...";
			}
			
			$self->{qah}->write_prot("p" . $self->{'prot_count'} . $$, $outbuf, $kommando);
			$self->{'prot_count'}++;
		}
		if ($self->{qah}->{error_code} != 0) {
			print "Error in output-handling of $kommando \nI will ignore it.\nOutput:\n$outbuf";
			$self->{qah}->{error_code} = 0;
		}
	}
	return wantarray ? ($rc, $sig, $core, $outbuf) : $rc;
}

##################################################################
# get_free_FH
#
# A 'bit dirty version' to get a unique filename for output.
##################################################################
sub get_free_FH
{
  my $count = 1;
  my $outstr = $count . ".out";

  while (-e $outstr)
  {
    $count ++;
    $outstr = $count . ".out";
  }

  return $outstr;
}

#############################
# update_idobjstatus
#############################
sub update_idobjstatus
{
	my $self = shift;
	my $IDOBJSTATUS = shift;
	unless ($self->{'no_objstat'}) {
		if ($self->{'qah'}->{'SESSION_ID'}) {
			$self->{'qah'}->execDML("UPDATE install_sessions SET IDOBJSTATUS = $IDOBJSTATUS WHERE ID = " . $self->{'qah'}->{'SESSION_ID'});
		} else {
			$self->{'qah'}->update_columns({'IDOBJSTATUS' => $IDOBJSTATUS});
		}
	}
}


##################################################################
# send_error
#
# Reports an error via email and updates the status in qadb
##################################################################
sub send_error
{
	my $self = shift;
	my ($errcode, $rc, $sig, $core, $errstr, $outstr) = @_;

	my $smtp = Net::SMTP->new("mail.sap-ag.de");
	$smtp->mail("remuser\@$self->{'hostname'}.wdf.sap-ag.de");
	$smtp->to("falko.flessner\@sap.com", "ulrich.jansen\@sap.com", "gerald.arnold\@sap.com");
	$smtp->data();
	#$smtp->datasend("To: falko.flessner\@sap.com; ulrich.jansen\@sap.com\n");
	$smtp->datasend("Subject: $self->{'hostname'} / TESTDB Error - $errstr ($errcode)\n");
	#$smtp->datasend("Priority: Urgent\nX-Priority: 1 (Highest)\n");
	$smtp->datasend("\n");
	$smtp->datasend("Platform      : $self->{'hostname'}\n");
	$smtp->datasend("Time          : " . (scalar localtime) . "\n\n");
	$smtp->datasend("Error Code    : $errcode\n\n");
	$smtp->datasend("Error Text    : $errstr\n\n");
	$smtp->datasend("Return Code   : $rc\n");
	$smtp->datasend("Signal cought : $sig (1=Yes, 0=No)\n");
	$smtp->datasend("Core error    : $core (1=Yes, 0=No)\n");
	$smtp->datasend("HTML Link     : http://pts.wdf.sap.corp:1081/TestMonitor/Make_Details.jsp?id=$self->{qah}->{ID}\n\n");
	$smtp->datasend("Original program output:\n\n");
	$smtp->datasend("$outstr\n");
	$smtp->dataend();
	$smtp->quit();
	
	$self->update_idobjstatus("$errcode");
	$self->{qah}->write_log("$errstr RC=$rc SIG=$sig CORE=$core");
}


sub throw_err
{
    my ($err_text, $rc) = @_;
	my ($oldpkg, $oldfile, $errstr) = (0, "", "", "");

	for (my $i=0; (caller($i))[0]; $i++) {
    	if (((caller($i))[0] ne $oldpkg) || ((caller($i))[1] ne $oldfile)) {
    		$errstr .= "\n  Package '" . (caller($i))[0] . "' in file '" . (caller($i))[1] . "':\n\n";
    		$oldpkg = (caller($i))[0];
    		$oldfile = (caller($i))[1];
       	}
    	$errstr .= "    Func '" . (caller($i))[3] . "' called in line " . (caller($i))[2] . "\n";
    }
	my $component = basename($oldfile);
    print "\n**********************************************************\n";
    print "\n$component reported an error:\n\n";
    print "Info:\n\n$err_text\n\n" if ($err_text);
    print "Function trace:\n";
	print "$errstr\n";
    print "\n**********************************************************\n\n";
    if ($rc) {
    	print "Exiting...\n";
    	exit ($rc ? $rc : 10);
    }
}

# parameter: file with full path or directory with "/" at the end
sub checkdir
{
	local $path = shift;
	# convert \ to /
	$path =~ s/\\/\//g;
	if ($path =~ /^(.*)\/[^\/]*$/) {
		unless ( -d "$1" ) {
			mkpath("$1", 0775) || throw_err "can't mkdir $path : $!";
		}
	}
}



sub create_chr {
	my $self = shift;
	my $dir_prefix = $self->{'chr_prefix'};
	my $ftphost = "hs0030.wdf.sap.corp";
	my $ftpuser = "lcroot";
	my $ftppass = "Lroot";
	my $newuid;
	my $newgid;
	my $ftppath = "/SAP_DB/chr-arch/chr-" . $self->{'hostname'} . ".cpio.gz";
	my $lockname = "/usr";
	my @check_dirs;

	# The following process should be locked 
	my $lfh = Sema_Lock('/tmp/chr.lock');
	
	print "Creating new changeroot:\n";

	# Find out into which directory the chr-tree should be extracted

	if ($self->{'dir'}) { push @check_dirs, $self->{'dir'};	} 
	else				{ push @check_dirs, @{$self->{'dir_names'}}; }

	$self->{'target'} = "";

	# Now, let's check for a spare chr (only one in queue, if $self->{dir} was given):
	foreach my $dir (@check_dirs) {
		print "\tChecking dir $dir..";
		if (-e $dir_prefix . $dir . $lockname) {
			print "..in use!\n";
			next;
		}
		print "..OK\n";
		$self->{'dir'} = $dir;
		$self->{'target'} = $dir_prefix . $dir;
		$self->{'localport'} = int($self->{'port_base'}) + int($dir);
		$self->{'nisslport'} = int($self->{'nissl_portbase'}) + int($dir);
		$self->{'xserver_param'} .= $self->{'localport'};
		print "\tLocalport....$self->{'localport'}\n";
		last;
	}

	# Abort, if we didn't find any chr:
	unless ($self->{'target'})
	{
		$self->{'qah'}->write_log("ERROR: Could not find any spare changeroot directory!");
		print "\tNo spare changeroot found! Aborting...\n";
		return 0;
	}
	$self->{'qah'}->write_log("Create a new chr-area: $self->{'dir'}");
	
	print "\tWriting config to $dir_prefix/etc/$self->{'dir'}...." . (IniFile::SaveSimpleCfg("$dir_prefix/etc/$self->{'dir'}", {'IDMAKE' => $self->{'qah'}->{'ID'}, 'IDSESSION' => $self->{'qah'}->{'SESSION_ID'}}) ? "OK":"FAILED")  . "\n";

		#Create the directory and unlock
	mkdir ($self->{'target'}, 0777);
	
	#
	# Update install_sessions;
	print "\tUpdating install_sessions..";
	$self->{'qah'}->execDML("UPDATE install_sessions SET chrcnt = '" . $self->{'dir'} . "' WHERE id = " . $self->{'qah'}->{'SESSION_ID'});
	print "..OK\n";
	
	# Fetch the archive by ftp and extract it
	print "\tChanging dir to '$self->{'target'}'..";
	unless (chdir($self->{'target'})) {
		print "..FAILED!\n";
		return 0;
	}
	print "..OK\n";

	print "\tUnpacking cpio archive: ";
	open (TAROUT, "|gzip -d | cpio -id$self->{'cpio_param'} ");
	
	$ftp = Net::FTP->new($ftphost);
	$ftp->login($ftpuser, $ftppass);
	$ftp->binary();
	$ftp->get($ftppath, \*TAROUT);
	close TAROUT;
	
	#############
	if (!(($self->{'version'} =~ /7600/) && ($self->{'qah'}->{'IDPLATFORM'} == 2))) {

	print "\tPatching /etc/services..";
	my @services;
	unless (open(SERV, "<$self->{'target'}/etc/services")) {
		print "..failed to read file!\n";
		return 0;
	}
	while (<SERV>) { push @services, $_ if (!/^\s*sql6/); }
	close (SERV);
	unless (open(SERV, ">$self->{'target'}/etc/services")) {
		print "..failed to write file!\n";
		return 0;
	}
	push @services, "sql6            " . $self->{'localport'} . "/tcp #added by testdbchr\n";
	push @services, "sdbnissl76      " . $self->{'nisslport'} . "/tcp #added by testdbchr\n";
	foreach my $service (@services) { print SERV $service; }
	close (SERV);
	print "..OK\n";
	}
	
	print "\tPatching $self->{'target'}/etc/passwd..";
	unless (open(PASSWD, "<$self->{'target'}/etc/passwd")) {
		print "..failed to read file!\n";
		return 0;
	}
	my $pwbuf = "";
	while (<PASSWD>) {
		if ($_ =~ /^remuser:/) {
			my @pwfields = split/:/;
			$pwfields[5] = $self->{'tempdir'};
			$pwbuf .= join(":", @pwfields);
		} else {
			$pwbuf .= $_;
		}
	}
	close (PASSWD);

	my $mode = (stat("$self->{'target'}/etc/passwd"))[2];
	chmod 0600, "$self->{'target'}/etc/passwd";
	
	unless (open(PASSWD, ">$self->{'target'}/etc/passwd")) {
		print "..failed to read file!\n";
		return 0;
	}
	print PASSWD $pwbuf;
	close (PASSWD);
	chmod $mode, "$self->{'target'}/etc/passwd";
	
	print "..OK\n";
	
	
	#
	print "\tCopying SAPDB_COMPONENTS..";
	print (cp_dir($self->{'srcdir'} . "/SAPDB_COMPONENTS", $self->{'target'} . $self->{'srcdir'} . "/SAPDB_COMPONENTS") ? "..OK\n" : "..FAILED!\n");
	print "\tCopying TEST_COMPONENTS..";
	print (cp_dir($self->{'srcdir'} . "/TEST_COMPONENTS", $self->{'target'} . $self->{'srcdir'} . "/TEST_COMPONENTS") ? "..OK\n" : "..FAILED!\n");
	print "\tCopying test directory..";
	print (cp_dir($self->{'srcdir'} . "/test", $self->{'target'} . $self->{'srcdir'} . "/test") ? "..OK\n" : "..FAILED!\n");

	if (($self->{'version'} == 7500) && (($self->{'qah'}->{'IDPLATFORM'} == 6) || ($self->{'qah'}->{'IDPLATFORM'} == 13) || ($self->{'qah'}->{'IDPLATFORM'} == 15) || ($self->{'qah'}->{'IDPLATFORM'} == 17))) {
		print "\tExtracting /usr/scratch/d038447/instgui/" . $self->{'platform'} . "/* ..";
		&doCmd($self, "cd $self->{'target'}/tmp && tar -xvzf /usr/scratch/d038447/instgui/$self->{'platform'}/*");
		
		print "..OK\n";
		
	}
	
	if ($self->{'version'} == 7500) {
		&hang_in($self, '7403', 'DEV');
	}

	
	Sema_Unlock($lfh);
	
	foreach my $dirent ($self->{'rootdir'} . $self->{'node'}, $self->{'tempdir'}, $self->{'dbroot'}, $self->{'testdir'}) { 
		if (not(-d $dirent)) {
			mkdir $dirent, 0777;
		}
	}
	
	$self->{'qah'}->execDML("UPDATE chrs SET idmake = $self->{'qah'}->{'ID'}, idchr_stat = 2 WHERE idserver = $self->{'qah'}->{'IDSERVER'} AND chrcnt = '" . $self->{'dir'} . "'");
	$self->{'qah'}->write_log("UPDATE chrs SET idmake = $self->{'qah'}->{'ID'}, idchr_stat = 2 WHERE idserver = $self->{'qah'}->{'IDSERVER'} AND chrcnt = '" . $self->{'dir'} . "'");
	
	print "\tStamping $self->{'target'}/$self->{'dir'} to $self->{'qah'}->{'ID'}..";
	unless (open (REGFH, ">$self->{'target'}/$self->{'dir'}")) {
		print "..FAILED!\n";
		return 0;
	}
	print REGFH  $self->{'qah'}->{'ID'} . "\n";
	close REGFH;
	print "..OK\n";
	return 1;
}


sub jump_in_chr {
	$self = shift;

	print "Jumping into changeroot..";
	
	unless (chroot($self->{'target'}))
	{
		print "..failed to change root to '$self->{'target'}'!\n";
		return 0;
	}
	
	&doCmd($self, $self->{'cpio_prepare'});
	
	$newuid = (getpwnam('remuser'))[2];
	$newgid = (getpwnam('remuser'))[3];
	
	$newgid .= " " . scalar(getgrnam($self->{'group'}));
	
	$) = $newgid;
	$( = $newgid;
	($<, $>) = ($newuid, $newuid);
	($<, $>) = ($newuid, $newuid);
	($<, $>) = ($newuid, $newuid);
	
	if ($self->{'use_posix'} == 1) {
		$self->{'qah'}->write_log("Entering POSIX-Area");
		POSIX::setuid($newuid);
	}
	
	$self->{'qah'}->write_log("SUCCESS: Just changed UID<BR>UID remuser = " . (getpwnam('remuser'))[2] . "<BR>GID remuser = " . (getpwnam('remuser'))[3] . "<BR>UID = " . $< . "<BR>EUID = " . $> . " <BR>GID = " . $( . "<BR>EGID =" . $) );

	&doCmd($self, $self->{'idcmd'});
	&doCmd($self, "uname -a");

	if ($< == 0) {
		print "..failed to change user to remuser!\n";
		$self->{'qah'}->write_log("Could not change to remuser!");
		return 0;
	}
	
	close SERV;
	$self->{'in_chr'} = 1;
	umask 0000;
	print "..OK\n";
	return 1;
}

sub su_jump_in_chr {
	$self = shift;
	
	chroot($self->{'target'}) or die "Can not chroot to $self->{'target'}: $!\n";
	&doCmd($self, $self->{'cpio_prepare'});
	
	&doCmd($self, $self->{'idcmd'});
	
	close SERV;
	$self->{'in_chr'} = 1;
	umask 0000;
	return;
}



sub verify_chr {
	
	my ($self, $single_dir) = @_;
	my $rc = 1;
	
	my @dirlist;

	push @dirlist, ($single_dir ? $single_dir : @{$self->{'dir_names'}});

	if ($single_dir) {
		print "Verifying changeroot $single_dir..";
	} else {
		print "Verifying changeroots:\n";
	}

	foreach my $dir (@dirlist) {
		print "\tchr $dir.." unless ($single_dir);
		if (-e "$self->{'chr_prefix'}/etc/$dir") {
			my ($etc_id, $chr_id) = (0, 0);
			
			my $etc_ref = IniFile::load("$self->{'chr_prefix'}/etc/$dir");
			$etc_id = $etc_ref->{'IDMAKE'};
			unless (open (IN_FILE, "<$self->{'chr_prefix'}/etc/$dir")) {
				print "..failed to open file '$self->{'chr_prefix'}/etc/$dir'!\n";
				$rc = 0;
				next;
			}
			while (<IN_FILE>) { $etc_id = $1 if (/^(\d+)$/); }
			close (IN_FILE);
			unless (open (IN_FILE, "<$self->{'chr_prefix'}/$dir/$dir")) {
				$self->{'qah'}->write_log("ERROR: Changeroot-Verify:<BR>A mistake was found: $self->{'chr_prefix'}/$dir/$dir could not be opend!");
				print "..failed to open file '$self->{'chr_prefix'}/$dir/$dir'!\n";
				$rc = 0;
				next;
			}
			while (<IN_FILE>) { $chr_id = $1 if (/^(\d+)$/); }
			close (IN_FILE);
			if ($etc_id != $chr_id) {
				$self->{'qah'}->write_log("ERROR: Changeroot-Verify:<BR>The stored make-IDs do not match:<BR>$self->{'chr_prefix'}/etc/$dir $idmake - $self->{'chr_prefix'}/$dir/$dir $sek_idmake\n");
				print "..id in etc ($etc_id) differs from chr id ($chr_id)!\n";
				$rc = 0;
				next;
			} else {
				print "..OK\n";
			}
		} elsif (-e "$self->{'chr_prefix'}/$dir") { 
			$self->{'qah'}->write_log("ERROR: Changeroot-Verify:<BR>There is an unwantetd directory: $self->{'chr_prefix'}/$dir");
			print "..found directory but no etc entry!\n";
			$rc = 0;
		} else {
			$self->{'qah'}->execDML("UPDATE chrs SET idmake = NULL, idchr_stat = 1 WHERE idserver = $self->{'qah'}->{'IDSERVER'} AND chrcnt = '$dir'");
			print "..not active.\n";
		}
	}
	print "\n" unless ($single_dir);
	return $rc;
}



sub destroy_chr  {
	$self = shift;
	
	print "Destroying chr $self->{'dir'}:\n";
	print "\tUnmounting proc directory.." . (doCmd($self, "umount $self->{'chr_prefix'}$self->{'dir'}/proc") == 0 ? "..OK\n" : "..FAILED!\n");
	print "\tUnmounting dev/pts directory.." . (doCmd($self, "umount $self->{'chr_prefix'}$self->{'dir'}/dev/pts") == 0 ? "..OK\n" : "..FAILED!\n");
		print "\tRemoving directories.." . (doCmd($self, "rm -rf $self->{'chr_prefix'}etc/$self->{'dir'} $self->{'target'}") == 0 ? "..OK\n" : "..FAILED!\n");
	$self->{'qah'}->execDML("UPDATE chrs SET idmake = NULL, idchr_stat = 1 WHERE idserver = $self->{'qah'}->{'IDSERVER'} AND chrcnt = '$self->{'dir'}'");
	return 0;
}



sub Sema_Lock
{
	my $lockfile = shift;
	
	use Fcntl ':flock';
	use FileHandle;
	print "Locking file '$lockfile' by PID $$..";
	
	my $fh = new FileHandle (">$lockfile");
	if ($fh) {
		flock ($fh, LOCK_EX);
		print "..OK\n";
	} else {
		print "..FAILD\n\t$!\n";
		return undef;
	}
	
	return $fh;
}

sub Sema_Unlock
{
	my $fh = shift;
	
	print "Unlocking by PID $$..";
	flock($fh, LOCK_UN);
	$fh->close;
	print "..OK\n";
}

sub cp_dir {
	my $src_dir  = shift;
	my $dest_dir = shift;
	
	my $bufsize = 1019200;
	my $io_buf;
	
	if ((not defined $src_dir) or (not defined $dest_dir)) {
		return 0;
	}
	
	my @dir_list = split('/', $dest_dir);
	my @create_list = ();
	
	while (scalar(@dir_list) > 0) {
		if (-d join('/', @dir_list)) {
			last;
		}
		push(@create_list, pop(@dir_list));
	}
	
	while (scalar(@create_list) > 0) {
		push(@dir_list, pop(@create_list));
		mkdir (join('/', @dir_list), 0777);
	}
	
	if (not (-w $dest_dir)) {
		return 0;
	}
	
	if (not(-d $src_dir)) {
		return 0;
	}
	
	my $src_hdl = new IO::Handle;
	
	opendir ($src_hdl, $src_dir);
	
	while (my $cp_name = readdir($src_hdl)) {
		if ($cp_name =~ /^\./) {
			next;
		}
		
		if (-d ($src_dir  . "/" . $cp_name))  {
			if (-r $src_dir  . "/" . $cp_name) {	
				&cp_dir($src_dir . "/" . $cp_name, $dest_dir . "/" . $cp_name);
			}
			my @orig_stat = stat($src_dir . "/" . $cp_name);
			chmod ($orig_stat[2], ($dest_dir . "/" . $cp_name));
			chown $orig_stat[4], $orig_stat[5], ($dest_dir . "/" . $cp_name);
			next;
		} elsif (not ((-f ($src_dir  . "/" . $cp_name)) or (-l ($src_dir  . "/" . $cp_name))))  {
			next;
		}
		
		
		open (I_HDL,       $src_dir  . "/" . $cp_name) or next;
		open (O_HDL, ">" . $dest_dir . "/" . $cp_name) or return 0;
		
		#print $src_dir . "/" . $cp_name;
		while (read(I_HDL, $io_buf, $bufsize)) {
			print O_HDL $io_buf;
			#print "#";
		}
		#print "\n";
		
		close I_HDL;
		close O_HDL;
		my @orig_stat = stat($src_dir . "/" . $cp_name);
		chmod ($orig_stat[2], ($dest_dir . "/" . $cp_name));
		chown $orig_stat[4], $orig_stat[5], ($dest_dir . "/" . $cp_name);
	}
	closedir($src_hdl);
	return 1;
}

sub instloginit {
	$self = shift;
	
	$self->{'sdbinstlogfile'} = "/tmp/l" . $self->{'log_count'} . $$;
	$ENV{'SDBINSTLOGFILE'} = $self->{'sdbinstlogfile'};
}

sub instlogwrite {
	$self = shift;
	$infotext = shift;
	my $sdbinstlog = " \n";
	if (-e $self->{'sdbinstlogfile'}) {
		open (LFH, $self->{'sdbinstlogfile'});
		while (<LFH>) {
			$sdbinstlog .= $_;
		}
		close LFH;
		
		$self->{'qah'}->write_prot("l" . $self->{'log_count'} . $$, $sdbinstlog, $infotext);
		if ($self->{qah}->{error_code} != 0) {
			print "Error in handling of $self->{'sdbinstlogfile'} \nI will ignore it.\nOutput:\n$sdbinstlog";
			$self->{qah}->{error_code} = 0;
		}
	}
	$self->{'log_count'}++;
}

sub hang_in {
	#
	# Copies another Tree from the original BAS-Tree to a chroot-Bas-Tree
	# Requires a version and a qastatus as Parameters.
	
	$self = shift;
	my $version = shift;
	my $qastatus = shift;
	
	my $qah = qadb->new_test({'QASTATUS' => $qastatus, 'VERSION' => $version});
	
	my $subdir;
	my $srcdir;
	my $srcfile;
	my $build;
	
	if (!(defined $self->{'target'})) {
		return;
	}
	
	if (($qastatus =~ /RAMP/) or ($qastatus =~ /HOT/)) {
		@subdirs		= glob ("/bas/SAP_DB/$version/pkg/$self->{'platform'}/LC_$version??_$self->{'bits'}_$qastatus");
		sort (@subdirs);
		$subdir			= pop(@subdirs);
		$srcdir			= "$subdir/" . $qah->{'LCPOOLID'};
		@files			= (glob "$subdir/" . $qah->{'LCPOOLID'} . "/SAPDB" . $version . "*.SAR");
		$srcfile		= pop(@files);
		$build			= substr($self->{'subdir'}, length("/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}"), 2);
	}
	else {
		$subdir			= "/bas/SAP_DB/$version/pkg/$self->{'platform'}/LC_" . $version . "_$self->{'bits'}_$qastatus";
		$srcdir			= "$subdir/" . $qah->{'LCPOOLID'};
		@files			= (glob "$srcdir/SAPDB" . $version . "/*.SAR");
		$srcfile		= pop(@files);
		$build			= substr($srcfile, -6 ,2);
	}
	
	&cp_dir($srcdir . "/SAPDB_COMPONENTS", $self->{'target'} . $srcdir . "/SAPDB_COMPONENTS");
	&cp_dir($srcdir . "/TEST_COMPONENTS", $self->{'target'} . $srcdir . "/TEST_COMPONENTS");
	&cp_dir($srcdir . "/test", $self->{'target'} . $srcdir . "/test");
	
	$self->{$version . $qastatus . "subdir"}  = $subdir;
	$self->{$version . $qastatus . "srcdir"}  = $srcdir;
	$self->{$version . $qastatus . "srcfile"} = $srcfile;
	$self->{$version . $qastatus . "build"}   = $build;
	
	#
	# The following will set the idmake_cpc in the install_sessions table
	# I assume that this sub will only be called for hanging in C 
	# Precompiler packages. If it is used otherwise, the following needs
	# to be removed and packed into a own sub
	#
	$self->{'qah'}->execDML("UPDATE install_sessions SET IDMAKE_CPC = $qah->{'ID'} WHERE id = $self->{'qah'}->{'SESSION_ID'}");
}

sub start_wahttp {
	my $self = shift;
	
	my $myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);
	
	$ENV{$self->{'libpath'}} = $self->{'indeppath'} . "/lib:" . $self->{'indeppath'} . "/lib/lib64:" . $self->{'indeppath'} . "/web/lib:" . $self->{'indeppath'} . "/web/lib/lib64:";
	my $port = int($self->{'wa_portbase'}) + int($self->{'dir'});
	my $port_webdav = int($self->{'wa2_portbase'}) + int($self->{'dir'});
	my $port_nissl  = int($self->{'nissl_portbase'}) + int($self->{'dir'});
	
	
	&doCmd($self, "cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -port $self->{'localport'} -bits $self->{'bits'} -scheduled -MAKEKEY $self->{'qah'}->{'ID'}  -QA $self->{'status'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{'qah'}->{'CHANGELIST'} -G KEEP,WARM -d WD$myNameAppend -mail off -c oltptest.cfg notest\n");
	&doCmd($self, "cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -port $self->{'localport'} -bits $self->{'bits'} -scheduled -MAKEKEY $self->{'qah'}->{'ID'}  -QA $self->{'status'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{'qah'}->{'CHANGELIST'} -G KEEP,WARM -d WS$myNameAppend -mail off -c oltptest.cfg notest\n");
	
	$self->{'qah'}->write_log("Starting wahttp<BR><TT>" . $self->{'libpath'} . " = " . $ENV{'LD_LIBRARY_PATH'} . "<BR>PORT = $port<BR>Starting wahttp for webdav<BR><TT>" . $self->{'libpath'} . " = " . $ENV{'LD_LIBRARY_PATH'} . "<BR>PORT = $port_webdav");

	system("cd $self->{'indeppath'}/web/pgm ; ./wahttp -p $port &");
	system("cd $self->{'indeppath'}/web/pgm ; ./wahttp -p $port_webdav &");
#	&async_start("cd $self->{'indeppath'}/web/pgm ; ./wahttp -p $port", 1);
#	&async_start("cd $self->{'indeppath'}/web/pgm ; ./wahttp -p $port_webdav", 2);
	
	if ($self->{'version'} >= 7600) {
		&doCmd($self, "x_server -w -S $port_nissl ");
	}
}

sub async_start {
	my $cmd = shift;
	my $counter = shift;
	my $ok = 0;
	print "Starting command '$cmd'..";
	if (open(CMD_OUT, "> /tmp/PID_$$.$counter")) {
		print CMD_OUT "$cmd";
		close (CMD_OUT);
		system ("at -f /tmp/PID_$$.$counter now; rm -f /tmp/PID_$$.$counter");
		$ok = 1;
		print "..OK\n";
	}
	unless ($ok) {
		print "..FAILED! Using synchronous method.\n";
		system("$cmd &");
	}
}

__END__

=head1 NAME

testdb - A perl module for testing SAP DB/liveCache-builds on preconfigured
testmachines.

=head1 NOTE

This module is intended for internal use only.
Although it is free software, it won't be very usefull for the wide world

=head1 CONSTRUCTOR

 use testdb;
 $tdh =  testdb->new({'version' => '7404', 'status' => 'DEV', 'profile' => 'weekend'}) ;

 if ($tdh->{error_code}) {
    print "Error:\n$tdh->{error_text}\n";
    return -1;
 }

=head1 DESCRIPTION

The C<testdb> class is a abstraction of the Tests in the SAP-internal QA-System
for SAP DB and liveCache.

With C<testdb>, you can clean up the system, install the latest makes, install all
compononts required for testing execute the tests.

=over 4

=item Prepare for the

A couple of informations are required to create a new entry. Following
the perl standards, the constructor of the class is named C<new>. It
requires a hash-reference with the following entries:

  Name          Description                   Example value

 version       4-digit Version              '7402'
 status        The quality-status           'DEV'
 profile       The test-profile             'workday' or 'weekend'

For AIX-Machines, the aditional "PLATFORM"-entry is required. This is
necssary becase the perl-interpreter does not make a difference between
AIX 4.x and AIX 5.x as we do it.

Currently, the followning values are accepted for PLATFORM:

    - sun_64
    - alphaosf
        - rs6000_51_64
    - rs6000_64
    - hp_64

Please keep in mind that a C<qadb>-instance normaly contains a variable
called C<ID> (you can access it with B<$qah-E<gt>{'ID'}>. This C<ID> identifies
a make-entry and will be needed later. So, I suggest to write this C<ID>
to the harddisk.

=back

=head1 METHODS

C<qadb> provides the following methods:

=over 4

=item $rv = update_columns({name1 => value1, ... , nameN => valueN});

Performs a update-statement on the main table. This should only be used
for updating IDOBJSTATUS, LCPOOLID, LC_OK and LCOK_TRANS.

It takes a hash-reference as arguement, filled with columnnames and the
corresponing values.

The "VARIABLES"-Section of this manual contains a complete description of all
fields.

Returns 0 on success.

=item $rv = write_log($log_text);

This adds a comment to the entry. The log-Text must not contain more than
1000 characters.

Returns 0 on success.

=item $rv = write_prot($prot_name, $prot  [, $info_text]);

Writes a protocoll to the WebDAV-server and creates a entry in the
appropriate table in the database.

It takes a protocolname, the protocol itself and a optional info text as
arguments.

If the info text is not provieded, the protocolname will be used for it.

Returns 0 on success.

=item $rv = unlock();

Releases the current DB-Connection, but don't forget about the Values.

This becomes necessary when the program forkes. See B<lock> for
further informations

Returns 0 on success.

=item $qah = lock();

Re-Creates the DB-Connection. This becomes necessary after performing
an B<unlock> in forking situations.

B<TAKE CARE:> this method will return a new instance. Overwrite the current one
with it. The following example will give you an idea how to do this:

   $qah->unlock();
   $pid = fork();
   $qah = $qah->lock();

   if ($pid) {
       #
       # go on here


=back

=head1 VARIABLES

C<qadb> contains the following variables. Variables corresponding with
fields in the database are marked with a X.

Please note that B<IDQASTATUS> and B<IDPLATFORM> differ from the
parameters B<QASTATUS> and B<PLATFORM> for the C<new>-constructor. The values stored in the
database are simple numeric representations of their alphanumeric
assignments. These assignments are stored in the tables B<PLATFORMS>
and B<QASTATUS>.

  Name         DB-Variable       Description

 ID                X            Identifies the complete build-process
 LCPOOLID          X            The number in the LC_POOL-directory
 VERSION           X            A four-digit version, eg. "7402"
 BUILDPFX          X            A two-digit buildprefix, eg. "05"
 IDPLATFORM        X            The numeric id of the platform
 IDQASTATUS        X            The numeric id if the QA-status
 IDOBJSTATUS       X            The numeric id of the make-status
 CHANGELIST        X            The Changelist-number
 TS                X            The timestamp of the last modification
 LCOK              X            Will be set when the tests are finished
                                successfully.
 LCOK_TRANS        X            Will be set after the LCOK-bit is
                                transfered into the appropriate structures
                in the filesystem.
 HISTCOUNT         X            Counts the number of changes in on these
                                informations. Will be updated automaticaly.
 error_code                     Conains the last error code set. After
                                successfull opterations it will be set to
                0.
 error_text                     Contains a human-readable description of
                                the last error.

=head1 ERROR HANDLING

Beneath the already introduced variables B<error_code> and B<error_text>
for error handling, a email will be sent in each case of a detected error.

The recipients of these Mails are currently hard-coded.

=head1 DBI INSTANCE

C<qadb> contains a ready-to-use DBI instance. It can be accessed by
B<$qah-E<gt>{dbh}>. Please use this with extreme care and use it
only if you can not avoid it.

The DBI documentation describes it in depth.

=head1 EXAMPLE

 use qadb;
 my $qah =  qadb->new({'VERSION' => '7403',
    'BUILDPFX'   => '07',
    'QASTATUS'   => 'DEV',
    'CHANGELIST' => '12345'}) ;

 if ($qah->{error_code} != 0) {
    print "Fehler:\n$qah->{error_text}\n";
    return -1;
 }

 if ($qah->update_columns({'LCPOOLID' => '012'}) != 0 ) {
     print "Error while update:\n$qah->{error_text}\n";
     return -1;
 }

 if ($qah->write_log("Hallo Welt, dies ist ein Test")) {
     print "Error while writing a log:\n$qah->{error_text}\n";
     return -1;
 }

 my $protocol = "";
 open (PROTOFILE, "/path/to/protocol") or die "Error reading protocol\n";

 while (<PROTOFILE>) {
     $protocol .= $_;
 }

 if ($qah->write_prot("make.log", $protocol, "This protocol contains the make-output.\n")) {
     print "Error while writing protocol make.log:\n$qah->{error_text}\n";
 }

=head1 COPYRIGHT

Copyright 2002 SAP AG

=cut


