'\" t
.\" Manual page created with latex2man on Wed Dec  3 16:36:46 PST 2003
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_GET\\_PROC\\_INFO\\_BY\\_IP" "3" "03 December 2003" "Programming Library " "Programming Library "
.SH NAME
unw_get_proc_info_by_ip
\-\- get procedure info by IP 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_get_proc_info_by_ip(unw_addr_space_t as,
unw_word_t ip,
unw_proc_info_t *pip,
void *arg);
.br
.PP
.SH DESCRIPTION

.PP
The unw_get_proc_info_by_ip()
routine returns the same 
kind of auxiliary information about a procedure as 
unw_get_proc_info(),
except that the info is looked up by 
instruction\-pointer (IP) instead of a cursor. This is more flexible 
because it is possible to look up the info for an arbitrary procedure, 
even if it is not part of the current call\-chain. However, since it 
is more flexible, it also tends to run slower (and often much slower) 
than unw_get_proc_info().
.PP
The routine expects the followins arguments: as
is the 
address\-space in which the instruction\-pointer should be looked up. 
For a look\-up in the local address\-space, 
unw_local_addr_space
can be passed for this argument. 
Argument ip
is the instruction\-pointer for which the procedure 
info should be looked up and pip
is a pointer to a structure of 
type unw_proc_info_t
which is used to return the info. 
Lastly, arg
is the address\-space argument that should be used 
when accessing the address\-space. It has the same purpose as the 
argument of the same name for unw_init_remote().
When 
accessing the local address\-space (first argument is 
unw_local_addr_space),
NULL
must be passed for this 
argument. 
.PP
Note that for the purposes of libunwind,
the code of a 
procedure is assumed to occupy a single, contiguous range of 
addresses. For this reason, it is alwas possible to describe the 
extent of a procedure with the start_ip
and end_ip
members. If a single function/routine is split into multiple, 
discontiguous pieces, libunwind
will treat each piece as a 
separate procedure. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_get_proc_info_by_ip()
returns 0. Otherwise the negative value of one of the error\-codes 
below is returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_get_proc_info()
is thread\-safe as well as safe to use 
from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_ENOINFO
 Libunwind
was unable to locate 
unwind\-info for the procedure. 
.TP
UNW_EBADVERSION
 The unwind\-info for the procedure has 
version or format that is not understood by libunwind\&.
.PP
In addition, unw_get_proc_info()
may return any error 
returned by the access_mem()
call\-back (see 
unw_create_addr_space(3)).
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_create_addr_space(3),
unw_get_proc_name(3),
unw_get_proc_info(3),
unw_init_remote(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br 
Hewlett\-Packard Labs
.br 
Palo\-Alto, CA 94304
.br 
Email: \fBdavidm@hpl.hp.com\fP
.br
WWW: \fBhttp://www.hpl.hp.com/research/linux/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
