;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "MAXIMA")
;	** (c) Copyright 1982 Massachusetts Institute of Technology **

(macsyma-module dskfn)

(declare-top (GENPREFIX DK)
	 (SPECIAL $FILENAME $DEVICE $DIREC $STORENUM $FILENUM $DSKALL
		  $FILESIZE FILELIST FILELIST1 OPERS $PACKAGEFILE
		  FASDUMPFL FASDEQLIST FASDNONEQLIST SAVENOHACK
		  DSKSAVEP AAAAA ERRSET LESSORDER GREATORDER INDLIST
		  $LABELS $ALIASES VARLIST MOPL $PROPS DEFAULTF
		  $INFOLISTS $FEATURES FEATUREL SAVEFILE $GRADEFS
		  $VALUES $FUNCTIONS $ARRAYS PRINLENGTH PRINLEVEL
		  $CONTEXTS CONTEXT $ACTIVECONTEXTS)
	 (FIXNUM N $FILESIZE $STORENUM $FILENUM)
	 (*LEXPR $FACTS))


(SETQ FILELIST NIL FILELIST1 NIL $PACKAGEFILE NIL
      INDLIST (PURCOPY '(EVFUN EVFLAG BINDTEST NONARRAY SP2 SP2SUBS OPERS 
			 SPECIAL AUTOLOAD ASSIGN MODE)))

(DEFMSPEC $UNSTORE (FORM) (I-$UNSTORE (CDR FORM)))

(DEFMFUN I-$UNSTORE (X)
 (DO ((X X (CDR X)) (LIST (NCONS '(MLIST SIMP))) (PROP) (FL NIL NIL))
     ((NULL X) LIST)
     (SETQ X (INFOLSTCHK X))
     (WHEN (AND (BOUNDP (CAR X)) (MFILEP (SETQ PROP (SYMBOL-VALUE (CAR X)))))
	   (SETQ FL T)
	   (SET (CAR X) (EVAL (DSKGET (CADR PROP) (CADDR PROP) 'VALUE NIL))))
     (DO ((PROPS (CDR (OR (safe-GET (CAR X) 'MPROPS) '(NIL))) (CDDR PROPS))) ((NULL PROPS))
	 (COND ((MFILEP (CADR PROPS))
		(SETQ FL T)
		(COND ((MEMQ (CAR PROPS) '(HASHAR ARRAY))
		       (LET ((AAAAA (GENSYM)))
			 (SETQ PROP (DSKGET (CADADR PROPS)
					    (CADDR (CADR PROPS))
					    (CAR PROPS)
					    T))
			 (MPUTPROP (CAR X)
				   (IF (EQ PROP 'AAAAA) AAAAA (CAR X))
				   (CAR PROPS))))
		      (T (SETQ PROP (DSKGET (CADADR PROPS) (CADDR (CADR PROPS))
					    (CAR PROPS) NIL))
			 (MPUTPROP (CAR X) PROP (CAR PROPS)))))))
     (AND FL (NCONC LIST (NCONS (CAR X))))))

(DEFUN INFOLSTCHK (X)    
 ((LAMBDA (ITEML)
   (IF (EQ ITEML T) X (APPEND (OR ITEML '(NIL)) (CDR X))))
  (COND ((NOT (AND X (OR (MEMQ (CAR X) '($ALL $CONTEXTS))
			 (MEMQ (CAR X) (CDR $INFOLISTS)))))
	 T)
	((EQ (CAR X) '$ALL)
	 (INFOLSTCHK (APPEND (CDR $INFOLISTS)
			     '($LINENUM $RATVARS $WEIGHTLEVELS *RATWEIGHTS
			       TELLRATLIST $DONTFACTOR $FEATURES $CONTEXTS))))
	((EQ (CAR X) '$LABELS) (REVERSE (CDR $LABELS)))
	((MEMQ (CAR X) '($FUNCTIONS $MACROS $GRADEFS $DEPENDENCIES))
	 (MAPCAR #'CAAR (CDR (SYMBOL-VALUE (CAR X)))))
	((EQ (CAR X) '$CONTEXTS) (DELQ '$GLOBAL (REVERSE (CDR $CONTEXTS)) 1))
	(T (CDR (SYMBOL-VALUE (CAR X)))))))


(defun filelength (file)
  (file-length file))


(DEFMSPEC $SAVE (FORM) (DSKSETUP (CDR FORM) NIL NIL '$SAVE))


(DEFMFUN I-$STORE (X) (DSKSETUP X T NIL '$STORE))

(DEFMSPEC $FASSAVE (FORM) (DSKSETUP (CDR FORM) NIL T '$FASSAVE))

(defvar *macsyma-extend-types-saved* nil)

#-(OR CL NIL)
(DEFUN DSKSETUP (X STOREFL FASDUMPFL FN)
  (LET (#-cl(*NOPOINT T) PRINLENGTH PRINLEVEL OFILE FILE
	LIST FASDEQLIST FASDNONEQLIST MAXIMA-ERROR #+PDP10 LENGTH #+PDP10 OINT)
    #-Franz
    (SETQ FILE (COND (($LISTP (CAR X)) (PROG1 (FILESTRIP (CDAR X)) (SETQ X (CDR X))))
		     (T ;;Set OFILE to the last thing we wrote to.
			#-CL (SETQ OFILE (DEFAULTF ()))
			#+CL (SETQ OFILE (FILE-EXPAND-PATHNAME ""))
			;;Cons up a new filename if none specified in
			;;SAVE or STORE command.
			#+Multics
			(merror "First argument to ~:M must be a list.~
				 ~%~:M([/"myfile/"],all); is acceptable."
				FN FN)
			#-Multics
			(FULLSTRIP (LIST $FILENAME
					 (IF DSKSAVEP
					     (SETQ $STORENUM (f1+ $STORENUM))
					     (SETQ $FILENUM (f1+ $FILENUM)))
					 $DEVICE $DIREC)))))
    #+Franz (setq file (filestrip x) x (cdr x))
    ;;Lisp Machine FILESTRIP returns a string.  Fix later.
    #+LISPM (IF (STRINGP FILE) (SETQ FILE (UNEXPAND-PATHNAME FILE)))
    (DOLIST (U X)
      (COND ((ATOM U) (IF (NOT (SYMBOLP U)) (IMPROPER-ARG-ERR U FN)))
	    ((LISTARGP U))
	    ((OR (NOT (EQ (CAAR U) 'MEQUAL)) (NOT (SYMBOLP (CADR U))))
	     (IMPROPER-ARG-ERR U FN))))
    #-Franz
   (IF (AND STOREFL (EQ (CADR FILE) '>))
       (MERROR "> as second filename has not been implemented for STORE."))
   #+PDP10 (IF STOREFL (SETQ OINT (NOINTERRUPT 'TTY)))
   (COND (DSKSAVEP (SETQ FILELIST (CONS FILE FILELIST)))
	 (OFILE (SETQ FILELIST1 (CONS FILE FILELIST1))))
   ;;Create a stream to the file.  On ITS, use a hack to avoid repeated
   ;;creation of file arrays.
   #-Franz
   (LET ((TEMP-FILE #-Multics`(,(CARFILE (CDDR FILE)) |!SAVE!| OUTPUT)
		    #+Multics "macsyma.saved.output"))
     #+PDP10 (OPEN (CNAMEF SAVEFILE TEMP-FILE)
		   (IF FASDUMPFL '(OUT FIXNUM BLOCK) '(OUT ASCII)))
     #+CL (SETQ SAVEFILE (OPEN TEMP-FILE :DIRECTION :OUTPUT))
     #-(OR CL PDP10) (SETQ SAVEFILE (OPEN TEMP-FILE '(OUT ASCII))))
   #+Franz (setq savefile (outfile file))
   (LET ((*print-base* 10.))
     #-cl(SETQ *NOPOINT NIL)
     (WHEN (NULL FASDUMPFL)
	   (PRINC ";;; -*- Mode: LISP; package:maxima; syntax:common-lisp; -*- Saved by " SAVEFILE)
	   (PRINC (sys-user-id) SAVEFILE))
     #-(or Franz CL Multics) (FASPRINT T `(SETQ SAVENO ,SAVENOHACK))
     (SETQ LIST (NCONS (IF (SYMBOLP FILE) FILE (MFILE-OUT FILE)))
	   X (CONS '$ALIASES X)
	   *macsyma-extend-types-saved* nil)
     (IF (NULL (ERRSET (DSKSTORE X STOREFL FILE LIST))) (SETQ MAXIMA-ERROR T))
     (if (not (null *macsyma-extend-types-saved*))
	 (block nil
	   (if (null (errset
		      (dskstore (cons '&{ *macsyma-extend-types-saved*)
				storefl file list)))
	       (setq MAXIMA-ERROR t))
	   (setq *macsyma-extend-types-saved* nil)))
     #-cl(SETQ *NOPOINT T))
   (COND ((NULL (CDR LIST))
	  (DELETEF SAVEFILE)
	  (IF (NOT DSKSAVEP)
	      (MTELL "~M~%Nothing has been ~:Md.  ~:M attempt aborted."
		     (CAR LIST) FN FN))
	  (SETQ LIST '$ABORTED))
	 #-Franz
	 (FASDUMPFL (*FASDUMP SAVEFILE (NREVERSE FASDNONEQLIST) (NREVERSE FASDEQLIST) NIL)
		    (RENAMEF SAVEFILE FILE))
	 (T (TERPRI SAVEFILE) #-Franz (RENAMEF SAVEFILE FILE)))
   #+PDP10 (IF STOREFL (NOINTERRUPT OINT))
   #-(or Franz CL Multics) (DEFAULTF (IF DSKSAVEP OFILE FILE))
   #+PDP10
   (WHEN (NOT (ATOM LIST))
	 (RPLACA LIST (MTRUENAME SAVEFILE))
	 (SETQ LENGTH (FILELENGTH SAVEFILE))
	 (WHEN (> (CADR LENGTH) 30.)
	       (MTELL "~:M is ~A blocks big!" (CAR LIST) (CADR LENGTH))
	       (COND ((> (CADR LENGTH) 60.)
		      (MTELL "You probably want to zl-DELETE it."))
		     ((> (CADR LENGTH) 50.)
		      (MTELL "Do you really want such a large file?")))))
   (IF MAXIMA-ERROR (LET ((ERRSET 'ERRBREAK1)) (MERROR "Error in ~:M attempt" FN)))
   ;;The CLOSE happens inside of RENAMEF on ITS.
   #-PDP10 (CLOSE SAVEFILE)
   (IF (ATOM LIST) LIST
		   `((MLIST SIMP) ,(CAR LIST) #+PDP10 ,LENGTH . ,(CDR LIST))))) 

#+(OR CL NIL)
(DEFUN DSKSETUP (X STOREFL FASDUMPFL FN)
 (LET (#-cl(*NOPOINT T) PRINLENGTH PRINLEVEL OFILE FILE
	   *print-gensym*
       LIST FASDEQLIST FASDNONEQLIST MAXIMA-ERROR #+PDP10 LENGTH #+PDP10 OINT)
   #+CL
   (SETQ SAVEFILE (OPEN (NSUBSTRING (STRING (CAR X)) 1) :DIRECTION :OUTPUT))
   #+NIL
   (setq savefile (open ($filename_merge (car x)) :out))
   (SETQ FILE (LIST (CAR X)))
   (WHEN (NULL FASDUMPFL)
     (PRINC ";;; -*- Mode: LISP; package:maxima; syntax:common-lisp; -*- " SAVEFILE)
     (terpri savefile)
     (PRINC "(in-package \"MAXIMA\")" SAVEFILE)
     )
   (DOLIST (U X)
	   (COND ((ATOM U) (IF (NOT (SYMBOLP U)) (IMPROPER-ARG-ERR U FN)))
		 ((LISTARGP U))
		 ((OR (NOT (EQ (CAAR U) 'MEQUAL)) (NOT (SYMBOLP (CADR U))))
		  (IMPROPER-ARG-ERR U FN))))
   (COND (DSKSAVEP (SETQ FILELIST (CONS FILE FILELIST)))
	 (OFILE (SETQ FILELIST1 (CONS FILE FILELIST1))))
   (SETQ LIST (NCONS (CAR X)) X (CDR X) *macsyma-extend-types-saved* nil)
   (IF (NULL (ERRSET (DSKSTORE X STOREFL FILE LIST))) (SETQ MAXIMA-ERROR T))
   (if (not (null *macsyma-extend-types-saved*))
       (block nil
	 (if (null (errset
		    (dskstore (cons '&{ *macsyma-extend-types-saved*)
			      storefl file list)))
	     (setq MAXIMA-ERROR t))
	 (setq *macsyma-extend-types-saved* nil)))
   (CLOSE SAVEFILE)
   (namestring savefile)))

(DEFUN DSKSTORE (X STOREFL FILE LIST)
  (DO ((X X (CDR X)) (VAL) (RENAME) (ITEM)
       (ALRDYSTRD) (STFL STOREFL STOREFL) (NITEMFL NIL NIL))
      ((NULL X))
      (COND ((SETQ VAL (LISTARGP (CAR X)))
	     (SETQ X (NCONC (GETLABELS (CAR VAL) (CDR VAL) NIL) (CDR X))))
	    ((SETQ VAL (ASSQ (CAR X) '(($CLABELS . $INCHAR) ($DLABELS . $OUTCHAR)
				       ($ELABELS . $LINECHAR))))
	     (SETQ X (NCONC (GETLABELS* (EVAL (CDR VAL)) NIL) (CDR X)))))
      (IF (NOT (ATOM (CAR X)))
	  (SETQ RENAME (CADAR X) ITEM (GETOPR (CADDAR X)))
	  (SETQ X (INFOLSTCHK X) ITEM (SETQ RENAME (AND X (GETOPR (CAR X))))))
      (COND ((NOT (SYMBOLP ITEM))
	     (SETQ NITEMFL ITEM)
	     (SETQ ITEM (LET ((NITEM (GENSYM))) (SET NITEM (MEVAL ITEM)) NITEM)))
	    ((EQ ITEM '$RATWEIGHTS) (SETQ ITEM '*RATWEIGHTS))
	    ((EQ ITEM '$TELLRATS) (SETQ ITEM 'TELLRATLIST)))
      (COND
       ((NULL X) (RETURN NIL))
       ((NULL (CAR X)))
       ((AND (SETQ VAL (ASSQ ITEM ALRDYSTRD)) (EQ RENAME (CDR VAL))))
       ((NULL (SETQ ALRDYSTRD (CONS (CONS ITEM RENAME) ALRDYSTRD))))
       ((AND (OR (NOT (BOUNDP ITEM))
		 (AND (EQ ITEM '$RATVARS) (NULL VARLIST))
		 (PROG2 (SETQ VAL (SYMBOL-VALUE ITEM))
			(OR (AND (MEMQ ITEM '($WEIGHTLEVELS $DONTFACTOR))
				 (NULL (CDR VAL)))
			    (AND (MEMQ ITEM '(TELLRATLIST *RATWEIGHTS)) (NULL VAL))
			    (AND (EQ ITEM '$FEATURES) (ALIKE (CDR VAL) FEATUREL))
			    (AND (EQ ITEM '$DEFAULT_LET_RULE_PACKAGE)
				 (EQ ITEM VAL))))
		 (AND (MFILEP VAL)
		      (OR DSKSAVEP (NOT (UNSTOREP ITEM)) (NULL (SETQ STFL T)))))
	     (OR (NULL (SETQ VAL (safe-GET ITEM 'MPROPS))) (EQUAL VAL '(NIL))
		 (IF (NOT DSKSAVEP) (NOT (UNSTOREP ITEM))))
	     (NOT (GETL ITEM '(OPERATORS REVERSEALIAS GRAD NOUN VERB EXPR OP DATA)))
	     (NOT (MEMQ ITEM (CDR $PROPS)))
	     (OR (NOT (MEMQ ITEM (CDR $CONTEXTS)))
		 (NOT (EQ ITEM '$INITIAL))
	         (LET ((CONTEXT '$INITIAL)) (NULL (CDR ($FACTS '$INITIAL)))))))
       (T (WHEN (AND (BOUNDP ITEM) (NOT (MFILEP (SETQ VAL (SYMBOL-VALUE ITEM)))))
		(IF (EQ ITEM '$CONTEXT) (SETQ X (LIST* NIL VAL (CDR X))))
		(DSKATOM ITEM RENAME VAL)
		(IF (NOT (OPTIONP RENAME)) (INFOSTORE ITEM FILE 'VALUE STFL RENAME)))
	  (WHEN (SETQ VAL (AND (MEMQ ITEM (CDR $ALIASES)) (GET ITEM 'REVERSEALIAS)))
		(DSKDEFPROP RENAME VAL 'REVERSEALIAS)
		(PRADD2LNC RENAME '$ALIASES)
		(DSKDEFPROP (MAKEALIAS VAL) RENAME 'ALIAS)
		(AND GREATORDER (NOT (ASSQ 'GREATORDER ALRDYSTRD))
		     (SETQ X (LIST* NIL 'GREATORDER (CDR X))))
		(AND LESSORDER (NOT (ASSQ 'LESSORDER ALRDYSTRD))
		     (SETQ X (LIST* NIL 'LESSORDER (CDR X))))
		(SETQ X (LIST* NIL (MAKEALIAS VAL) (CDR X))))
	  (COND ((SETQ VAL (GET ITEM 'NOUN))
		 (SETQ X (LIST* NIL VAL (CDR X)))
		 (DSKDEFPROP RENAME VAL 'NOUN))
		((SETQ VAL (GET ITEM 'VERB))
		 (SETQ X (LIST* NIL VAL (CDR X)))
		 (DSKDEFPROP RENAME VAL 'VERB)))
	  (WHEN (MGET ITEM '$RULE)
		(IF (SETQ VAL (RULEOF ITEM))
		    (SETQ X (LIST* NIL VAL (CDR X))))
		(PRADD2LNC (GETOP RENAME) '$RULES))
	  (WHEN (AND (SETQ VAL (CADR (GETL-FUN ITEM '(EXPR))))
		     (OR (MGET ITEM '$RULE) (GET ITEM 'TRANSLATED)))
		#-Franz
		(IF (MGET ITEM 'TRACE)
		    (LET (VAL1 #+PDP10 (OINT (NOINTERRUPT 'TTY)))
		      (REMPROP ITEM 'EXPR)
		      (IF (SETQ VAL1 (GET ITEM 'EXPR))
			  (DSKDEFPROP RENAME VAL1 'EXPR))
		      (SETPLIST ITEM (LIST* 'EXPR VAL (SYMBOL-PLIST ITEM)))
		      #+PDP10 (NOINTERRUPT OINT))
		    (DSKDEFPROP RENAME VAL 'EXPR))
		#+Franz (fasprin `(def ,rename ,(getd item)))
		(IF (SETQ VAL (ARGS ITEM))
		    (FASPRIN `(ARGS (QUOTE ,RENAME) (QUOTE ,VAL))))
		(PROPSCHK ITEM RENAME 'TRANSLATED))
	  (WHEN (AND (SETQ VAL (GETL ITEM '(A-EXPR FEXPR TRANSLATED-MMACRO))) 
		     (GET ITEM 'TRANSLATED))
		(DSKDEFPROP RENAME (CADR VAL) (CAR VAL))
		(PROPSCHK ITEM RENAME 'TRANSLATED))
	  (WHEN (SETQ VAL (GET ITEM 'OPERATORS))
		(DSKDEFPROP RENAME VAL 'OPERATORS)
		(WHEN (SETQ VAL (GET ITEM 'RULES))
		      (DSKDEFPROP RENAME VAL 'RULES)
		      (SETQ X (CONS NIL (APPEND VAL (CDR X)))))
		(IF (MEMQ ITEM (CDR $PROPS)) (PRADD2LNC RENAME '$PROPS))
 		(SETQ VAL (MGET ITEM 'OLDRULES))
		(AND VAL (SETQ X (CONS NIL (NCONC (CDR (REVERSE VAL)) (CDR X))))))
	  (IF (MEMQ ITEM (CDR $FEATURES)) (PRADD2LNC RENAME '$FEATURES))
	  (WHEN (MEMQ (GETOP ITEM) (CDR $PROPS))
		(DOLIST (IND INDLIST) (PROPSCHK ITEM RENAME IND))
		(WHEN (GET (SETQ VAL (STRIPDOLLAR ITEM)) 'ALPHABET)
 		      (DSKDEFPROP VAL T 'ALPHABET)
		      (PRADD2LNC (GETCHARN VAL 1) 'ALPHABET)
		      (PRADD2LNC ITEM '$PROPS))
		(DOLIST (OPER OPERS) (PROPSCHK ITEM RENAME OPER)))
	  (WHEN (AND (SETQ VAL (GET ITEM 'OP)) (MEMQ VAL (CDR $PROPS)))
		(DSKDEFPROP ITEM VAL 'OP)
		(DSKDEFPROP VAL ITEM 'OPR)
		(PRADD2LNC VAL '$PROPS)
		(IF (SETQ VAL (EXTOPCHK ITEM VAL))
		    (SETQ X (LIST* NIL VAL (CDR X)))))
	  (WHEN (AND (SETQ VAL (GET ITEM 'GRAD)) (zl-ASSOC (NCONS ITEM) $GRADEFS))
		(DSKDEFPROP RENAME VAL 'GRAD)
		(PRADD2LNC (CONS (NCONS RENAME) (CAR VAL)) '$GRADEFS))
	  (WHEN (AND (GET ITEM 'DATA)
		     (NOT (MEMQ ITEM (CDR $CONTEXTS)))
		     (SETQ VAL (CDR ($FACTS ITEM))))
		(FASPRIN `(RESTORE-FACTS (QUOTE ,VAL)))
		(IF (MEMQ ITEM (CDR $PROPS)) (PRADD2LNC ITEM '$PROPS)))
	  (WHEN (AND (MEMQ ITEM (CDR $CONTEXTS))
		     (LET ((CONTEXT ITEM)) (SETQ VAL (CDR ($FACTS ITEM)))))
		(FASPRINT T `(DSKSETQ $CONTEXT (QUOTE ,ITEM)))
		(IF (MEMQ ITEM (CDR $ACTIVECONTEXTS))
		    (FASPRINT T `($ACTIVATE (QUOTE ,ITEM))))
		(FASPRINT T `(RESTORE-FACTS (QUOTE ,VAL))))
	  (MPROPSCHK ITEM RENAME FILE STFL)
	  (IF (NOT (GET ITEM 'VERB))
	      (NCONC LIST (NCONS (OR NITEMFL (GETOP ITEM)))))))))

(DEFUN DSKATOM (ITEM RENAME VAL)
 (COND ((EQ ITEM '$RATVARS)
	(FASPRINT T `(SETQ VARLIST (APPEND VARLIST (QUOTE ,VARLIST))))
	(FASPRINT T '(SETQ $RATVARS (CONS '(MLIST SIMP) VARLIST)))
	(PRADD2LNC '$RATVARS '$MYOPTIONS))
       ((MEMQ ITEM '($WEIGHTLEVELS $DONTFACTOR))
	(FASPRIN `(SETQ ,ITEM (NCONC (QUOTE ,VAL) (CDR ,ITEM))))
	(PRADD2LNC ITEM '$MYOPTIONS))
       ((EQ ITEM 'TELLRATLIST)
	(FASPRIN `(SETQ TELLRATLIST (NCONC (QUOTE ,VAL) TELLRATLIST)))
	(PRADD2LNC 'TELLRATLIST '$MYOPTIONS))
       ((EQ ITEM '*RATWEIGHTS)
	(FASPRIN `(APPLY (FUNCTION $RATWEIGHT) (QUOTE ,(DOT2L VAL)))))
       ((EQ ITEM '$FEATURES)
	(DOLIST (VAR (CDR $FEATURES))
		(IF (NOT (MEMQ VAR FEATUREL)) (PRADD2LNC VAR '$FEATURES))))
       ((AND (EQ ITEM '$LINENUM) (EQ ITEM RENAME))
	(FASPRINT T `(SETQ $LINENUM ,VAL)))
       ((NOT ($RATP VAL))
	(FASPRINT T (LIST 'DSKSETQ RENAME
			  (IF (OR (NUMBERP VAL) (MEMQ VAL '(NIL T)))
			      VAL
			      (LIST 'QUOTE VAL)))))
       (T (FASPRINT T `(DSKSETQ ,RENAME (DSKRAT (QUOTE ,VAL)))))))

(DEFUN MPROPSCHK (ITEM RENAME FILE STFL)
 (DO ((PROPS (CDR (OR (GET ITEM 'MPROPS) '(NIL))) (CDDR PROPS)) (VAL))
     ((NULL PROPS))
     (COND ((OR (MEMQ (CAR PROPS) '(TRACE TRACE-TYPE TRACE-LEVEL))
		(MFILEP (SETQ VAL (CADR PROPS)))
		(AND (EQ (CAR PROPS) 'T-MFEXPR) (NOT (GET ITEM 'TRANSLATED)))))
	   ((NOT (MEMQ (CAR PROPS) '(HASHAR ARRAY)))
	    (FASPRIN (LIST 'MDEFPROP RENAME VAL (CAR PROPS)))
	    (IF (NOT (MEMQ (CAR PROPS) '(MLEXPRP MFEXPRP T-MFEXPR)))
		(INFOSTORE ITEM FILE (CAR PROPS) STFL
			   (COND ((MEMQ (CAR PROPS) '(MEXPR MMACRO))
				  (LET ((VAL1 (ARGS ITEM)))
				       (IF VAL1 (FASPRIN `(ARGS (QUOTE ,RENAME)
								(QUOTE ,VAL1)))))
				  (LET ((VAL1 (GET ITEM 'FUNCTION-MODE)))
				       (IF VAL1 (DSKDEFPROP RENAME
							    VAL1
							    'FUNCTION-MODE)))
				  (CONS (NCONS RENAME) (CDADR VAL)))
				 ((EQ (CAR PROPS) 'DEPENDS)
				  (CONS (NCONS RENAME) VAL))
				 (T RENAME)))))
	   (T (DSKARY ITEM (LIST 'QUOTE RENAME) VAL (CAR PROPS))
	      (INFOSTORE ITEM FILE (CAR PROPS) STFL RENAME)))))

(DEFUN DSKARY (ITEM RENAME VAL IND)
    ; Some small forms ordinarily non-EQ for fasdump must be output 
    ; in proper sequence with the big mungeables.
    ; For this reason only they are output as EQ-forms.
 (LET ((ARY (COND ((AND (EQ IND 'array) (GET ITEM 'array)) RENAME)
				; This code handles "COMPLETE" arrays.
		  (T (FASPRINT T '(SETQ AAAAA (GENSYM))) 'AAAAA)))
       (DIMS (ARRAYDIMS VAL))
       VAL1)
      (IF (EQ IND 'HASHAR) (FASPRINT T `(REMCOMPARY ,RENAME)))
      (FASPRINT T `(MREMPROP ,RENAME (QUOTE ,(IF (EQ IND 'array) 'HASHAR 'array))))
      (FASPRINT T `(MPUTPROP ,RENAME ,ARY (QUOTE ,IND)))
      (FASPRINT T `(*ARRAY ,ARY (QUOTE ,(CAR DIMS)) ,.(CDR DIMS)))
      (FASPRINT T `(FILLARRAY ,ARY (QUOTE ,(LISTARRAY VAL))))
      (IF (SETQ VAL1 (GET ITEM 'ARRAY-MODE))
	  (FASPRINT T `(DEFPROP ,(CADR RENAME) ,VAL1 ARRAY-MODE)))))

(DEFUN EXTOPCHK (ITEM VAL)
 (LET ((VAL1 (IMPLODE (CONS #\$ (CDR (EXPLODEN VAL))))))
   (WHEN (OR (GET VAL1 'NUD) (GET VAL1 'LED) (GET VAL1 'LBP))
	 (FASPRIN `(DEFINE-SYMBOL (QUOTE ,VAL)))
	 (IF (MEMQ VAL MOPL)
	     (FASPRIN `(SETQ MOPL (CONS (QUOTE ,VAL) MOPL))))
	 (WHEN (SETQ VAL (GET VAL1 'DIMENSION))
	       (DSKDEFPROP VAL1 VAL 'DIMENSION)
	       (DSKDEFPROP VAL1 (GET VAL1 'DISSYM) 'DISSYM)
	       (DSKDEFPROP VAL1 (GET VAL1 'GRIND) 'GRIND))
	 (IF (SETQ VAL (GET VAL1 'LBP)) (DSKDEFPROP VAL1 VAL 'LBP))
	 (IF (SETQ VAL (GET VAL1 'RBP)) (DSKDEFPROP VAL1 VAL 'RBP))
	 (IF (SETQ VAL (GET VAL1 'NUD)) (DSKDEFPROP VAL1 VAL 'NUD))
	 (IF (SETQ VAL (GET VAL1 'LED)) (DSKDEFPROP VAL1 VAL 'LED))
	 (WHEN (SETQ VAL (GET VAL1 'VERB))
	       (DSKDEFPROP VAL (GET VAL 'DIMENSION) 'DIMENSION)
	       (DSKDEFPROP VAL (GET VAL 'DISSYM) 'DISSYM))
	 (WHEN (SETQ VAL (GET ITEM 'MATCH))
	       (DSKDEFPROP ITEM VAL 'MATCH) VAL))))

(DEFUN PROPSCHK (ITEM RENAME IND)
  (LET ((VAL (GET ITEM IND)))
    (WHEN VAL (DSKDEFPROP RENAME VAL IND)
	      (PRADD2LNC (GETOP RENAME) '$PROPS))))

(DEFUN FASPRIN (FORM) (FASPRINT NIL FORM))

(DEFUN FASPRINT (EQFL FORM)
  (COND ((NULL FASDUMPFL) #-Franz (PRINT FORM SAVEFILE)
			  #+Franz (pp-form form savefile))
	(EQFL (SETQ FASDEQLIST (CONS FORM FASDEQLIST)))
	(T (SETQ FASDNONEQLIST (CONS FORM FASDNONEQLIST)))))

(DEFUN UNSTOREP (ITEM) (I-$UNSTORE (NCONS ITEM)))

(DEFUN INFOSTORE (ITEM FILE FLAG STOREFL RENAME)
 (LET ((PROP (COND ((EQ FLAG 'VALUE)
		    (IF (MEMQ RENAME (CDR $LABELS)) '$LABELS '$VALUES))
		   ((EQ FLAG 'MEXPR) '$FUNCTIONS)
		   ((EQ FLAG 'MMACRO) '$MACROS)
		   ((MEMQ FLAG '(ARRAY HASHAR)) '$ARRAYS)
		   ((EQ FLAG 'DEPENDS) (SETQ STOREFL NIL) '$DEPENDENCIES)
		   (T (SETQ STOREFL NIL) '$PROPS))))
   (COND ((EQ PROP '$LABELS)
	  (FASPRIN `(ADDLABEL (QUOTE ,RENAME)))
	  (IF (GET ITEM 'NODISP) (DSKDEFPROP RENAME T 'NODISP)))
	 (T (PRADD2LNC RENAME PROP)))
   (COND (STOREFL
	  (COND ((MEMQ FLAG '(MEXPR MMACRO)) (SETQ RENAME (CAAR RENAME)))
		((EQ FLAG 'array) (REMCOMPARY ITEM)))
	  (SETQ PROP (LIST '(MFILE) FILE RENAME))
	  (COND ((EQ FLAG 'VALUE) (SET ITEM PROP))
		((MEMQ FLAG '(MEXPR MMACRO AEXPR ARRAY HASHAR))
		 (MPUTPROP ITEM PROP FLAG)))))))

(DEFUN PRADD2LNC (ITEM PROP)
  (IF (OR (NULL $PACKAGEFILE) (NOT (MEMQ PROP (CDR $INFOLISTS)))
	  (AND (EQ PROP '$PROPS) (GET ITEM 'OPR)))
      (FASPRIN `(ADD2LNC (QUOTE ,ITEM) ,PROP))))

(DEFUN DSKDEFPROP (NAME VAL IND)
  (FASPRIN (IF (AND (MEMQ IND '(EXPR FEXPR MACRO)) (EQ (CAR VAL) 'LAMBDA))
	       (LIST* 'DEFUN NAME
		      (IF (EQ IND 'EXPR) (CDR VAL) (CONS IND (CDR VAL))))
	       (LIST 'DEFPROP NAME VAL IND))))

(DEFUN DSKGET (FILE NAME FLAG UNSTOREP)
 (LET ((DEFAULTF DEFAULTF) (EOF (LIST NIL)) ITEM #-cl(*NOPOINT T))
   (SETQ FILE (OPEN FILE #-cl '(IN ASCII)))
   (SETQ ITEM (DO ((ITEM (READ FILE EOF) (READ FILE EOF)))
		  ((EQ ITEM EOF) (MERROR "~%~:M not found" NAME))
		  (IF (OR (AND (NOT (ATOM ITEM)) (EQ (CAR ITEM) 'DSKSETQ)
			       (EQ FLAG 'VALUE) (EQ (CADR ITEM) NAME))
			  (AND (NOT (ATOM ITEM)) (= (LENGTH ITEM) 4)
			       (OR (EQ (CADDDR ITEM) FLAG)
				   (AND (EQ (CAR (CADDDR ITEM)) 'QUOTE)
					(EQ (CADR (CADDDR ITEM)) FLAG)))
			       (OR (EQ (CADR ITEM) NAME)
				   (AND (EQ (CAADR ITEM) 'QUOTE)
					(EQ (CADADR ITEM) NAME)))))
		      (RETURN ITEM))))
   (WHEN UNSTOREP (EVAL (READ FILE)) (EVAL (READ FILE)))
   (CLOSE FILE)
   (CADDR ITEM)))

(DEFUN DSKSAVE NIL
  (LET ((DSKSAVEP T))
    (IF $DSKALL (I-$STORE '($LABELS $VALUES $FUNCTIONS $MACROS $ARRAYS))
		(I-$STORE '($LABELS)))))

;(DEFMSPEC $REMFILE (L) (SETQ L (CDR L))
;  (IF (AND L (OR (CDR L) (NOT (MEMQ (CAR L) '($ALL $TRUE T)))))
;      (IMPROPER-ARG-ERR L '$REMFILE))
;  (DOLIST (FILE (IF L (APPEND FILELIST1 FILELIST) FILELIST))
;    (ERRSET (DELETEF FILE) NIL)
;    (SETQ FILELIST (zl-DELETE FILE FILELIST 1))
;    (SETQ FILELIST1 (zl-DELETE FILE FILELIST1 1)))
;  '$DONE)

(DEFMSPEC $RESTORE (FILE) (SETQ FILE (CDR FILE))
 (LET ((EOF (NCONS NIL)) (IN (OPEN (FILESTRIP FILE)#-cl '(IN ASCII))))
      (SETQ FILE (TRUENAME IN))
      (SETQ FILE (IF (ATOM FILE) FILE (APPEND (CDR FILE) (CAR FILE))))
      (DO ((ITEM (READ IN EOF) (READ IN EOF))) ((EQ ITEM EOF))
	  (COND ((AND (EQ (CAR ITEM) 'DSKSETQ) (NOT (OPTIONP (CADR ITEM))))
		 (SET (CADR ITEM) (LIST '(MFILE) FILE (CADR ITEM))))
		((AND (EQ (CAR ITEM) 'MDEFPROP)
		      (MEMQ (CADDDR ITEM) '(MEXPR MMACRO AEXPR)))
		 (MPUTPROP (CADR ITEM)
			   (LIST '(MFILE) FILE (CADR ITEM))
			   (CADDDR ITEM)))
		((AND (EQ (CAR ITEM) 'MPUTPROP)
		      (MEMQ (CADR (CADDDR ITEM)) '(ARRAY HASHAR)))
		 (MPUTPROP (CADADR ITEM)
			   (LIST '(MFILE) FILE (CADADR ITEM))
			   (CADR (CADDDR ITEM)))
		 (DO ((ITEM (READ IN) (READ IN))) (NIL)
		     (IF (EQ (CAR ITEM) 'ADD2LNC) (RETURN (EVAL ITEM)))))
		(T (EVAL ITEM))))
      (CLOSE IN)
      (IF $CHANGE_FILEDEFAULTS (DEFAULTF FILE))
      (IF (ATOM FILE) FILE (MFILE-OUT FILE))))

