#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005-2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: David C. Morrill <dmorrill@enthought.com>
#
#-----------------------------------------------------------------------------

""" Action for deleting a user defined perspective.
"""

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------
    
from enthought.pyface.api \
    import confirm, NO
    
from user_perspective_action \
    import UserPerspectiveAction

#-------------------------------------------------------------------------------
#  'DeleteUserPerspectiveAction' class:
#-------------------------------------------------------------------------------    

class DeleteUserPerspectiveAction ( UserPerspectiveAction ):
    """ Deletes a user defined perspective
    """
    
    #---------------------------------------------------------------------------
    #  'Action' interface:
    #---------------------------------------------------------------------------

#-- Public Interface -----------------------------------------------------------

    def perform ( self, event ):
        """ Performs the action, which is to delete the current active 
            perspective, which must be a user defined perspective.
        """
        # Make sure the user isn't having second thoughts:
        window = event.window
        if confirm( window.control, "Are you sure that you want to delete the "
                    "'%s' perspective?" % window.active_perspective.name, 
                    'Confirm Delete' ) == NO:
            return
            
        # Get the id of the perspective being deleted:
        id = window.active_perspective.id
        
        # Delete the perspective from the window's list:
        window.remove_perspective_by_id( id )
        
        # Remove the 'switch to perspective' action from the Perspective menu:
        self._manager.remove( id )

#### EOF #####################################################################

