/* menu.c -- configuration menu 
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */

#include <gtk/gtk.h>
#include <stdio.h>
#include "melon.h"

gint select_pixmaps (GtkWidget *widget, gpointer data);
gint select_mbox (GtkWidget *widget, gpointer data);
gint select_beep (GtkWidget *widget, gpointer data);
gint mailer_config (GtkWidget *widget, gpointer data);
gint set_position (GtkWidget *widget, gpointer data);
gint set_interval (GtkWidget *widget, gpointer data);
gint set_save_status (GtkWidget *widget, gpointer data);
gint set_beep_mode (GtkWidget *widget, gpointer mode);
gint set_beep_device (GtkWidget *widget, gpointer device);
gint color_selector (GtkWidget *widget, gpointer color_data);
void unset_all (GtkWidget *widget, gpointer data);
static gint menu_handler ( GtkWidget *widget, GdkEvent *event );

void pop_menu(GdkEventButton *event_button)
{
	GtkWidget *menu;
	GtkWidget *menuitem_app, *menuitem_mail, *menuitem_mbox; 
	GtkWidget *menuitem_check, *menuitem_beep, *menuitem_quit;
	GtkWidget *beep_menu, *beep_mode_menu, *beep_device_menu;
	GtkWidget *check_menu, *item_inter, *item_status;
	GtkWidget *item_adev, *item_aud, *item_dsp;
	GtkWidget *item_file, *item_mode, *item_onet, *item_eacht;
	GtkWidget *app_menu, *item_pix, *item_pos, *item_col;
	GtkWidget *colors_menu, *item_bg, *item_fg, *item_abg, *item_afg;
	GtkWidget *item_sep, *item_gtk_def, *item_melon_def;

	menu = gtk_menu_new();
	menuitem_app = gtk_menu_item_new_with_label( "Configure Appearance" );
	menuitem_mail = gtk_menu_item_new_with_label( "Configure Mailer" );
	menuitem_mbox = gtk_menu_item_new_with_label( "Set Mailboxes" );
	menuitem_check = gtk_menu_item_new_with_label( "Check Options" );
	menuitem_beep = gtk_menu_item_new_with_label( "Set Beep" );
	menuitem_quit = gtk_menu_item_new_with_label( "Quit" );
	gtk_menu_append( GTK_MENU( menu ), menuitem_app );
	gtk_menu_append( GTK_MENU( menu ), menuitem_mail );
	gtk_menu_append( GTK_MENU( menu ), menuitem_mbox );
	gtk_menu_append( GTK_MENU( menu ), menuitem_check );
	gtk_menu_append( GTK_MENU( menu ), menuitem_beep );
	gtk_menu_append( GTK_MENU( menu ), menuitem_quit );

	gtk_widget_show( menuitem_app );
	gtk_widget_show( menuitem_mail );
	gtk_widget_show( menuitem_mbox );
	gtk_widget_show( menuitem_check );
	gtk_widget_show( menuitem_beep );
	gtk_widget_show( menuitem_quit );

	/* beep submenu */
	beep_menu = gtk_menu_new();
	item_adev = gtk_menu_item_new_with_label( "Set audio device" );
	item_file = gtk_menu_item_new_with_label( "Set audio file" );
	item_mode = gtk_menu_item_new_with_label( "Set beep mode" );
	gtk_menu_append( GTK_MENU( beep_menu ), item_adev);
	gtk_menu_append( GTK_MENU( beep_menu ), item_file);
	gtk_menu_append( GTK_MENU( beep_menu ), item_mode);
	gtk_widget_show( item_adev);
	gtk_widget_show( item_file);
	gtk_widget_show( item_mode);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_beep), beep_menu);

	/* beep_mode submenu */
	beep_mode_menu = gtk_menu_new();
	item_onet = gtk_menu_item_new_with_label( "Play once for mailbox" );
	item_eacht = gtk_menu_item_new_with_label( "Play for each new e-mail" );
	gtk_menu_append( GTK_MENU( beep_mode_menu ), item_onet);
	gtk_menu_append( GTK_MENU( beep_mode_menu ), item_eacht);
	gtk_widget_show( item_onet );
	gtk_widget_show( item_eacht );
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (item_mode), beep_mode_menu);

	/* beep_device submenu */
	beep_device_menu = gtk_menu_new();
	item_aud = gtk_menu_item_new_with_label( "Play on /dev/audio" );
	item_dsp = gtk_menu_item_new_with_label( "Play on /dev/dsp" );
	gtk_menu_append( GTK_MENU( beep_device_menu ), item_aud);
	gtk_menu_append( GTK_MENU( beep_device_menu ), item_dsp);
	gtk_widget_show( item_aud );
	gtk_widget_show( item_dsp );
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (item_adev), beep_device_menu);

	/* check options submenu */
	check_menu = gtk_menu_new();
	item_inter = gtk_menu_item_new_with_label( "Set Interval" );
	item_status = gtk_menu_item_new_with_label( "Save Status" );
	gtk_menu_append( GTK_MENU( check_menu ), item_inter);
	gtk_menu_append( GTK_MENU( check_menu ), item_status);
	gtk_widget_show( item_inter);
	gtk_widget_show( item_status);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_check), check_menu);

	/* appearence submenu */
	app_menu = gtk_menu_new();
	item_pix = gtk_menu_item_new_with_label( "Change Pixmaps" );
	item_pos = gtk_menu_item_new_with_label( "Set Position" );
	item_col = gtk_menu_item_new_with_label( "Set Colors" );
	gtk_menu_append( GTK_MENU( app_menu ), item_pix );
	gtk_menu_append( GTK_MENU( app_menu ), item_pos );
	gtk_menu_append( GTK_MENU( app_menu ), item_col );
	gtk_widget_show( item_pix );
	gtk_widget_show( item_pos );
	gtk_widget_show( item_col );
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_app), app_menu);

	/* colors submenu */
	colors_menu = gtk_menu_new();
	item_gtk_def = gtk_menu_item_new_with_label( "Gtk Default" );
	item_melon_def = gtk_menu_item_new_with_label( "Melon Default" );
	item_sep = gtk_menu_item_new();
	item_bg = gtk_menu_item_new_with_label( "Background" );
	item_fg = gtk_menu_item_new_with_label( "Foreground" );
	item_abg = gtk_menu_item_new_with_label( "Active Background" );
	item_afg = gtk_menu_item_new_with_label( "Active Foreground" );
	gtk_menu_append( GTK_MENU( colors_menu ), item_gtk_def);
	gtk_menu_append( GTK_MENU( colors_menu ), item_melon_def);
	gtk_menu_append( GTK_MENU( colors_menu ), item_sep);
	gtk_menu_append( GTK_MENU( colors_menu ), item_bg);
	gtk_menu_append( GTK_MENU( colors_menu ), item_fg);
	gtk_menu_append( GTK_MENU( colors_menu ), item_abg);
	gtk_menu_append( GTK_MENU( colors_menu ), item_afg);
	gtk_widget_show( item_gtk_def );
	gtk_widget_show( item_melon_def );
	gtk_widget_show( item_sep );
	gtk_widget_show( item_bg );
	gtk_widget_show( item_fg );
	gtk_widget_show( item_abg );
	gtk_widget_show( item_afg );
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (item_col), colors_menu);
	/* end of submenus */

	gtk_signal_connect( GTK_OBJECT( menuitem_mail ), "activate",
		GTK_SIGNAL_FUNC( mailer_config ), NULL);
	gtk_signal_connect( GTK_OBJECT( menuitem_mbox ), "activate",
		GTK_SIGNAL_FUNC( select_mbox ), NULL);
	gtk_signal_connect( GTK_OBJECT( menuitem_check ), "activate",
		GTK_SIGNAL_FUNC( menu_handler ), GTK_OBJECT( check_menu ));
	gtk_signal_connect( GTK_OBJECT( item_inter ), "activate",
		GTK_SIGNAL_FUNC( set_interval ), NULL);
	gtk_signal_connect( GTK_OBJECT( item_status ), "activate",
		GTK_SIGNAL_FUNC( set_save_status ), NULL);
	gtk_signal_connect( GTK_OBJECT( menuitem_beep ), "activate",
		GTK_SIGNAL_FUNC( menu_handler ), GTK_OBJECT( beep_menu ));
	gtk_signal_connect( GTK_OBJECT( item_file ), "activate",
		GTK_SIGNAL_FUNC( select_beep ), NULL);
	gtk_signal_connect( GTK_OBJECT( item_adev ), "activate",
		GTK_SIGNAL_FUNC( menu_handler ), GTK_OBJECT( beep_device_menu ));
	gtk_signal_connect( GTK_OBJECT( item_aud ), "activate",
		GTK_SIGNAL_FUNC( set_beep_device ), "/dev/audio");
	gtk_signal_connect( GTK_OBJECT( item_dsp ), "activate",
		GTK_SIGNAL_FUNC( set_beep_device ), "/dev/dsp");
	gtk_signal_connect( GTK_OBJECT( item_mode ), "activate",
		GTK_SIGNAL_FUNC( menu_handler ), GTK_OBJECT( beep_mode_menu ));
	gtk_signal_connect( GTK_OBJECT( item_onet ), "activate",
		GTK_SIGNAL_FUNC( set_beep_mode ), "ONETIME");
	gtk_signal_connect( GTK_OBJECT( item_eacht ), "activate",
		GTK_SIGNAL_FUNC( set_beep_mode ), "EACHTIME");
	gtk_signal_connect( GTK_OBJECT( menuitem_app ), "activate",
		GTK_SIGNAL_FUNC( menu_handler ), GTK_OBJECT( app_menu ));
	gtk_signal_connect( GTK_OBJECT( item_pix ), "activate",
		GTK_SIGNAL_FUNC( select_pixmaps ), NULL);
	gtk_signal_connect( GTK_OBJECT( item_pos ), "activate",
		GTK_SIGNAL_FUNC( set_position ), NULL);
	gtk_signal_connect( GTK_OBJECT( item_col ), "activate",
		GTK_SIGNAL_FUNC( menu_handler ), GTK_OBJECT( colors_menu ));
	gtk_signal_connect( GTK_OBJECT( item_gtk_def ), "activate",
		GTK_SIGNAL_FUNC( color_selector ), "gdef");
	gtk_signal_connect( GTK_OBJECT( item_melon_def ), "activate",
		GTK_SIGNAL_FUNC( color_selector ), "mdef");
	gtk_signal_connect( GTK_OBJECT( item_bg ), "activate",
		GTK_SIGNAL_FUNC( color_selector ), "bg");
	gtk_signal_connect( GTK_OBJECT( item_fg ), "activate",
		GTK_SIGNAL_FUNC( color_selector ), "fg");
	gtk_signal_connect( GTK_OBJECT( item_abg ), "activate",
		GTK_SIGNAL_FUNC( color_selector ), "abg");
	gtk_signal_connect( GTK_OBJECT( item_afg ), "activate",
		GTK_SIGNAL_FUNC( color_selector ), "afg");
	gtk_signal_connect( GTK_OBJECT( menuitem_quit ), "activate",
		GTK_SIGNAL_FUNC( close_application ), NULL);

	gtk_menu_popup (GTK_MENU( menu ), NULL, NULL, NULL, NULL, 
		event_button->button, event_button->time);
	
}

gint menu_handler ( GtkWidget *widget, GdkEvent *event )
{

    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event; 
        gtk_menu_popup (GTK_MENU (widget), NULL, NULL, NULL, NULL,
                        bevent->button, bevent->time);
        return TRUE;
    }

    return FALSE;
}



void active_mbox_menu(GdkEventButton *event_button)
{
	GtkWidget *mbox_menu, *menuitem;
	int c;
	int i = 0;

	/* if there is only one configured mailbox or
	   no one mailbox is active (i.e., has received new mail), 
	   don't show the menu 
	*/
	if (cfg_data.mbox[1][0] == '\0' || none_active_mbox()) {
		see_mail(NULL, NULL);
		return;
	}

	mbox_menu = gtk_menu_new();

	for(c = 0; c < MAX_MBOX; c++)
	{
		if(active_mbox[c][0] == '\0')
			continue;

		menuitem = gtk_menu_item_new_with_label( active_mbox[c] );
		gtk_menu_append( GTK_MENU( mbox_menu ), menuitem);
		gtk_widget_show( menuitem);
		gtk_signal_connect( GTK_OBJECT( menuitem ), "activate",
			GTK_SIGNAL_FUNC(see_mail), active_mbox[c]);
		i++;
	}
	if(i) {
		menuitem = gtk_menu_item_new();
		gtk_menu_append( GTK_MENU( mbox_menu ), menuitem);
		gtk_widget_show( menuitem);

		menuitem = gtk_menu_item_new_with_label( "Unset all" );
		gtk_menu_append( GTK_MENU( mbox_menu ), menuitem);
		gtk_widget_show( menuitem);
		gtk_signal_connect( GTK_OBJECT( menuitem ), "activate",
			GTK_SIGNAL_FUNC(unset_all), NULL);
	}

	gtk_menu_popup (GTK_MENU( mbox_menu ), NULL, NULL, NULL, NULL, 
		event_button->button, event_button->time);
	
}

void unset_all (GtkWidget *widget, gpointer data)
{
	int c;

	for(c = 0; c < MAX_MBOX; c++)
		reset_mbox_status(active_mbox[c]);
}
