/* test.h - MemTest-86  Version 2.9
 *
 * Released under version 2 of the Gnu Public License.
 * By Chris Brady, cbrady@sgi.com
 */


#define E88     0x00
#define E801    0x04
#define E820NR  0x08           /* # entries in E820MAP */
#define E820MAP 0x0c           /* our map */
#define E820MAX 32             /* number of entries in E820MAP */

#ifndef __ASSEMBLY__
typedef unsigned long ulong;
#define SPINSZ		0x800000
#define DEFTESTS	7
#define MOD_SZ		20
#define BAILOUT		if (bail) goto skip_test;
#define BAILR		if (bail) return;

#define RES_START	0xa0000
#define RES_END		0x100000
#define SCREEN_ADR	0xb8000

#define TITLE_WIDTH	28
#define LINE_TIME	8
#define COL_TIME	0
#define LINE_TST	2
#define LINE_RANGE	3
#define LINE_CPU	1
#define COL_MID		30
#define LINE_INFO	8
#define COL_MMAP	29
#define COL_CACHE	40
#define COL_PAT		48
#define COL_TST		60
#define COL_PASS	64
#define COL_ERR		71
#define LINE_HEADER	9
#define LINE_SCROLL	12
#define BAR_SIZE	(78-COL_MID-9)

#define POP_W	30
#define POP_H	13
#define POP_X	(80-POP_W-2)/2
#define POP_Y	9
#define NULL	0

/* memspeed operations */
#define MS_BCOPY	1
#define MS_COPY		2
#define MS_WRITE	3
#define MS_READ		4

#define SZ_MODE_BIOS		1
#define SZ_MODE_BIOS_RES	2
#define SZ_MODE_PROBE		3

#define getCx86(reg) ({ outb((reg), 0x22); inb(0x23); })
#define serial_echo_outb(v,a) outb((v),(a)+0x3f8)
#define serial_echo_inb(a)    inb((a)+0x3f8)
#define BOTH_EMPTY (UART_LSR_TEMT | UART_LSR_THRE)
/* Wait for transmitter & holding register to empty */
#define WAIT_FOR_XMITR \
 do { \
       lsr = serial_echo_inb(UART_LSR); \
 } while ((lsr & BOTH_EMPTY) != BOTH_EMPTY)

int insertaddress(ulong);
void printpatn(void);
void printpatn(void);
void itoa(char s[], int n); 
void reverse(char *p);
void serial_echo_init();
void serial_echo_print(char *s);
void ttyprint(int y, int x, char *s);
void ttyprintc(int y, int x, char c);
void cprint(int y,int x,char *s);
void hprint(int y,int x,ulong val);
void xprint(int y,int x,ulong val);
void aprint(int y,int x,ulong val);
void dprint(int y,int x,ulong val,int len, int right);
void movinv1(int iter, ulong p1, ulong p2);
void movinv32(int iter, ulong p1, ulong lb, ulong mb, int sval, int off);
void modtst(int off, int iter, ulong p1, ulong p2);
void error(ulong* adr, ulong good, ulong bad);
void ad_err1(ulong adr1, ulong adr2, ulong good, ulong bad);
void ad_err2(ulong adr, ulong bad);
void do_tick();
void init();
void inter();
void set_cache(int val);
void check_input();
void footer();
void scroll();
void popup();
void popdown();
void popclear();
void get_config();
void get_printmode();
void cpu_type();
void addr_tst1();
void addr_tst2();
void block_move();
void find_ticks();
void print_err();
void mem_size();
void memsize_820();
void memsize_801();
void memsize_probe();
void mem_size();
void adj_mem();
ulong getval(int x, int y);
int get_key();
int cpuspeed();
ulong memspeed();
int check_ram();
int ascii_to_keycode(int in);
void wait_keyup();
void cacheable();
void print_hdr();
void restart();
void parity_err(ulong edi, ulong esi);
void start_config();
void clear_screen();
void xmemspeed();
int strlen();

extern ulong idt_descr;

#define PRINTMODE_ADDRESSES 0
#define PRINTMODE_PATTERNS  1

#define BADRAM_MAXPATNS 10

struct pair {
       ulong adr;
       ulong mask;
};

struct e820map {
    int nr_map;
    struct e820entry {
        unsigned long long addr;        /* start of memory segment */
        unsigned long long size;        /* size of memory segment */
        unsigned long type;             /* type of memory segment */
    } map[E820MAX];
};
int sanitize_e820_map(struct e820entry *a, struct e820entry *b, short nr,
	 short res);

#define E820_RAM        1
#define E820_RESERVED   2
#define E820_ACPI       3 /* usable as RAM once ACPI tables have been read */
#define E820_NVS        4


extern __inline__ void cache_off()
{
        __asm__("push %eax\n\t"
		"movl %cr0,%eax\n\t"
                "orl $0x40000000,%eax\n\t"  /* Set CD */
                "movl %eax,%cr0\n\t"
		".byte 0x0f,0x09\n\t"	/* Invalidate and flush cache */
		"pop  %eax\n\t");
}
extern __inline__ void cache_on()
{
        __asm__("push %eax\n\t"
		"movl %cr0,%eax\n\t"
                "andl $0x9fffffff,%eax\n\t" /* Clear CD and NW */ 
                "movl %eax,%cr0\n\t"
		"pop  %eax\n\t");
}

extern __inline__ void reboot()
{
        __asm__(
		"movl %cr0,%eax\n\t"
       		"andl  $0x00000011,%eax\n\t"
       		"orl   $0x60000000,%eax\n\t"
       		"movl  %eax,%cr0\n\t"
       		"movl  %eax,%cr3\n\t"
		"movl  %cr0,%ebx\n\t"
		"andl  $0x60000000,%ebx\n\t"
		"jz    f\n\t"
		".byte 0x0f,0x09\n\t"	/* Invalidate and flush cache */
		"f: andb  $0x10,%al\n\t"
		"movl  %eax,%cr0\n\t"
		"movw $0x0010,%ax\n\t"
		"movw %ax,%ds\n\t"
		"movw %ax,%es\n\t"
		"movw %ax,%fs\n\t"
		"movw %ax,%gs\n\t"
		"movw %ax,%ss\n\t"
		"ljmp  $0xffff,$0x0000\n\t");
}

struct mmap {
	int v;
	volatile ulong *start;
	volatile ulong *end;
};

struct tseq {
	short cache;
	short pat;
	short iter;
	short ticks;
	short errors;
	char *msg;
};

struct cpu_ident {
	char type;
	char model;
	char step;
	char fill;
	long cpuid;
	long capability;
	char vend_id[12];
	unsigned char cache_info[16];
};

/* Define common variables accross relocations of memtest86 */
struct vars {
	int firsttime;
	int test;
	int pass;
	ulong *eadr;
	ulong exor;
	int msg_line;
	int ecount;
	int msegs;
	int cache_flag;
	int xtst_flag;
	int testsel;
	int scroll_start;
	int rdtsc;
	int pass_ticks;
	int total_ticks;
	int pptr;
	int tptr;
	struct mmap map[E820MAX];
	struct mmap rmap[E820MAX];
	volatile ulong lim_lower;
	volatile ulong lim_upper;
	ulong clks_msec;
	ulong starth;
	ulong startl;
	ulong snaph;
	ulong snapl;
	int printmode;
	int numpatn;
	struct pair patn [BADRAM_MAXPATNS];
	char memsz_mode;
	ulong test_mem;
	ulong selected_mem;
	ulong reserved;
	ulong alt_mem_k;
	ulong ext_mem_k;
	short e820_nr;
	struct e820entry e820[E820MAX];
};

#endif

