#include <strstream.h>
#include <iostream.h>
#include <fstream.h>
#include <set.h>
#include <list.h>
#include <getopt.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <values.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <pwd.h>

#include "install-menu.h"
#include "menu-tree.h"

int show_time=0, verbose=0, dodebug=0;

map <String, func *, less<String> > func_data;

menuentry menu;
configinfo *config;
supportedinfo *supported;
set<String> uniquetitles;

int linenumber=-123456;

ofstream *genoutputfile=NULL;
set<String> outputnames; //all names of files ever written to


struct option long_options[] = { 
  { "showtime", no_argument, &show_time, 1 }, 
  { "verbose", no_argument, &verbose, 1 }, 
  { "debug", no_argument, &dodebug, 1 }, 
  { "help", no_argument, NULL, 'h' }, 
  { "stdin", no_argument, NULL, 'f' }, 
  { NULL, 0, NULL, 0 } };

// quick hack to get the "repeat_lang=LOCALE" working.
// main() checks for value of repeat_lang, and sets
// this variable if repeat_lang==LOCALE.
bool do_translate_hack=false;



void usage(){
  cerr<<_("menu-method: generate window-manager 'rc' files (or html docs)\n"
	  "  menu-method gets the menuentries from standard in.\n"
	  "  Options to menu-method:\n"
	  "     -h        : this message\n"
	  "     -d --debug: show debug info\n"
	  "     -showtime : show timeing information"
	  "     -f        : ignored for compatibility reasons")<<endl;
  exit(1);
}

func_def::~func_def(){
}

void store_func(func *f){
  func_data[f->name()]=f;
}
void add_functions(){
  store_func(new prefix_func);
  store_func(new ifroot_func);

  store_func(new print_func);
  store_func(new add_func);
  store_func(new sub_func);
  store_func(new mult_func);
  store_func(new div_func);
  store_func(new ifempty_func);
  store_func(new ifnempty_func);
  store_func(new iffile_func);
  store_func(new ifelsefile_func);
  store_func(new ifelse_func);
  store_func(new catfile_func);
  store_func(new forall_func);

  store_func(new ifeq_func);
  store_func(new ifneq_func);
  store_func(new ifeqelse_func);

  store_func(new cond_surr_func);
  store_func(new esc_func);
  store_func(new escwith_func);
  store_func(new escfirst_func);
  store_func(new tolower_func);  
  store_func(new toupper_func);
  store_func(new replacewith_func);
  store_func(new nstring_func);  
  store_func(new cppesc_func);
  store_func(new parent_func);
  store_func(new basename_func);
  store_func(new stripdir_func);
  store_func(new entrycount_func);
  store_func(new entryindex_func);
  store_func(new firstentry_func);
  store_func(new lastentry_func);
  store_func(new level_func);

  store_func(new rcfile_func);
  store_func(new examplercfile_func);
  store_func(new mainmenutitle_func);
  store_func(new rootsection_func);
  store_func(new rootprefix_func);
  store_func(new userprefix_func);
  store_func(new treewalk_func);
  store_func(new postoutput_func);
  store_func(new preoutput_func);
  store_func(new cwd_func);
  store_func(new translate_func);
}


bool empty_String(const String &s){
  if(s.length()&&(s!=String("none")))
    return false;
  else
    return true;
}


cat_str *get_eq_cat_str(parsestream &i){
  i.skip_space();
  i.skip_char('=');
  return new cat_str(i);
}

int check_dir(String s){
  String t;
  string::size_type i;
  if(dodebug)
    cerr<<"CHECK_DIR: "<<s<<endl;
  while(s.length()){
    i=s.find('/',1);
    if(i!=string::npos){
      t=s.substr(0,i+1);
      for(; i<s.length() && (s[i]=='/'); i++);
      s=s.after(i);
    } else {
      t=s;
      s="";
    }
    if(chdir(t.c_str())<0){
      if(dodebug)
	cerr<<"MKDIR "<<t<<endl;
      if(mkdir(t.c_str(),0755))
	throw dir_createerror(t);
      if(chdir(t.c_str()))
	throw dir_createerror(t);
    } else {
      if(dodebug)
	cerr<<" dir "<<t<<" already exists "<<endl;
    }
  }
  return !s.length();
}

void closegenoutput(){
  set<String>::iterator i;

  // OK, this will look clumsy in strace output, especially if there's
  // only output file: first we close, and immediately afterwards we
  // open and write again. But I don't see an easy and general way
  // to get round that.
  if(genoutputfile){
    delete genoutputfile;
    genoutputfile=NULL;
  }
  for(i=outputnames.begin(); i!=outputnames.end(); i++){
    ofstream f((*i).c_str(), ios::app);
    f<<(config->postoutput());
  }
}
void genoutput(const String &s,
	       map<String, String, less<String> > &v){
  
  static String lastname="////";
  String name;
  String dir;

  name=config->prefix()+"/"+config->genmenu->soutput(v);
  //if(dodebug)
  //  cerr<<"GENOUTPUT: name="<<name<<endl;
  if(name!=lastname){
    if(genoutputfile)
      delete genoutputfile;
    if(outputnames.find(name)==outputnames.end()){
      outputnames.insert(name);
      check_dir(String_parent(name));
      // after opening a file with ios::trunc, all writes seem to fail!
      //genoutputfile=new ofstream(name.c_str(), ios::trunc);
      // So, I do it this way instead:
      unlink(name.c_str());
      genoutputfile=new ofstream(name.c_str());
      (*genoutputfile)<<config->preoutput();    
    } else
      genoutputfile=new ofstream(name.c_str(),ios::app);      
    lastname=name;
  }
  (*genoutputfile)<<s;
}

/////////////////////////////////////////////////////
//  Construction:
//

str::~str(){
}
cat_str::cat_str(parsestream &i){
  char buf[2]=".";
  char c;
  c=i.get_char();
  i.put_back(c);
  try{
    while(1){
      i.skip_space();
      c=i.get_char();
      i.put_back(c);
      if(isalpha(c))
	v.push_back(new func_str(i));
      else if(c=='\"') 
	v.push_back(new const_str(i));
      else if(c=='$') 
	v.push_back(new var_str(i));
      else if(c==',')
	break;
      else if(c==')')
	break;
      else if(c=='\0')
	break;
      else {
	buf[0]=c;
	throw char_unexpected(&i, buf);
      }
    }
  }catch(endofline p){};
}

const_str::const_str(parsestream &i){
  data=i.get_Stringconst();
}

var_str::var_str(parsestream &i){
  i.skip_char('$');
  var_name=i.get_name();
}

func_str::func_str(parsestream &i){
  char c;
  String name;
  map <String, func *, less<String> >::iterator j;

  name=i.get_name();
  j=func_data.find(name);
  if(j==func_data.end()){
    throw unknown_function(&i, name);
  } else
    f=(*j).second;

  i.skip_space();
  i.skip_char('(');
  do{
    i.skip_space();
    c=i.get_char();
    if(c==')')
      break;
    i.put_back(c);
    args.push_back(new cat_str(i));
    i.skip_space();
  } while((c=i.get_char())&&(c==','));
  i.put_back(c);
  i.skip_char(')');
  if(args.size()!=(unsigned int)f->nargs())
    throw narg_mismatch(&i, name);
}


/////////////////////////////////////////////////////
//  Output routines
//

ostream &const_str::output(ostream &o, 
			   map<String, String, less<String> > &/*menuentry*/){
  //  cout<<"IN CONST_STR: data="<<data<<endl;
  return o<<data;
}

String cat_str::soutput(map<String, String, less<String> > &menuentry){
  char buf[MAX_BUF];
  vector <str * >::iterator i;
  ostrstream s(buf,sizeof(buf));

  for(i=v.begin();i!=v.end();i++)
    (*i)->output(s,menuentry);
  s<<ends;
  
  return String(buf);
}
ostream &cat_str::output(ostream &o, 
			 map<String, String, less<String> > &menuentry){
  o<<soutput(menuentry);
  return o;
}
void cat_str::output(map<String, String, less<String> > &menuentry){
  genoutput(soutput(menuentry),menuentry);
}

ostream &var_str::output(ostream &o,
			 map<String, String, less<String> > &menuentry){
  return o<<menuentry[var_name];
}
ostream &func_str::output(ostream &o,
			 map<String, String, less<String> > &menuentry){
  return f->output(o,args,menuentry);
}

/////////////////////////////////////////////////////
//  Debug routines
//
ostream &const_str::debuginfo(ostream &o){
  return o<<"CONST_STR: "<<data<<endl;
}
ostream &cat_str::debuginfo(ostream &o){
  vector<str *>::iterator i;
  o<<"CAT_STR: "<<endl;
  for(i=v.begin();i!=v.end();i++){
    (*i)->debuginfo(o);
  }
  return o;
}
ostream &var_str::debuginfo(ostream &o){
  return o<<"VAR_STR: "<<var_name<<endl;
}
ostream &func_str::debuginfo(ostream &o){
  o<<"FUNC_STR: "<<f->name()<<" ("<<endl;
  vector<cat_str *>::iterator i;  
  for(i=args.begin();i!=args.end();i++){
    o<<", ";
    (*i)->debuginfo(o);
  }
  return o<<")"<<endl;
}


/////////////////////////////////////////////////////
//  Function definitions:
//

ostream &prefix_func::output(ostream &o, vector<cat_str *> &,
			     map<String, String, less<String> > &){

  return o<<config->prefix();
}
ostream &ifroot_func::output(ostream &o, vector<cat_str *> & args,
			     map<String, String, less<String> > &menuentry){
  if(getuid())
    args[1]->output(o,menuentry);
  else
    args[0]->output(o,menuentry);

  return o;
}

ostream &print_func::output(ostream &o, vector<cat_str *> &args,
			    map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  if(empty_String(s)){
    cerr<<_("Zero-size argument to print function");
    throw informed_fatal();
  }
  return o<<s;
}
ostream &ifempty_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  if(empty_String(s))
    args[1]->output(o,menuentry);
  return o;
}
ostream &ifnempty_func::output(ostream &o, vector<cat_str *> &args,
			       map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  if(!empty_String(s))
    args[1]->output(o,menuentry);
  return o;
}
ostream &iffile_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  ifstream f(s.c_str());
  if(f)
    args[1]->output(o,menuentry);
  return o;
}
ostream &ifelsefile_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  ifstream f(s.c_str());
  if(f)
    args[1]->output(o,menuentry);
  else
    args[2]->output(o,menuentry);
  return o;
}
ostream &catfile_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  ifstream f(s.c_str());
  char c;

  while(f && f.get(c))
    o<<c;
  return o;
}
ostream &forall_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  const String &array=args[0]->soutput(menuentry);
  StrVec vec;
  StrVec::iterator i;
  String s;
  String varname=args[1]->soutput(menuentry);

  break_char(array, vec, ':');
  
  for(i=vec.begin(); i!=vec.end(); i++){
    menuentry[varname]=(*i);
    s+=args[2]->soutput(menuentry);
  }
  return o<<s;
}

ostream &esc_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  return o<<escape_String(args[0]->soutput(menuentry),
			  args[1]->soutput(menuentry));
}
ostream &escwith_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  return o<<escapewith_String(args[0]->soutput(menuentry),
			      args[1]->soutput(menuentry),
			      args[2]->soutput(menuentry));
}
ostream &escfirst_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String esc=args[1]->soutput(menuentry);
  String t;
  string::size_type  i;

  for(i=0;i!=s.length();i++){
    if(esc.length() && esc.contains(s[i])){
      t=s.substr(0,i);
      t+=args[2]->soutput(menuentry);
      t+=s.after(i);
      break;
    }
    t+=s[i];
  }
  return o<<t;
}
ostream &tolower_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  return o<<tolower_String(args[0]->soutput(menuentry));
}
ostream &toupper_func::output(ostream &o, vector<cat_str *> &args,
				  map<String, String, less<String> > &menuentry){

  return o<<toupper_String(args[0]->soutput(menuentry));
}
ostream &replacewith_func::output(ostream &o, vector<cat_str *> &args,
				  map<String, String, less<String> > &menuentry){

  return o<<replacewith_String(args[0]->soutput(menuentry),
			       args[1]->soutput(menuentry),
			       args[2]->soutput(menuentry));
}
ostream &nstring_func::output(ostream &o, vector<cat_str *> &args,
			    map<String, String, less<String> > &menuentry){
  int count= Stringtoi(args[0]->soutput(menuentry));
  int i;

  for(i=0; i<count; i++)
    o<<args[1]->soutput(menuentry);

  return o;
}
ostream &cppesc_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  return o<<cppesc_String(args[0]->soutput(menuentry));
}

ostream &add_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));

  return o<<itoString(x+y);
}
ostream &sub_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));

  return o<<itoString(x-y);
}
ostream &mult_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));

  return o<<itoString(x*y);
}
ostream &div_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));
  
  if(y)
    return o<<itoString(x/y);
  else
    return o<<"0";
}

ostream &ifelse_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  (!empty_String(s)) ?
    args[1]->output(o,menuentry)
    :
    args[2]->output(o,menuentry);
  return o;
}
ostream &ifeq_func::output(ostream &o, vector<cat_str *> &args,
			   map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String t=args[1]->soutput(menuentry);
  if(s==t)
    args[2]->output(o,menuentry);
  
  return o;
}
ostream &ifneq_func::output(ostream &o, vector<cat_str *> &args,
			   map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String t=args[1]->soutput(menuentry);
  if(!(s==t))
    args[2]->output(o,menuentry);
  
  return o;
}
ostream &ifeqelse_func::output(ostream &o, vector<cat_str *> &args,
			   map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String t=args[1]->soutput(menuentry);
  if(s==t)
    args[2]->output(o,menuentry);
  else
    args[3]->output(o,menuentry);

  return o;
}

ostream &cond_surr_func::output(ostream &o, vector<cat_str *> &args,
				map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  if(!empty_String(s)){
    args[1]->output(o,menuentry);
    args[0]->output(o,menuentry);
    args[2]->output(o,menuentry);
  }
  return o;
}

ostream &parent_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  return o<<String_parent(s);
}

ostream &basename_func::output(ostream &o, vector<cat_str *> &args,
			       map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  
  return o<<String_basename(s);
}
ostream &stripdir_func::output(ostream &o, vector<cat_str *> &args,
			       map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  
  return o<<String_stripdir(s);
}
ostream &entrycount_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<menuentry[PRIVATE_ENTRYCOUNT_VAR];
}
ostream &entryindex_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<menuentry[PRIVATE_ENTRYINDEX_VAR];
}
ostream &firstentry_func::output(ostream &o, vector<cat_str *> &args,
				 map<String, String, less<String> > &menuentry){
  int index=Stringtoi(menuentry[PRIVATE_ENTRYINDEX_VAR]);

  if(index == 0)
    args[0]->output(o,menuentry);
  return o;
}

ostream &lastentry_func::output(ostream &o, vector<cat_str *> &args,
				 map<String, String, less<String> > &menuentry){

  int index=Stringtoi(menuentry[PRIVATE_ENTRYINDEX_VAR]);
  int count=Stringtoi(menuentry[PRIVATE_ENTRYCOUNT_VAR]);

  if(index+1 == count)
    args[0]->output(o,menuentry);
  return o;
}


ostream &level_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<menuentry[PRIVATE_LEVEL_VAR];
}


ostream &rcfile_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->rcfile();
}
ostream &examplercfile_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->examplercfile();
}
ostream &mainmenutitle_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->mainmenutitle();
}
ostream &rootsection_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->rootsection();
}
ostream &rootprefix_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->rootprefix();
}
ostream &userprefix_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->userprefix();
}
ostream &treewalk_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->treewalk();
}
ostream &postoutput_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<config->postoutput();
}
ostream &preoutput_func::output(ostream &o, vector<cat_str *> &/*args*/,
				map<String, String, less<String> > &menuentry){
  return o<<config->preoutput();
}
ostream &cwd_func::output(ostream &o, vector<cat_str *> &/*args*/,
			  map<String, String, less<String> > &menuentry){
  char buf[300];
  //Bug: getcwd returns NULL if strlen(cwd) > sizeof(buf), so we get
  //     a segfault here.
  return o<<String(getcwd(buf,sizeof(buf)));
}

ostream &translate_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  String lang=args[0]->soutput(menuentry);
  String text=args[1]->soutput(menuentry);

  return o<<ldgettext(lang.c_str(), "menu-messages", text.c_str());
}


/////////////////////////////////////////////////////
//  "defined" function (macro).
//

ostream &func_def::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  String t;
  unsigned int i;
  map<String, String, less<String> > local_menuentry=menuentry;

  for(i=0; i<args_name.size(); i++)
    local_menuentry[args_name[i]]=args[i]->soutput(menuentry);

  f->output(o,local_menuentry);
  return o;
}
func_def::func_def(parsestream &i){
  char c;

  n=i.get_name();
  i.skip_space();
  i.skip_char('(');
  do{
    i.skip_space();
    c=i.get_char();
    if(c==')')
      break;
    i.put_back(c);
    i.skip_char('$');
    args_name.push_back(i.get_name());
    i.skip_space();
  } while((c=i.get_char())&&(c==','));
  i.put_back(c);
  i.skip_char(')');
  i.skip_space();
  i.skip_char('=');
  f=new cat_str(i);
}

/////////////////////////////////////////////////////
//  Supported stuff
//

supportedinfo::supportedinfo(parsestream &i){
  linenumber=1;
  int prec=0;
  while(1){
    try{
      String name;

      i.skip_space();
      name=i.get_name();
      if(name==String("endsupported"))
	return;
      name=upcase(name);
      if(dodebug)
	cerr<<"SUPPORTED_CONSTRUCT: name="<<name<<endl;
      
      supinf inf;
      inf.c=get_eq_cat_str(i);
      inf.prec=prec++;
      sup[name]=inf;
      if(dodebug)
	sup[name].c->debuginfo(cerr);
      i.skip_line();   //read away the final newline
    }
    catch(endofline d){}
  }
}

void supportedinfo::subst(map<String, String, less<String> > vars){

  map<String, String, less<String> >::iterator i;
  map<String, supinf, less<String> >::iterator j;

  if((i=vars.find(NEEDS_VAR))==vars.end()){
    cerr<<_("Undefined "NEEDS_VAR" variable in menuentries")<<endl;
    throw informed_fatal();
  }
  if((j=sup.find(upcase((*i).second)))==sup.end()){
    cerr<<_("Unknown "NEEDS_VAR"=\"")<<(*i).second<<"\""<<endl;
    throw informed_fatal();
  }
  genoutput((*j).second.c->soutput(vars), vars);
}
int supportedinfo::prec(String &name){
  map<String, supinf, less<String> >::iterator i;
  int p;
  if((i=sup.find(upcase(name)))==sup.end())
    p=MAXINT;
  else
    p=(*i).second.prec;
  //if(dodebug)
  //  cerr<<"PREC: name="<<upcase(name)<<"="<<p<<endl;
  return p;
}

ostream &supportedinfo::debuginfo(ostream &o){
  map<String, supinf, less<String> >::iterator i;
  for(i=sup.begin();i!=sup.end();i++){
    o<<"SUPPORTED:** name="<<(*i).first<<", prec="
	<<(*i).second.prec<<" Def="<<endl;
    (*i).second.c->debuginfo(o);
  }
  return o;
}
/////////////////////////////////////////////////////
//  forcetree stuff
//

void read_forcetree(parsestream &i){
  Regex r("[a-zA-Z/-_ ]");

  while(1){
    try{
      String name;
      StrVec v;
      menuentry *m;

      i.skip_space();
      name=i.get_name(r);
      if(!name.size())
	throw ident_expected(&i);
      if(name==String("endforcetree"))
	return;
      
      break_slashes(name,v);
      m=new menuentry;
      m->forced=true;
      m->vars[TITLE_VAR]=v[v.size()-1];
      menu.add_menuentry_ptr(v,m);  
      i.skip_line();
    }
    catch(endofline d){}
  }
  
}
/////////////////////////////////////////////////////
//  configinfo
//
configinfo::configinfo(parsestream &i){
  String errmsg(_("Parse error: String constant expected"));
  linenumber=1;
  treew="c(m)";
  userpref=rootpref=sort=prerun=preruntest=postrun=genmenu=
    hkexclude=startmenu=endmenu=submenutitle=also_run=NULL;
  mainmt="Debian";
  onlyuniquetitles=onlyrunasroot=onlyrunasuser=false;
  repeat_lang=NULL;

  hint_optimize=false;
  hint_nentry=6;
  hint_topnentry=5;
  hint_mixedpenalty=15;
  hint_minhintfreq=0.1;
  hint_mlpenalty=2000;
  hint_max_ntry=4;
  hint_max_iter_hint=5;
  hint_debug=false;

  //minhintfreq=0.1;
  //hintdebug=false;
  //n_entry_opt=6;
  //hint_toplevel_nopt=5;
  //hint_mlpenalty=20;
  //keep_sections=true;
  
  preout=String("#") + 
    String(_("Automatically generated file. Do not edit (see /usr/doc/menu/html/index.html)")) +
    String("\n\n");
  postout="";
  roots="/Debian";
  try{
    while(1){
        String name;
        name=i.get_name();
	if(name==String("supported")){
	  i.skip_line();
	  supported=new supportedinfo(i);
	} else if(name==String("forcetree")){
	  i.skip_line();
	  read_forcetree(i);
	} 
	else if(name==String("function"))
	  store_func(new func_def(i));
	else if(name==String("startmenu"))
	  startmenu=get_eq_cat_str(i);
	else if(name==String("endmenu"))
	  endmenu=get_eq_cat_str(i);
	else if(name==String("submenutitle"))
	  submenutitle=get_eq_cat_str(i);
	else if(name==String("hotkeyexclude"))
	  hkexclude=get_eq_cat_str(i);
	else if(name==String("genmenu"))
	  genmenu=get_eq_cat_str(i);	
	else if(name==String("prerun"))
	  prerun=get_eq_cat_str(i);	
	else if(name==String("postrun"))
	  postrun=get_eq_cat_str(i);
	else if(name==String("also_run"))
	  also_run=get_eq_cat_str(i);
       	else if(name==String("preruntest"))
	  preruntest=get_eq_cat_str(i);	
	else if(name==String("onlyrunasroot"))
	  onlyrunasroot=i.get_eq_boolean();	
	else if(name==String("onlyrunasuser"))
	  onlyrunasuser=i.get_eq_boolean();	
	else if(name==String("onlyuniquetitles"))
	  onlyuniquetitles=i.get_eq_boolean();	
	else if(name==String("sort"))
	  sort=get_eq_cat_str(i);

	else if(name==String("compat")){
	  compt=i.get_eq_Stringconst();
	  if(compt==String("menu-1"))
	    i.seteolmode(parsestream::eol_newline);
	  else if(compt==String("menu-2"))
	    i.seteolmode(parsestream::eol_semicolon);
	  else 
	    throw unknown_compat(&i, compt);
	}
	else if(name==String("rcfile"))
	  rcf=i.get_eq_Stringconst();
	else if(name==String("examplercfile"))
	  exrcf=i.get_eq_Stringconst();
	else if(name==String("mainmenutitle"))
	  mainmt=i.get_eq_Stringconst();
	else if(name==String("rootsection"))
	  roots=i.get_eq_Stringconst();
	else if(name==String("rootprefix"))
	  rootpref=get_eq_cat_str(i);
	else if(name==String("userprefix"))
	  userpref=get_eq_cat_str(i);
	else if(name==String("treewalk"))
	  treew=i.get_eq_Stringconst();
	else if(name==String("postoutput"))
	  postout=i.get_eq_Stringconst();
	else if(name==String("preoutput"))
	  preout=i.get_eq_Stringconst();
	else if(name==String("command")){
	  system((i.get_eq_Stringconst()).c_str());
	  exit(0);
	}
	else if(name==String("hotkeycase")){
	  String s=i.get_eq_Stringconst();
	  if(s==String("sensitive"))
	    hotkeycase=1;
	  else if (s==String("insensitive"))
	    hotkeycase=0;
	  else {
	    cerr<<_("install-menus: hotkeycase can only be {,in}sensitive")<<endl;
	    throw informed_fatal();
	  }
	} 
	else if(name==String("repeat_lang")){
	  repeat_lang=get_eq_cat_str(i);
	}
	else if(name==String("hint_optimize"))
	  hint_optimize=i.get_eq_boolean();
	else if(name==String("hint_nentry"))
	  hint_nentry=i.get_eq_double();
	else if(name==String("hint_topnentry"))
	  hint_topnentry=i.get_eq_integer();
	else if(name==String("hint_mixedpenalty"))
	  hint_mixedpenalty=i.get_eq_double();
	else if(name==String("hint_minhintfreq"))
	  hint_minhintfreq=i.get_eq_double();
	else if(name==String("hint_mlpenalty"))
	  hint_mlpenalty=i.get_eq_double();
	else if(name==String("hint_max_ntry")){
	  hint_max_ntry=i.get_eq_integer();
	  if(hint_max_ntry < 1)
	    hint_max_ntry=1;
	}
	else if(name==String("hint_max_iter_hint"))
	  hint_max_iter_hint=i.get_eq_integer();
	else if(name==String("hint_debug"))
	  hint_debug=i.get_eq_boolean();
	else
	  throw unknown_ident(&i, name);
      i.skip_line();//read away final newline
    }
  }
  catch(endoffile){}
  
  check_config();
}
void configinfo::check_config(){
  if(!(genmenu && startmenu && endmenu)){
    cerr<<_("At least one of genmenu, startmenu, endmenu\n"
	    "is undefined in the config file. All of these have to be \n"
	    "defined (although they may be equal to \"\")")<<endl;
    throw informed_fatal();
  }
}
String configinfo::prefix(){
  if(getuid()){
    struct passwd *pw=getpwuid(getuid());
    //String home=String(s);
    //String upr=userprefix()->soutput(menu.vars);
    //return home+"/"+upr;
    return String(pw->pw_dir)+"/"+userprefix()->soutput(menu.vars);
  }
  else
    return rootprefix()->soutput(menu.vars);
}

ostream &configinfo::debuginfo(ostream &o){
    o<<"Using compatibility with:"<<compt<<endl
     <<"mainmenutitle   : "<<mainmt   <<endl
     <<"rootsection     : "<<roots    <<endl
     <<"rcfile          : "<<rcf      <<endl
     <<"examplercfile   : "<<exrcf    <<endl
     <<"root-prefix     : "<<rootpref <<endl
     <<"user-prefix     : "<<userpref <<endl
     <<"startmenu       : "<<endl;
    if(startmenu)
      startmenu->debuginfo(o);
    o<<"endmenu         : "<<endl;
    if(endmenu)
      endmenu->debuginfo(o);
    o<<"genmenu         : "<<endl;
    if(genmenu)
      genmenu->debuginfo(o);
    o<<"submenutitle    : "<<endl;
    if(submenutitle)
      submenutitle->debuginfo(o);
  o<<"mainmenutitle   : "<<mainmt   <<endl
   <<"treewalk        : "<<treew    <<endl;
  return o;
}

/////////////////////////////////////////////////////
//  Misc
//

bool testuniqueness(map<String, String, less<String> > &menuentry){
  static set<String> uniquetitles;

  if(config->onlyuniquetitles){
    set <String>::iterator unique_i;
    String &title=menuentry[TITLE_VAR];
    if(title.length()){
      unique_i=uniquetitles.find(title);
      if(unique_i!=uniquetitles.end())
	return false;
      else
	uniquetitles.insert(title);
    }
  }
  return true;
}

map <String, String, less<String> > read_vars(parsestream &i){
  map <String, String, less<String> > m;
  try{
    String name, val;
    while(1){
      name=i.get_name();
      val=i.get_eq_Stringconst();
      
      if(do_translate_hack){
	if(name==String("title")){
	  //This won't work if ldgettext is also used (translate($lang)).
	  val=String(dgettext("menu-messages",val.c_str()));
	}
	if(name==String("section")){
	  StrVec v;
	  StrVec::iterator i;
	  break_slashes(val,v);
	  val=String("");
	  for(i=v.begin(); i!=v.end(); i++){
	    val=val + "/" + dgettext("menu-messages",(*i).c_str());
	  }
	  //cout<<":::"<<do_translate_hack<<" val="<<val<<endl;
	}
      }
      
      m[name]=val;
    } 
  }
  catch(endofline p){};
  return m;
}

void check_vars(parsestream &i,
		map <String, String, less<String> > &m){
  vector <String> need;
  map <String, String, less<String> >::iterator j;
  unsigned int k;

  need.push_back(SECTION_VAR);
  need.push_back(TITLE_VAR);
  need.push_back(NEEDS_VAR);

  for(k=0;k<need.size();k++){
    j=m.find(need[k]);
    if((j==m.end())||((*j).second==String("")))
      throw missing_tag(&i,need[k]);
  }
}
void read_input(parsestream &i){
  String s;
  try{
    while(1){
      map <String, String, less<String> > m;
      StrVec sec_vec;
      
      m=read_vars(i);

      // check presence of section,title,needs vars. Later we will blindly
      // assume they are defined.
      check_vars(i,m);

      break_slashes(m[SECTION_VAR],sec_vec);
      if(m[TITLE_VAR] != "/")
	sec_vec.push_back(m[TITLE_VAR]);	  
      if(supported->prec(m[NEEDS_VAR])!=MAXINT)
	menu.add_entry(sec_vec,m);
      i.skip_line();   //read away the final newline
    }
  }
  catch(endoffile p){}
}


void includemenus(String rep, String m){
  // copy examplercfile to rcfile, replacing the line
  // rep with menu-file m.
  char buf[MAX_BUF];
  char c;
  bool changed=false;
  ifstream *fi;
  ifstream fm(m.c_str());
  String input_filename;
  String output_filename;

  input_filename=config->prefix()+"/"+config->examplercfile(); 

  fi=new ifstream(input_filename.c_str());
  if(!*fi){
    if(getuid()){
      // running as non-root:
      delete(fi);
      String input_filename2=config->rootprefix()->soutput(menu.vars)+"/"+config->examplercfile();
      fi=new ifstream(input_filename2.c_str());
      if(!*fi){
	cerr<<_("Cannot open file ")<<input_filename<<" nor "
	    <<input_filename2<<endl; 
	throw informed_fatal();
      } else {
	input_filename=input_filename2;
      }
    } else {
      //running as root:
      cerr<<_("Cannot open file ")<<input_filename<<endl;
      throw informed_fatal();
    }
  }
  if(!fm){
    cerr<<_("Cannot open file ")<<m<<endl; throw informed_fatal();}

  output_filename=config->prefix()+"/"+config->rcfile();
  ofstream fo(output_filename.c_str());

  if(!fo){
    cerr<<"Cannot open file "<<output_filename<<endl; 
    if(getuid())
      cerr<<"In oder to be able to create the user config files for the"<<endl
	  <<"window managers, the above file needs to be writable (and the"<<endl
	  <<"directory needs to exists"<<endl;
    throw informed_fatal();}

  {
    while(fi->get(buf,sizeof(buf))){
      if(String(buf).contains(rep,0)){
	while(fm.get(buf,sizeof(buf))){
	  fo<<buf<<endl;
	  fm.get(c);
	}
	changed=true;
      }
      else
	fo<<buf<<endl;
      fi->get(c);
    }
  }
  if(!changed)
    cerr<<"Warning: String \""<<rep
	<<"\" didn't occur in example file "<<input_filename<<endl;
  delete(fi);
}

int main(int argc, char **argv){
  int c, option_index;
  char script[MAX_BUF];
  parsestream *ps, *psscript;
  String menudefname;
  
  setlocale (LC_MESSAGES, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

  try{
    if(argv[1])
      strcpy(script, argv[1]);
    else{
      cerr<<"install-menu: First parameter must be name of script"<<endl;
      throw informed_fatal();
    }

    while(1){
      c = getopt_long (argc, argv, "fdvh", long_options, &option_index);
      if(c==-1) 
	break;
      switch(c){
      case '?':;
      case 'h': usage();   break;
      case 'd': dodebug=1; break;
      case 'v': verbose=1; break;
      case 'f': break;           /* ignore for compatibility reasons */
      }
    };

    add_functions();
    
    if(!getuid())
      ps=new parsestream(script);
    else
      ps=new parsestream(script,MENUMETHODS);
    
    if(!ps->good()){
      cerr<<_("Cannot open script ")<<script<< _(" for reading")<<endl;
      throw informed_fatal();
    }
    config=new configinfo(*ps);
    if(dodebug){
      config->debuginfo(cerr);
      supported->debuginfo(cerr);
    }
    if(config->onlyrunasroot)
      if(getuid())
	return 0;
    if(config->onlyrunasuser)
      if(!getuid())
	return 0;
    if(config->prerun)
      system((config->prerun->soutput(menu.vars)).c_str());
    if(config->preruntest){
      bool r;
      r=system((config->preruntest->soutput(menu.vars)).c_str());
      if(r)
	return r;
    }
    if(config->repeat_lang && 
       (config->repeat_lang->soutput(menu.vars) == String("LOCALE"))){
      cout<<"Ja, hoor, repeat_lang="<<config->repeat_lang->soutput(menu.vars)<<endl;
      do_translate_hack=true;
    }
    psscript=new parsestream(cin);
    menu.vars[TITLE_VAR]=config->mainmenutitle();

    read_input(*psscript);
    if(config->hint_optimize){ 
      StrVec v;
      menu.process_hints(v);
    };
    menu.postprocess(1,0, config->rootsection());
    menu.output();
    closegenoutput();

    if(config->also_run){
      String run=config->also_run->soutput(menu.vars);
      StrVec run_vec;
      StrVec::iterator run_i;

      break_char(run, run_vec, ':');

      configinfo *old_config=config;  /* save old config data */
      parsestream *also_ps;

      for(run_i=run_vec.begin(); run_i!=run_vec.end(); run_i++){
	cout<<"Running :\""<<*run_i<<"\""<<endl;
	also_ps=new parsestream(*run_i);
	config=new configinfo(*also_ps);
	menu.output();
	closegenoutput();
	delete config;
	delete also_ps;
      }
      config=old_config;             /* restore old config data */
    }
    if(config->rcfile().length()&&config->examplercfile().length())
      includemenus("include-menu-defs",
		   config->prefix()+"/"+config->genmenu->soutput(menu.vars));
    if(config->postrun)
      system((config->postrun->soutput(menu.vars)).c_str());
    exit(0);
  }
  catch(genexcept& p){  p.report(); }

  cerr<<script<<": "<<_("Aborting")<<endl;

  exit(1);
}
