/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef VerbFunctionHelp_H
#define VerbFunctionHelp_H


#include <vector>
#include <map>
using namespace std;


/* ---------------------------------------------------------------------------------------------

    The classes defined here are for the purpose of storing the information required to
    give the user help for specific functions which follow the pattern of verb-parameters-values.
    For example, in the Macro languate, we have things such as:
      pcont (contour : 'on')

    and we want to be able to provide the user with in-editor help for these functions.

   --------------------------------------------------------------------------------------------- */




//-------------------------------------------------------------------------------------
// VerbFunctionHelpParam
// class to store all the information associated with a parameter
//-------------------------------------------------------------------------------------

class VerbFunctionHelpParam
{
public:
    VerbFunctionHelpParam() {};
    ~VerbFunctionHelpParam(){values.clear();};

    void addValue(QString *value) {values.push_back(value);}
    
    QString name()                          {return name_;}
    void    setName(const QString &newName) {name_ = newName;}

    int numValues() {return values.size();}
    QString valueName(int i) {return *values[i];}


private:
    vector<QString *> values;
    QString name_;
};



//-------------------------------------------------------------------------------------
// VerbFunctionHelpFunction
// class to store all the information associated with a function
//-------------------------------------------------------------------------------------

class VerbFunctionHelpFunction
{
public:
    VerbFunctionHelpFunction() {};
    ~VerbFunctionHelpFunction(){parameters.clear();};

//    void addParameter(VerbFunctionHelpParam *parameter) {parameters.push_back(parameter);};
    void addParameter(VerbFunctionHelpParam *parameter) {paramList.push_back(parameter); parameters[parameter->name()] = parameter;};

    QString name()                          {return name_;}
    void    setName(const QString &newName) {name_ = newName;}

//    void addParam(VerbFunctionHelpParam *param) {parameters[param->name()] = param;};
    int numParams() {return paramList.size();}
    QString paramName(int i) {return paramList[i]->name();}
    
    VerbFunctionHelpParam *paramFromName(QString &name) {return parameters[name];}

    VerbFunctionHelpParam *param(int i) {return paramList[i];}

private:
    vector<VerbFunctionHelpParam *> paramList;
    map<QString, VerbFunctionHelpParam *> parameters;
    QString name_;
};



//-------------------------------------------------------------------------------------
//    The VerbFunctionHelp class allows the loading of a specially-prepared XML file with
//    all the function definitions in it (this is in its constructor). It also provides
//    the ability to query whether the given string is the name of a function for which
//    we have help available, and an accessor function to get a VerbFunctionHelpFunction
//    pointer from a given name.
//-------------------------------------------------------------------------------------


class VerbFunctionHelp
{
public:
    VerbFunctionHelp(QString &path);
    ~VerbFunctionHelp(){functions.clear();};

    bool isHelpAvailableForFunction(const QString &function);
    VerbFunctionHelpFunction *function(QString &functionName) {return functions[functionName];};


private:

    void addFunction(VerbFunctionHelpFunction *function) {functions[function->name()] = function;};

    //vector<IconFunctionHelpFunction> functions;
    map<QString, VerbFunctionHelpFunction *> functions;
    VerbFunctionHelpFunction *currentHelpFunction;

};


#endif

