/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.5 2001/10/06 16:32:17 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of Split */

int mdata_Split_to_xml(gzFile *fd, mdata *data) {
	return 0;
}

int mdata_Split_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_SPLIT) return -1;
	
	return 0;
}

int mdata_Split_setdata(mdata *data, const char *str, int fieldtype, const char *match) {
	const char *errstr;
	int errofs;
	
	data->key	= malloc(strlen(str)+1);
	assert(data->key);
	strcpy(data->key, str);
	
	data->data.split.match    	= pcre_compile(match, 0, &errstr, &errofs, NULL);
	data->data.split.fieldtype	= fieldtype;
	
	if (data->data.split.match == NULL) {
		fprintf(stderr, "%s.%d: regex compilation error: %s\n", __FILE__, __LINE__, errstr);
		return -1;
	}
	
	return 0;
}

int mdata_Split_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	return 0;
}



int mdata_Split_append(mdata *dst, mdata *src) {
	
	return 0;
}

mdata *mdata_Split_init() {
	mdata *data = mdata_init();
	assert(data);
	
	data->key		= NULL;
	data->type		= M_DATA_TYPE_SPLIT;
	
#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */	
	data->data.split.match		= NULL;
	data->data.split.fieldtype	= 0;
	
	return data;
}

mdata *mdata_Split_copy(mdata *src) {
	mdata *data = mdata_Split_init();
	assert(data);
	
	fprintf(stderr, "%s.%d: can't copy datatype: split\n", __FILE__, __LINE__);
	
	/* setdata */
	
	return data;
}

mdata *mdata_Split_create(const char *dest, int fieldtype, const char *match) {
	mdata *data = mdata_Split_init();
	assert(data);
	mdata_Split_setdata(data, dest, fieldtype, match);
	
	return data;
}

/* end of Split */
