/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.1 2001/12/23 15:11:20 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

/* this code is taken from the squid plugin */

/* init the plugin */

int mplugins_input_isdn4bsd_dlinit(mconfig *ext_conf) {
	config_input *conf = NULL;
	const char *errptr;
	int erroffset = 0;

/* get the neccesary space */
	conf = malloc(sizeof(config_input));
	memset(conf, 0, sizeof(config_input));

/* set some defaults */	
	conf->inputfilename = NULL;
	
	conf->inputfile = stdin;
	
	conf->buf_len = 256;
	conf->buf_inc = 128;
	conf->buffer = malloc(conf->buf_len * sizeof(char));

/* compile the match */	
	if ((conf->match_isdn4bsd = 
	     pcre_compile(
			  /* date */
			  "^([0-9]{2}\\.[0-9]{2}\\.[0-9]{4} [0-9]{2}:[0-9]{2}:[0-9]{2}) ",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd = 
	     pcre_compile(
			  /* .. connection ......  */
			  "CHD ([0-9]{5}) I4BCBC ",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_dialing = 
	     pcre_compile(
			  /*                 source      dest  */
			  "dialing out from ([0-9]+) to ([0-9]+)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_outgoing_proceeding = 
	     pcre_compile(
			  "outgoing call proceeding \\(ctl [0-9], ch ([0-9])\\)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_outgoing_active = 
	     pcre_compile(
			  "outgoing call active \\(ctl [0-9], ch [0-9], .+\\)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_outgoing_clearing = 
	     pcre_compile(
			  "outgoing call disconnected \\(.+\\)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_outgoing_clearing_reason = 
	     pcre_compile(
			  "cause ([0-9]+): (.+)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_rate = 
	     pcre_compile(
			  "rate ([0-9]+) sec/unit \\(.+\\)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_charging = 
	     pcre_compile(
			  "charging: ([0-9]+) units, ([0-9]+) seconds$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_accounting = 
	     pcre_compile(
			  "accounting: in ([0-9]+), out ([0-9]+)",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	if ((conf->match_isdn4bsd_chd_manual = 
	     pcre_compile(
			  "manual disconnect",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "rexexp compilation error at pos %d: %s, \n",
			 erroffset,
			 errptr);
		return -1;
	}
	
	conf->match_isdn4bsd_extra = pcre_study(conf->match_isdn4bsd, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

/* connect the plugin config to the master config */	
	ext_conf->plugin_conf = conf;
	
	return 0;
}

/* destructor */

int mplugins_input_isdn4bsd_dlclose(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

/* clean up everything you have opened, reserved */
	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		fclose(conf->inputfile);
	}
	
	free(conf->buffer);
	
	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_input_isdn4bsd_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_input *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
		{"inputfile",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->inputfilename)},
		
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_input_isdn4bsd_set_defaults(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		if (!(conf->inputfile = fopen(conf->inputfilename, "r"))) {
			fprintf(stderr, "%s %s: %s\n", _("Can't open inputfile "), conf->inputfilename, strerror(errno));
			return -1;
		}
	}
	
	return 0;
}


int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_input_isdn4bsd_dlinit;
	func->dlclose = mplugins_input_isdn4bsd_dlclose;
	func->parse_config = mplugins_input_isdn4bsd_parse_config;
	func->set_defaults = mplugins_input_isdn4bsd_set_defaults;
	func->get_next_record = mplugins_input_isdn4bsd_get_next_record;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;
	 
	return 0;
}
