// Copyright (c) 2001-2003 Rob Kaper <cap@capsi.com>,
//               2001 Erik Bourget <ebourg@cs.mcgill.ca>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// version 2 as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

#include <signal.h>
#include <syslog.h>
#include <unistd.h>

#include <iostream>
#include <string>

#include <libcapsinetwork/listener.h>
#include <libcapsinetwork/socket.h>

#include "const.h"
#include "main.h"
#include "server.h"

MonopdServer *server;

int main(int argc, char **argv)
{
	srand((unsigned) time(0));
	signal(SIGPIPE,SIG_IGN);

	server = new MonopdServer();
	if (argc > 1)
		server->setPort(atoi(argv[1]));

	Listener *listener = new Listener();
	if ( listener->addListenPort( server->port() ) == -1 )
	{
		syslog( LOG_ERR, "failed to bind listen port %d, exiting", server->port() );
		std::cerr << "Failed to bind listen port, exiting." << std::endl;
		delete server;
		delete listener;
		exit(1);
	}

	// close stdin, stdout, stderr
	// close(0); close(1); close(2);

	server->initMonopigatorEvent();

	for(;;)
	{
		// Check for network events
		listener->do_select();

		// Check for scheduled events in the timer
		int fd = server->processEvents();
		if(fd != -1)
		{
			Socket *delSocket = listener->findSocket(fd);
			if (delSocket && !server->findPlayer(delSocket))
				delSocket->setStatus(Socket::Close);
		}
	}

	// Clean up memory
	delete server;
	delete listener;

	return 0;
}

void socketHandler(Socket *socket, std::string data)
{
	switch(socket->status())
	{
		case Socket::New:
			socket->setStatus(Socket::Ok);
			socket->ioWrite(std::string("<monopd><server version=\"") + MONOPD_VERSION_STRING + "\"/></monopd>\n");
			server->initSocketTimeoutEvent( socket->fd() );
			break;

		case Socket::Close:
		case Socket::Closed:
			server->closedSocket(socket);
			break;
			
		case Socket::Ok:
			server->processInput(socket, data);
			break;
	}
}
