/*
 *	draw.c
 *
 *	Routines for drawing text on images
 *
 *	Copyright 2000, Jeroen Vreeken
 *	This program is published under the GNU public license
 *
 *	Based on code from Jan Gyselinck
 */

struct draw_char {
	char ascii;
	char pix[6][6];
};

struct draw_char draw_table[]= {
	{
		'0',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,1,1},
			{0,1,0,1,0,1},
			{0,1,0,1,0,1},
			{0,1,1,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'1',	
		{
			{0,0,0,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0}
		}
	},
	{
		'2',
		{
			{0,0,1,1,0,0},
			{0,1,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,1,1,1,1,0}
		}
	},
	{
		'3',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,0,1,1,0},
			{0,0,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'4',
		{
			{0,0,0,0,1,0},
			{0,0,0,1,1,0},
			{0,0,1,0,1,0},
			{0,1,1,1,1,1},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0}
		}
	},
	{
		'5',
		{
			{0,1,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,1,1,1,1,0}
		}
	},
	{
		'6',
		{
			{0,0,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'7',
		{
			{0,1,1,1,1,1},
			{0,0,0,0,0,1},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,0,1,0,0,0}
		}
	},
	{
		'8',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'9',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		':',
		{
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
		}
	},
	{
		'-',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,1,1,1,1},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		0,
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	}
};

int draw_text (char *image, int startx, int starty, int height, int width, char *text)
{
	int i, pos=0, x, y;
	
	while (text[pos]) {
		i=0;
		while (draw_table[i].ascii && draw_table[i].ascii!=text[pos]) i++;
		for (x=0; x<6; x++) {
			for (y=0; y<6; y++) {
				if (draw_table[i].pix[y][x]) {
					if ((image[(x+startx+pos*6)*3+0+(y+starty)*width*3]>> 7) ||
					    (image[(x+startx+pos*6)*3+1+(y+starty)*width*3]>> 7) ||
					    (image[(x+startx+pos*6)*3+2+(y+starty)*width*3]>> 7)) {
						image[(x+startx+pos*6)*3+0+(y+starty)*width*3]=0;
						image[(x+startx+pos*6)*3+1+(y+starty)*width*3]=0;
						image[(x+startx+pos*6)*3+2+(y+starty)*width*3]=0;
					} else {
						image[(x+startx+pos*6)*3+0+(y+starty)*width*3]=255;
						image[(x+startx+pos*6)*3+1+(y+starty)*width*3]=255;
						image[(x+startx+pos*6)*3+2+(y+starty)*width*3]=255;					
					}
				}
			}
		}
		pos++;
	}
	return 0;
}

