
/*
 * %Z%%M% %I% %E%
 *
 * Copyright (c) Rich Burridge. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "mptool.h"
#include <stdio.h>
#include <string.h>

static GList *hdr_selection = NULL;


void
ShowFile (GtkMenuItem *menuitem,
          gpointer user_data)
{
    do_show_file();
}


void
ExitMptool (GtkMenuItem *menuitem,
            gpointer user_data)
{
    exit(0);
}


void
ShowHeaders (GtkMenuItem *menuitem,
             gpointer user_data)
{
    if (header_frame_widget == NULL) {
        header_frame_widget = create_header_frame_widget();
    }
    set_active(F_HDRS, "hdr_add_button", False);
    set_active(F_HDRS, "hdr_remove_button", False);
    do_hdrs_reset();                         /* Headers to print. */

    add_help(F_HDRS, "header_form", wi_header_frame_help);
    add_help(F_HDRS, "hdrs_all", wi_headers_all_help);
    add_help(F_HDRS, "hdr_list", wi_hdr_list_help);
    add_help(F_HDRS, "hdr_list_add", wi_hdr_add_help);
    add_help(F_HDRS, "hdr_add_label", wi_hdr_add_help);
    add_help(F_HDRS, "hdr_apply", wi_hdr_apply_help);
    add_help(F_HDRS, "hdr_dismiss", wi_hdr_dismiss_help);
    add_help(F_HDRS, "hdr_add_button", wi_hdr_add_help);
    add_help(F_HDRS, "hdr_remove_button", wi_hdr_remove_help);
    add_help(F_HDRS, "hdr_reset", wi_hdr_reset_help);

    gtk_widget_show(header_frame_widget);
}


void
ShowInput (GtkMenuItem *menuitem,
           gpointer user_data)
{
    if (input_frame_widget == NULL) {
        input_frame_widget = create_input_frame_widget();
    }
    InputReset(NULL, NULL);

    add_help(F_INPUT, "input_form", wi_input_frame_help);
    add_help(F_INPUT, "prologue_label", wi_prologue_help);
    add_help(F_INPUT, "prologue", wi_prologue_help);
    add_help(F_INPUT, "input_folder", wi_opt_folder_help);
    add_help(F_INPUT, "input_digest", wi_opt_digest_help);
    add_help(F_INPUT, "input_elm", wi_props_elm_help);
    add_help(F_INPUT, "input_from", wi_props_from_help);
    add_help(F_INPUT, "input_content", wi_props_content_help);
    add_help(F_INPUT, "input_modtime", wi_props_modtime_help);
    add_help(F_INPUT, "input_apply", wi_input_apply_help);
    add_help(F_INPUT, "input_reset", wi_input_reset_help);
    add_help(F_INPUT, "input_dismiss", wi_input_dismiss_help);

    gtk_widget_show(input_frame_widget);
}


void
ShowOutput (GtkMenuItem *menuitem,
            gpointer user_data)
{
    if (output_frame_widget == NULL) {
        output_frame_widget = create_output_frame_widget();
    }
    OutputReset(NULL, NULL);

    add_help(F_OUTPUT, "output_form", wi_output_frame_help);
    add_help(F_OUTPUT, "output_apply", wi_output_apply_help);
    add_help(F_OUTPUT, "output_reset", wi_output_reset_help);
    add_help(F_OUTPUT, "output_dismiss", wi_output_dismiss_help);
    add_help(F_OUTPUT, "line_length_label", wi_line_length_help);
    add_help(F_OUTPUT, "line_length", wi_line_length_help);
    add_help(F_OUTPUT, "page_length_label", wi_page_length_help);
    add_help(F_OUTPUT, "page_length", wi_page_length_help);
    add_help(F_OUTPUT, "printer_name_label", wi_printer_name_help);
    add_help(F_OUTPUT, "printer_name", wi_printer_name_help);

    gtk_widget_show(output_frame_widget);
}


void
ShowPrinting (GtkMenuItem *menuitem,
              gpointer user_data)
{
    if (printing_frame_widget == NULL) {
        printing_frame_widget = create_printing_frame_widget ();
    }
    PrintingReset(NULL, NULL);

    add_help(F_PRINT, "printing_form", wi_props_frame_help);
    add_help(F_PRINT, "print_col_label", wi_props_col_help);
    add_help(F_PRINT, "print_col", wi_props_col_help);
    add_help(F_PRINT, "print_tab_label", wi_props_tab_help);
    add_help(F_PRINT, "print_tab", wi_props_tab_help);
    add_help(F_PRINT, "print_bmargin", wi_props_margin_help);
    add_help(F_PRINT, "print_lmargin", wi_props_margin_help);
    add_help(F_PRINT, "print_rmargin", wi_props_margin_help);
    add_help(F_PRINT, "print_tmargin", wi_props_margin_help);
    add_help(F_PRINT, "print_bmlabel", wi_props_margin_help);
    add_help(F_PRINT, "print_lmlabel", wi_props_margin_help);
    add_help(F_PRINT, "print_rmlabel", wi_props_margin_help);
    add_help(F_PRINT, "print_tmlabel", wi_props_margin_help);
    add_help(F_PRINT, "print_margins_label", wi_props_margin_help);
    add_help(F_PRINT, "print_header", wi_opt_header_help);
    add_help(F_PRINT, "print_wrap", wi_props_wrap_help);
    add_help(F_PRINT, "print_flip", wi_props_flip_help);
    add_help(F_PRINT, "print_forcepage", wi_props_forcepage_help);
    add_help(F_PRINT, "print_number", wi_props_number_help);
    add_help(F_PRINT, "print_reverse", wi_props_reverse_help);
    add_help(F_PRINT, "print_apply", wi_props_apply_help);
    add_help(F_PRINT, "print_reset", wi_props_reset_help);
    add_help(F_PRINT, "print_dismiss", wi_props_dismiss_help);

    gtk_widget_show(printing_frame_widget);
}


void
SaveDefaults (GtkMenuItem *menuitem,
              gpointer user_data)
{
    do_save_defaults();
}


void
ShowUsername (GtkMenuItem *menuitem,
              gpointer user_data)
{
    if (username_frame_widget == NULL) {
        username_frame_widget = create_username_frame_widget();
    }
    UNReset(NULL, NULL);

    add_help(F_USER, "un_form",         wi_un_form_help);
    add_help(F_USER, "un_apply",        wi_un_apply_help);
    add_help(F_USER, "un_reset",        wi_un_reset_help);
    add_help(F_USER, "un_dismiss",      wi_un_dismiss_help);
    add_help(F_USER, "aliasname_label", wi_aliasname_help);
    add_help(F_USER, "aliasname",       wi_aliasname_help);
    add_help(F_USER, "unc_label",       wi_props_passc_help);
    add_help(F_USER, "un_chars",        wi_props_passc_help);
    add_help(F_USER, "unw_label",       wi_props_passw_help);
    add_help(F_USER, "un_words",        wi_props_passw_help);

    gtk_widget_show(username_frame_widget);
}


void
HelpGeneral (GtkMenuItem *menuitem,
             gpointer user_data)
{
    do_show_help(g_strjoin("\n\n",
                            wi_main_frame_help,
                            wi_filename_help,
                            wi_file_type_help,
                            wi_output_help,
                            wi_org_type_help,
                            wi_paper_size_help,
                            wi_subject_help,
                            wi_no_sides_help,
                            wi_copies_help,
                            wi_print_help,
                            wi_reset_help,
                            NULL));
}


void
HelpHeaders (GtkMenuItem *menuitem,
             gpointer user_data)
{
    do_show_help(g_strjoin("\n\n",
                            wi_header_frame_help,
                            wi_headers_all_help,
                            wi_hdr_list_help,
                            wi_hdr_add_help,
                            wi_hdr_remove_help,
                            wi_hdr_apply_help,
                            wi_hdr_reset_help,
                            wi_hdr_dismiss_help,
                            NULL));
}


void
HelpInput (GtkMenuItem *menuitem,
           gpointer user_data)
{
    do_show_help(g_strjoin("\n\n",
                            wi_input_frame_help,
                            wi_prologue_help,
                            wi_opt_folder_help,
                            wi_opt_digest_help,
                            wi_props_elm_help,
                            wi_props_from_help,
                            wi_props_content_help,
                            wi_props_modtime_help,
                            wi_input_apply_help,
                            wi_input_reset_help,
                            wi_input_dismiss_help,
                            NULL));
}


void
HelpOutput (GtkMenuItem *menuitem,
            gpointer user_data)
{
    do_show_help(g_strjoin("\n\n",
                            wi_output_frame_help,
                            wi_printer_name_help,
                            wi_line_length_help,
                            wi_page_length_help,
                            wi_output_bsd_help,
                            wi_output_apply_help,
                            wi_output_reset_help,
                            wi_output_dismiss_help,
                            NULL));
}


void
HelpPrinting (GtkMenuItem *menuitem,
              gpointer user_data)
{
    do_show_help(g_strjoin("\n\n",
                            wi_props_frame_help,
                            wi_props_col_help,
                            wi_props_tab_help,
                            wi_opt_header_help,
                            wi_props_wrap_help,
                            wi_props_flip_help,
                            wi_props_forcepage_help,
                            wi_props_number_help,
                            wi_props_reverse_help,
                            wi_props_apply_help,
                            wi_props_reset_help,
                            wi_props_dismiss_help,
                            NULL));
}


void
HelpSave (GtkMenuItem *menuitem,
          gpointer user_data)
{
    do_show_help(g_strjoin("\n\n",
                            wi_props_defs_help,
                            NULL));
}


void
HelpUsername (GtkMenuItem *menuitem,
              gpointer user_data)
{
    do_show_help(g_strjoin("\n\n",
                            wi_un_form_help,
                            wi_aliasname_help,
                            wi_props_passc_help,
                            wi_props_passw_help,
                            wi_un_apply_help,
                            wi_un_reset_help,
                            wi_un_dismiss_help,
                            NULL));
}


/*
 * Do corrections like in 'adjust_paper_size' (../common/option.c)
 *
 * Save values with 'set_int_opt_val' and - if output widget is realised -
 * update the displayed values. This is the same action (apart from the
 * printername) as done with the apply-button. I hesitated to set the
 * variables plen and llen via 'set_int_opt_val' since these seem to be used
 * as defaults. But if the output widget is not shown, incorrect values would
 * be used.
 *
 * Unlike 'adjust_paper_size', this function will not honour settings for the
 * parameters 'O_LLEN' and 'O_PLEN' from the commandline or a resource file.
 */

void
OutputUpdate (GtkToggleButton *togglebutton,
              gpointer user_data)
{
    enum paper_type psize;
    int linelen, pagelen, land;

    if (get_bool_value(F_MAIN, "paper_size_a4")) {
        psize = P_A4;
    } else if (get_bool_value(F_MAIN, "paper_size_us")) {
        psize = P_US;
    } else {
        psize = P_NONE;
    }

    if (get_bool_value(F_MAIN, "output_land")) {
        land = 1;
    } else if (get_bool_value(F_MAIN, "output_port")) {
        land = 0;
    } else {
        land = -1;
    }

    if (land == -1) {
        return;     /* Organizer formats - do nothing. */
    }

    switch (psize) {
        case P_US:
            linelen = (land) ? 80 : 80;
            pagelen = (land) ? 68 : 72;
            break;

        case P_A4:
            linelen = (land) ? 90 : 80;
            pagelen = (land) ? 66 : 78;
            break;

/*
 * Not nice: this uses the system default and ignores
 * resources and command line options. Maybe should do
 * nothing at all ...
 */

        default:
            linelen = LINELENGTH;
            pagelen = PAGELENGTH;
            break;
    }

/* Now set correct values as new default (?) values. */

    set_int_opt_val(O_LLEN, linelen);
    set_int_opt_val(O_PLEN, pagelen);

    if (output_frame_widget == NULL) {
        return;
    } else {

        /* Show new values in output widget. */

        set_int_value(F_OUTPUT, "line_length", linelen);
        set_int_value(F_OUTPUT, "page_length", pagelen);
    }
}


void
PrintFiles (GtkButton *button,
            gpointer user_data)
{
    do_print_files();
}


void
ResetOptions (GtkButton *button,
              gpointer user_data)
{
    do_reset_options();
}


void
ToggleHdrList (GtkToggleButton *togglebutton,
               gpointer user_data)
{
    do_toggle_hdr_list();
}


void
HdrsAdd (GtkButton *button,
         gpointer user_data)
{
    do_hdrs_add();
}


void
HdrsRemove (GtkButton *button,
            gpointer user_data)
{
    GtkWidget *hdr_list = lookup_widget(F_HDRS, "hdr_list");

    if (hdr_selection != NULL) {
        GList *copy = g_list_copy(hdr_selection);

        g_list_free(hdr_selection);
        hdr_selection = NULL;
        gtk_list_remove_items(GTK_LIST(hdr_list), copy);
    } else {
        notice(F_HDRS, mptool_strs[(int) S_NONE]);
    }
}


void
HdrsApply (GtkButton *button,
           gpointer user_data)
{
    do_hdrs_apply();
}


void
HdrsReset (GtkButton *button,
           gpointer user_data)
{
    do_hdrs_reset();
}


void
HdrsDismiss (GtkButton *button,
             gpointer user_data)
{
    gtk_widget_hide(F_HDRS);
}


void
InputApply (GtkButton *button,
            gpointer user_data)
{
    char *prologue = get_str_value(F_INPUT, "prologue");

    if (prologue && *prologue != '\0') {
        STRCPY(proname, prologue);
    }

    set_int_opt_val(O_FOLDER, get_bool_value(F_INPUT,  "input_folder"));
    set_int_opt_val(O_DIGEST, get_bool_value(F_INPUT,  "input_digest"));
    set_int_opt_val(O_ELM,    get_bool_value(F_INPUT,  "input_elm"));
    set_int_opt_val(O_PR_ORIG, get_bool_value(F_INPUT, "input_from"));
    set_int_opt_val(O_CONTENT, get_bool_value(F_INPUT, "input_content"));
    set_int_opt_val(O_MODTIME, get_bool_value(F_INPUT, "input_modtime"));
}


void
InputReset (GtkButton *button,
            gpointer user_data)
{
    set_str_value(F_INPUT,  "prologue",      proname);
    set_bool_value(F_INPUT, "input_folder",  int_opt_val(O_FOLDER));
    set_bool_value(F_INPUT, "input_digest",  int_opt_val(O_DIGEST));
    set_bool_value(F_INPUT, "input_elm",     int_opt_val(O_ELM));
    set_bool_value(F_INPUT, "input_from",    int_opt_val(O_PR_ORIG));
    set_bool_value(F_INPUT, "input_content", int_opt_val(O_CONTENT));
    set_bool_value(F_INPUT, "input_modtime", int_opt_val(O_MODTIME));
}


void
InputDismiss (GtkButton *button,
              gpointer user_data)
{
    gtk_widget_hide(F_INPUT);
}


void
OutputApply (GtkButton *button,
             gpointer user_data)
{
    set_int_opt_val(O_LLEN,    get_int_value(F_OUTPUT, "line_length"));
    set_int_opt_val(O_PLEN,    get_int_value(F_OUTPUT, "page_length"));
    set_str_opt_val(O_PR_NAME, get_str_value(F_OUTPUT, "printer_name"));
}


void
OutputReset (GtkButton *button,
             gpointer user_data)
{
    set_int_value(F_OUTPUT, "line_length",  int_opt_val(O_LLEN));
    set_int_value(F_OUTPUT, "page_length",  int_opt_val(O_PLEN));
    set_str_value(F_OUTPUT, "printer_name", str_opt_val(O_PR_NAME));
}


void
OutputDismiss (GtkButton *button,
               gpointer user_data)
{
    gtk_widget_hide(F_OUTPUT);
}


void
PrintingApply (GtkButton *button,
               gpointer user_data)
{
    int n;

    check_int_value(&n, mptool_strs[(int) S_INVCOL],
                    1, MAXLINELENGTH, DEFCOLUMNS, "print_col");
    set_int_opt_val(O_NUMCOLS, n);
    check_int_value(&n, mptool_strs[(int) S_INVTAB],
                    1, MAXLINELENGTH, TABSIZE, "print_tab");
    set_int_opt_val(O_TABSIZE, n);
    check_int_value(&n, mptool_strs[(int) S_BMARGIN],
                    0, MAXMARGIN, DEFMARGIN, "print_bmargin");
    set_margin(M_BOTTOM, n);
    check_int_value(&n, mptool_strs[(int) S_LMARGIN],
                    0, MAXMARGIN, DEFMARGIN, "print_lmargin");
    set_margin(M_LEFT, n);
    check_int_value(&n, mptool_strs[(int) S_RMARGIN],
                    0, MAXMARGIN, DEFMARGIN, "print_rmargin");
    set_margin(M_RIGHT, n);
    check_int_value(&n, mptool_strs[(int) S_TMARGIN],
                    0, MAXMARGIN, DEFMARGIN, "print_tmargin");
    set_margin(M_TOP, n);
 
    set_int_opt_val(O_BURSTPAGE, get_bool_value(F_PRINT, "print_header"));
    set_int_opt_val(O_WRAPW,     get_bool_value(F_PRINT, "print_wrap"));
    set_int_opt_val(O_FLIP,      get_bool_value(F_PRINT, "print_flip"));
    set_int_opt_val(O_FORCEPAGE, get_bool_value(F_PRINT, "print_forcepage"));
    set_int_opt_val(O_NUMBER,    get_bool_value(F_PRINT, "print_number"));
    set_int_opt_val(O_TUMBLE,    get_bool_value(F_PRINT, "print_reverse"));
}


void
PrintingReset (GtkButton *button,
               gpointer user_data)
{
    set_int_value(F_PRINT,  "print_col",       int_opt_val(O_NUMCOLS));
    set_int_value(F_PRINT,  "print_tab",       int_opt_val(O_TABSIZE));
    set_int_value(F_PRINT,  "print_bmargin",   get_margin(M_BOTTOM));
    set_int_value(F_PRINT,  "print_lmargin",   get_margin(M_LEFT));
    set_int_value(F_PRINT,  "print_rmargin",   get_margin(M_RIGHT));
    set_int_value(F_PRINT,  "print_tmargin",   get_margin(M_TOP));
    set_bool_value(F_PRINT, "print_header",    int_opt_val(O_BURSTPAGE));
    set_bool_value(F_PRINT, "print_wrap",      int_opt_val(O_WRAPW));
    set_bool_value(F_PRINT, "print_flip",      int_opt_val(O_FLIP));
    set_bool_value(F_PRINT, "print_forcepage", int_opt_val(O_FORCEPAGE));
    set_bool_value(F_PRINT, "print_number",    int_opt_val(O_NUMBER));
    set_bool_value(F_PRINT, "print_reverse",   int_opt_val(O_TUMBLE));
}


void
PrintingDismiss (GtkButton *button,
                 gpointer user_data)
{
    gtk_widget_hide(F_PRINT);
}


void
UNApply (GtkButton *button,
         gpointer user_data)
{
    char m[MAXLINE];

    set_str_opt_val(O_ALIAS, get_str_value(F_USER, "aliasname"));

    set_int_opt_val(O_NAMELEN, get_int_value(F_USER, "un_chars"));
    if (int_opt_val(O_NAMELEN) < 1 || int_opt_val(O_NAMELEN) > MAXLINELENGTH) {
        SPRINTF(m, mptool_strs[(int) S_INVCHARS], NAMELENGTH);
        notice(F_USER, m);
        set_int_opt_val(O_NAMELEN, NAMELENGTH);
        set_int_value(F_USER, "un_chars", int_opt_val(O_NAMELEN));
    }
    set_int_opt_val(O_NAMEF, get_int_value(F_USER, "un_words"));
    if (int_opt_val(O_NAMEF) < 1 || int_opt_val(O_NAMEF) > MAXLINELENGTH) {
        SPRINTF(m, mptool_strs[(int) S_INVWORDS], NAMEFIELDS);
        notice(F_USER, m);
        set_int_opt_val(O_NAMEF, NAMEFIELDS);
        set_int_value(F_USER, "un_words", int_opt_val(O_NAMEF));
    }
}


void
UNReset (GtkButton *button,
         gpointer user_data)
{
    set_str_value(F_USER, "aliasname", str_opt_val(O_ALIAS));
    set_int_value(F_USER, "un_chars",  int_opt_val(O_NAMELEN));
    set_int_value(F_USER, "un_words",  int_opt_val(O_NAMEF));
}


void
UNDismiss (GtkButton *button,
           gpointer user_data)
{
    gtk_widget_hide(F_USER);
}


void
HelpDismiss (GtkButton *button,
             gpointer user_data)
{
    gtk_widget_hide(F_HELP);
}


gboolean
dismiss_window (GtkWidget *widget,
                GdkEvent *event,
                gpointer user_data)
{
    if (widget == header_frame_widget) {
        header_frame_widget = NULL;
    } else if (widget == help_frame_widget) {
        help_frame_widget = NULL;
    } else if (widget == input_frame_widget) {
        input_frame_widget = NULL;
    } else if (widget == output_frame_widget) {
        output_frame_widget = NULL;
    } else if (widget == printing_frame_widget) {
        printing_frame_widget = NULL;
    } else if (widget == username_frame_widget) {
        username_frame_widget = NULL;
    } else if (widget == notice_widget) {
        notice_widget = NULL;
    } else if (widget == file_widget) {
        file_widget = NULL;
    } else if (widget == main_frame_widget) {
        exit(0);
    }

    return(FALSE);
}

void
HeaderSelected (GtkList *list,
                GtkWidget *widget,
                gpointer user_data)
{
    hdr_selection = g_list_append(hdr_selection, widget);
    set_active(F_HDRS, "hdr_remove_button", True);
}

void
HeaderText (GtkEditable *editable,
            gpointer user_data)
{
    set_active(F_HDRS, "hdr_add_button", True);
}

void
HeaderUnselected (GtkList *list,
                  GtkWidget *widget,
                  gpointer user_data)
{
    hdr_selection = g_list_remove(hdr_selection, widget);
}


void
NoticeDismiss (GtkButton *button,
               gpointer user_data)
{
    gtk_widget_hide(F_NOTICE);
}


void
FileApply (GtkButton *button,
           gpointer user_data)
{
    gchar all[BUFFERSIZE], *previous, *newfile;

    previous = get_str_value(F_MAIN, "filename");
    newfile = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_widget));

    all[0] = '\0';
    if (previous && *previous) {
        STRCAT(all, previous);
    }
    if (newfile && *newfile) {
        if (previous && *previous) {
            STRCAT(all, " ");
        }
        STRCAT(all, newfile);
    }
    set_str_value(F_MAIN, "filename", all);
}


void
FileDismiss (GtkButton *button,
             gpointer user_data)
{
    gtk_widget_hide(F_FILE);
}
