
/*
 * $Header: /cvsroot/mpdist/mpdist/mimep/ps/iseps.c,v 1.1.1.1 2002/04/12 16:47:26 richbastard Exp $
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <string.h>
#include <X11/Xos.h>
#include <stdlib.h>
#include "../../common/option.h"

#define EPS         "EPS"
#define EPSE        'E'
#define MIMEMAXLINE 4096
#define EOS         '\0'
#define True         1
#define False        0

static char *usage = "Usage: iseps [input_file] (else stdin)\n";


static int 
iseps(char *filename)
{
    char *ERR[] = {
        "Erreur lors de l'ouverture du fichier source\n",
    };

    FILE *fp;
    char lignecour[MIMEMAXLINE], *pte;

    if (!strcmp(filename, "stdin")) {
        fp = stdin;
    } else if (!(fp = fopen(filename, "r"))) {
        FPRINTF(stderr, "%s", ERR[0]);
        exit(-1);
    }
    if (!fgets(lignecour, MIMEMAXLINE, fp)) {
        lignecour[0] = EOS;
    }
    if ((pte = index(lignecour, EPSE))) {

/* Does the file's header contains the EPS word ? */

        if (!strncmp(pte, EPS, strlen(EPS))) {
            FCLOSE(fp);
            exit(1);
        }
    }
    FCLOSE(fp);

    return(0);
}


int 
main(int argc, char *argv[])
{
    char fichier[50];

    switch (argc) {
        case 1:
            STRCPY(fichier, "stdin");
            break;
        case 2:
            STRCPY(fichier, argv[1]);
            break;
        default:
            FPRINTF(stderr, "%s", usage);
            exit(1);
    }

    return(iseps(fichier));
}
