/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JEditorPane;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.EditorKit;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.text.StyledEditorKit;
import java.awt.Component;

public class JTextPane
extends JEditorPane {
    public JTextPane() {
        this.setEditorKit(new StyledEditorKit());
    }

    public JTextPane(StyledDocument styledDocument) {
        this();
        this.setStyledDocument(styledDocument);
    }

    public String getUIClassID() {
        return "TextPaneUI";
    }

    public void setDocument(Document document) {
        if (document instanceof StyledDocument) {
            super.setDocument(document);
            return;
        }
        throw new IllegalArgumentException("Model must be StyledDocument");
    }

    public void setStyledDocument(StyledDocument styledDocument) {
        super.setDocument(styledDocument);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)this.getDocument();
    }

    public void replaceSelection(String string) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        StyledDocument styledDocument = this.getStyledDocument();
        if (styledDocument != null) {
            try {
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    styledDocument.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    styledDocument.insertString(n, string, this.getInputAttributes());
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
                return;
            }
        }
    }

    public void insertComponent(Component component) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setComponent(mutableAttributeSet, component);
        this.replaceSelection(" ");
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    public void insertIcon(Icon icon) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setIcon(mutableAttributeSet, icon);
        this.replaceSelection(" ");
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    public Style addStyle(String string, Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.addStyle(string, style);
    }

    public void removeStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.removeStyle(string);
    }

    public Style getStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getStyle(string);
    }

    public void setLogicalStyle(Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setLogicalStyle(this.getCaretPosition(), style);
    }

    public Style getLogicalStyle() {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getLogicalStyle(this.getCaretPosition());
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getCharacterElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public void setCharacterAttributes(AttributeSet attributeSet, boolean bl) {
        int n;
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            StyledDocument styledDocument = this.getStyledDocument();
            styledDocument.setCharacterAttributes(n2, n - n2, attributeSet, bl);
            return;
        }
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        if (bl) {
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
        }
        mutableAttributeSet.addAttributes(attributeSet);
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getParagraphElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public void setParagraphAttributes(AttributeSet attributeSet, boolean bl) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setParagraphAttributes(n, n2 - n, attributeSet, bl);
    }

    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    public final void setEditorKit(EditorKit editorKit) {
        if (editorKit instanceof StyledEditorKit) {
            super.setEditorKit(editorKit);
            return;
        }
        throw new IllegalArgumentException("Must be StyledEditorKit");
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }
}

