/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.border;

import com.sun.java.swing.border.AbstractBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class EtchedBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected Color highlight;
    protected Color shadow;

    public EtchedBorder() {
        this(1);
    }

    public EtchedBorder(int n) {
        this(n, null, null);
    }

    public EtchedBorder(Color color, Color color2) {
        this(1, color, color2);
    }

    public EtchedBorder(int n, Color color, Color color2) {
        this.etchType = n;
        this.highlight = color;
        this.shadow = color2;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        graphics.translate(n, n2);
        graphics.setColor(this.etchType == 1 ? this.getShadowColor(component) : this.getHighlightColor(component));
        graphics.drawRect(0, 0, n5 - 2, n6 - 2);
        graphics.setColor(this.etchType == 1 ? this.getHighlightColor(component) : this.getShadowColor(component));
        graphics.drawLine(1, n6 - 3, 1, 1);
        graphics.drawLine(1, 1, n5 - 3, 1);
        graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
        graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, 0);
        graphics.translate(-n, -n2);
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(2, 2, 2, 2);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(Component component) {
        if (this.highlight != null) {
            return this.highlight;
        }
        return component.getBackground().brighter();
    }

    public Color getShadowColor(Component component) {
        if (this.shadow != null) {
            return this.shadow;
        }
        return component.getBackground().darker();
    }
}

