/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ProgressBarUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class BasicProgressBarUI
extends ProgressBarUI
implements ChangeListener,
Serializable {
    private int cachedPercent;
    private static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 12);
    private static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 146);
    protected static int cellLength;
    protected static int cellSpacing;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicProgressBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        jComponent.setOpaque(true);
        LookAndFeel.installBorder(jComponent, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(jComponent, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        cellLength = (Integer)UIManager.get("ProgressBar.cellLength");
        cellSpacing = (Integer)UIManager.get("ProgressBar.cellSpacing");
    }

    protected void installListeners(JComponent jComponent) {
        ((JProgressBar)jComponent).addChangeListener(this);
    }

    protected void uninstallListeners(JComponent jComponent) {
        ((JProgressBar)jComponent).removeChangeListener(this);
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    public Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    public Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    public int getCachedPercent() {
        return this.cachedPercent;
    }

    public void setCachedPercent(int n) {
        this.cachedPercent = n;
    }

    public int getAmountFull(JComponent jComponent) {
        int n = 0;
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        BoundedRangeModel boundedRangeModel = jProgressBar.getModel();
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        Insets insets = jProgressBar.getInsets();
        long l = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
        if (l != 0L) {
            double d = boundedRangeModel.getValue();
            double d2 = d / (double)l;
            if (jProgressBar.getOrientation() == 0) {
                double d3 = n2 - (insets.left + insets.right);
                n = (int)(d3 * d2);
            } else {
                double d4 = n3 - (insets.top + insets.bottom);
                n = (int)(d4 * d2);
            }
        }
        return n;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        jProgressBar.getModel();
        Dimension dimension = jProgressBar.getSize();
        Insets insets = jProgressBar.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        int n = cellLength + cellSpacing;
        int n2 = this.getAmountFull(jComponent);
        graphics.setColor(jComponent.getForeground());
        if (jProgressBar.getOrientation() == 0) {
            int n3 = rectangle.x + n2 - cellLength;
            int n4 = rectangle.x;
            while (n4 <= n3) {
                graphics.fillRect(n4, rectangle.y, cellLength, rectangle.height);
                n4 += n;
            }
            return;
        }
        int n5 = rectangle.height - n2;
        int n6 = rectangle.height;
        while (n6 >= n5) {
            graphics.fillRect(rectangle.x, n6, rectangle.width, cellLength);
            n6 -= n;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        Insets insets = jProgressBar.getInsets();
        Dimension dimension = jProgressBar.getOrientation() == 0 ? new Dimension(this.getPreferredInnerHorizontal()) : new Dimension(this.getPreferredInnerVertical());
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        if (jProgressBar.getOrientation() == 0) {
            dimension.width = 0;
        } else {
            dimension.height = 0;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        if (jProgressBar.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        JProgressBar jProgressBar = (JProgressBar)changeEvent.getSource();
        BoundedRangeModel boundedRangeModel = jProgressBar.getModel();
        int n2 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
        int n3 = n2 > 0 ? 100 * boundedRangeModel.getValue() / n2 : 0;
        if (n3 != (n = this.getCachedPercent())) {
            this.setCachedPercent(n3);
            jProgressBar.repaint();
        }
    }
}

