/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import viewer.common.Parameters;
import viewer.common.PreferencePanel;
import viewer.common.Routines;
import viewer.common.TopWindow;

public class PreferenceFrame
extends JFrame
implements ActionListener {
    private PreferencePanel pptys_panel;
    private JButton update_btn;
    private JButton save_btn;
    private JButton close_btn;

    public PreferenceFrame() {
        super("Preferences");
        super.setDefaultCloseOperation(0);
        TopWindow.Preference.disposeAll();
        TopWindow.Preference.setWindow(this);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        this.pptys_panel = new PreferencePanel();
        this.pptys_panel.updateAllFieldsFromParameters();
        JScrollPane jScrollPane = new JScrollPane(this.pptys_panel);
        Dimension dimension = Routines.getScreenSize();
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        jScrollPane.setMaximumSize(new Dimension(dimension.width / 2, dimension.height * 4 / 5));
        jScrollPane.setPreferredSize(new Dimension(this.pptys_panel.getPreferredSize().width * 10 / 9, dimension.height * 3 / 5));
        container.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        this.update_btn = new JButton("update");
        this.update_btn.setToolTipText("Update all parameters based on the current preference");
        this.update_btn.addActionListener(this);
        jPanel.add(this.update_btn);
        jPanel.add(Box.createHorizontalGlue());
        this.save_btn = new JButton("save");
        this.save_btn.setToolTipText("Save preference to Jumpshot-4 setup file");
        this.save_btn.addActionListener(this);
        jPanel.add(this.save_btn);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        this.close_btn = new JButton("close");
        this.close_btn.setToolTipText("Close this window");
        this.close_btn.addActionListener(this);
        jPanel2.add(this.close_btn);
        jPanel2.add(Box.createHorizontalGlue());
        container.add(jPanel2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreferenceFrame.this.setVisible(false);
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        TopWindow.Control.setEditPreferenceButtonEnabled(!bl);
    }

    public void updateAllParametersFromFields() {
        this.pptys_panel.updateAllParametersFromFields();
    }

    public void updateAllFieldsFromParameters() {
        this.pptys_panel.updateAllFieldsFromParameters();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.update_btn) {
            this.pptys_panel.updateAllParametersFromFields();
        } else if (actionEvent.getSource() == this.save_btn) {
            this.pptys_panel.updateAllParametersFromFields();
            Parameters.writeToSetupFile(this);
        } else if (actionEvent.getSource() == this.close_btn) {
            this.setVisible(false);
        }
    }
}

