/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.CoordPixelXform;
import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import base.statistics.Summarizable;
import base.statistics.TimeAveBox;
import base.topology.SummaryArrow;
import base.topology.SummaryState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BufForTimeAveBoxes
extends TimeBoundingBox {
    private Map map_lines2nestable = new HashMap();
    private Map map_lines2nestless = new HashMap();
    private Map map_rows2nestable = null;
    private Map map_rows2nestless = null;
    private float init_state_height_ftr;
    private float next_state_height_ftr;
    private boolean drawStates = true;
    private boolean drawArrows = true;

    public BufForTimeAveBoxes(TimeBoundingBox timeBoundingBox) {
        super(timeBoundingBox);
    }

    public void mergeWithNestable(Drawable drawable) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Topology topology = drawable.getCategory().getTopology();
        arrayList.add(topology);
        Integer n = new Integer(drawable.getStartVertex().lineID);
        Integer n2 = new Integer(drawable.getFinalVertex().lineID);
        arrayList.add(n);
        arrayList.add(n2);
        TimeAveBox timeAveBox = null;
        timeAveBox = (TimeAveBox)this.map_lines2nestable.get(arrayList);
        if (timeAveBox == null) {
            timeAveBox = new TimeAveBox(this, true);
            this.map_lines2nestable.put(arrayList, timeAveBox);
        }
        if (drawable instanceof Shadow) {
            timeAveBox.mergeWithShadow((Shadow)drawable);
        } else {
            timeAveBox.mergeWithReal(drawable);
        }
    }

    public void mergeWithNestless(Drawable drawable) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Topology topology = drawable.getCategory().getTopology();
        arrayList.add(topology);
        Integer n = new Integer(drawable.getStartVertex().lineID);
        Integer n2 = new Integer(drawable.getFinalVertex().lineID);
        arrayList.add(n);
        arrayList.add(n2);
        TimeAveBox timeAveBox = null;
        timeAveBox = (TimeAveBox)this.map_lines2nestless.get(arrayList);
        if (timeAveBox == null) {
            timeAveBox = new TimeAveBox(this, false);
            this.map_lines2nestless.put(arrayList, timeAveBox);
        }
        if (drawable instanceof Shadow) {
            timeAveBox.mergeWithShadow((Shadow)drawable);
        } else {
            timeAveBox.mergeWithReal(drawable);
        }
    }

    public void setNestingExclusion() {
        Iterator iterator = this.map_lines2nestable.values().iterator();
        while (iterator.hasNext()) {
            TimeAveBox timeAveBox = (TimeAveBox)iterator.next();
            timeAveBox.setNestingExclusion();
        }
    }

    public String toString() {
        TimeAveBox timeAveBox;
        Object[] objectArray;
        Map.Entry entry;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.map_lines2nestable.size() > 0) {
            iterator = this.map_lines2nestable.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                objectArray = ((List)entry.getKey()).toArray();
                timeAveBox = (TimeAveBox)entry.getValue();
                stringBuffer.append("\n" + objectArray[0] + ": " + objectArray[1] + ", " + objectArray[2]);
                stringBuffer.append("\n" + timeAveBox);
            }
            stringBuffer.append("\n");
        }
        if (this.map_lines2nestless.size() > 0) {
            iterator = this.map_lines2nestless.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                objectArray = ((List)entry.getKey()).toArray();
                timeAveBox = (TimeAveBox)entry.getValue();
                stringBuffer.append("\n" + objectArray[0] + ": " + objectArray[1] + ", " + objectArray[2]);
                stringBuffer.append("\n" + timeAveBox);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static List getLine2RowMappedKey(Map map, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = list.toArray();
        arrayList.add(objectArray[0]);
        arrayList.add(map.get((Integer)objectArray[1]));
        arrayList.add(map.get((Integer)objectArray[2]));
        return arrayList;
    }

    public void setDrawingStates(boolean bl) {
        this.drawStates = bl;
    }

    public void setDrawingArrows(boolean bl) {
        this.drawArrows = bl;
    }

    public void initializeDrawing(Map map, Color color, boolean bl, float f, float f2) {
        TimeAveBox timeAveBox;
        List list;
        TimeAveBox timeAveBox2;
        List list2;
        Map.Entry entry;
        this.map_rows2nestable = new HashMap();
        Iterator iterator = this.map_lines2nestable.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            list2 = (List)entry.getKey();
            timeAveBox2 = (TimeAveBox)entry.getValue();
            list = BufForTimeAveBoxes.getLine2RowMappedKey(map, list2);
            timeAveBox = (TimeAveBox)this.map_rows2nestable.get(list);
            if (timeAveBox == null) {
                timeAveBox = new TimeAveBox(timeAveBox2);
                this.map_rows2nestable.put(list, timeAveBox);
                continue;
            }
            timeAveBox.mergeWithTimeAveBox(timeAveBox2);
        }
        Iterator iterator2 = this.map_rows2nestable.values().iterator();
        while (iterator2.hasNext()) {
            timeAveBox = (TimeAveBox)iterator2.next();
            timeAveBox.setNestingExclusion();
            timeAveBox.initializeCategoryTimeBoxes();
            if (bl) {
                SummaryState.setTimeBoundingBox(timeAveBox, 0.0, super.getDuration());
                continue;
            }
            SummaryState.setTimeBoundingBox(timeAveBox, super.getEarliestTime(), super.getLatestTime());
        }
        this.map_rows2nestless = new HashMap();
        iterator = this.map_lines2nestless.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            list2 = (List)entry.getKey();
            timeAveBox2 = (TimeAveBox)entry.getValue();
            list = BufForTimeAveBoxes.getLine2RowMappedKey(map, list2);
            timeAveBox = (TimeAveBox)this.map_rows2nestless.get(list);
            if (timeAveBox == null) {
                timeAveBox = new TimeAveBox(timeAveBox2);
                this.map_rows2nestless.put(list, timeAveBox);
                continue;
            }
            timeAveBox.mergeWithTimeAveBox(timeAveBox2);
        }
        iterator2 = this.map_rows2nestless.values().iterator();
        while (iterator2.hasNext()) {
            timeAveBox = (TimeAveBox)iterator2.next();
            timeAveBox.initializeCategoryTimeBoxes();
            if (bl) {
                SummaryArrow.setTimeBoundingBox(timeAveBox, 0.0, super.getDuration());
                continue;
            }
            SummaryArrow.setTimeBoundingBox(timeAveBox, super.getEarliestTime(), super.getLatestTime());
        }
        SummaryState.setBackgroundColor(color);
        this.init_state_height_ftr = f;
        this.next_state_height_ftr = f2;
    }

    public int drawAllStates(Graphics2D graphics2D, CoordPixelXform coordPixelXform) {
        if (!this.drawStates) {
            return 0;
        }
        int n = 0;
        float f = (this.init_state_height_ftr - this.next_state_height_ftr) / 2.0f;
        Iterator iterator = this.map_rows2nestable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object[] objectArray = ((List)entry.getKey()).toArray();
            TimeAveBox timeAveBox = (TimeAveBox)entry.getValue();
            int n2 = (Integer)objectArray[1];
            float f2 = (float)n2 - this.init_state_height_ftr / 2.0f;
            float f3 = f2 + this.init_state_height_ftr;
            n += SummaryState.draw(graphics2D, timeAveBox, coordPixelXform, f2, f3, f);
        }
        return n;
    }

    public int drawAllArrows(Graphics2D graphics2D, CoordPixelXform coordPixelXform) {
        if (!this.drawArrows) {
            return 0;
        }
        int n = 0;
        Iterator iterator = this.map_rows2nestless.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object[] objectArray = ((List)entry.getKey()).toArray();
            TimeAveBox timeAveBox = (TimeAveBox)entry.getValue();
            int n2 = (Integer)objectArray[1];
            int n3 = (Integer)objectArray[2];
            float f = n2;
            float f2 = n3;
            n += SummaryArrow.draw(graphics2D, timeAveBox, coordPixelXform, f, f2);
        }
        return n;
    }

    public Summarizable getSummarizableAt(CoordPixelXform coordPixelXform, Point point) {
        float f;
        float f2;
        TimeAveBox timeAveBox;
        Map.Entry entry;
        Iterator iterator;
        Topology topology = null;
        int n = -1;
        int n2 = -1;
        Object[] objectArray = null;
        Object object = null;
        if (this.drawArrows) {
            iterator = this.map_rows2nestless.entrySet().iterator();
            while (iterator.hasNext() && object == null) {
                entry = iterator.next();
                objectArray = ((List)entry.getKey()).toArray();
                timeAveBox = (TimeAveBox)entry.getValue();
                topology = (Topology)objectArray[0];
                n = (Integer)objectArray[1];
                n2 = (Integer)objectArray[2];
                f2 = n;
                f = n2;
                object = SummaryArrow.containsPixel(timeAveBox, coordPixelXform, point, f2, f);
            }
            if (object != null) {
                return new Summarizable(object, topology, n, n2);
            }
        }
        if (this.drawStates) {
            float f3 = (this.init_state_height_ftr - this.next_state_height_ftr) / 2.0f;
            iterator = this.map_rows2nestable.entrySet().iterator();
            while (iterator.hasNext() && object == null) {
                entry = iterator.next();
                objectArray = ((List)entry.getKey()).toArray();
                timeAveBox = (TimeAveBox)entry.getValue();
                topology = (Topology)objectArray[0];
                n = (Integer)objectArray[1];
                f2 = (float)n - this.init_state_height_ftr / 2.0f;
                f = f2 + this.init_state_height_ftr;
                object = SummaryState.containsPixel(timeAveBox, coordPixelXform, point, f2, f, f3);
            }
            if (object != null) {
                return new Summarizable(object, topology, n, n);
            }
        }
        return null;
    }
}

