/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __GANTT_PRINT_INFO_H__
#define __GANTT_PRINT_INFO_H__

#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <libgnome/gnome-paper.h>
#include <libgnomeprint/gnome-printer.h>
#include <libgnomeprint/gnome-print.h>

typedef struct {
	GnomePrintContext *context;
	const GnomePaper  *paper;

	/* Units? */
	gdouble            lmargin, tmargin; 
	gdouble            rmargin, bmargin;

	/* Printable area (margins excluded). */
	gdouble            width, height;
	
	gdouble            scale;
	GnomeFont         *font;
} GanttPrintInfo;

#endif /* __GANTT_PRINT_INFO_H__ */


