/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __GANTT_ROW_ITEM_H__
#define __GANTT_ROW_ITEM_H__

#include <libgnomeui/gnome-canvas.h>
#include "util/corba-utils.h"

#define TYPE_GANTT_ROW_ITEM		(gantt_row_item_get_type ())
#define GANTT_ROW_ITEM(obj)		(GTK_CHECK_CAST ((obj), TYPE_GANTT_ROW_ITEM, GanttRowItem))
#define GANTT_ROW_ITEM_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_GANTT_ROW_ITEM, GanttRowItemClass))
#define IS_GANTT_ROW_ITEM(obj)		(GTK_CHECK_TYPE ((obj), TYPE_GANTT_ROW_ITEM))
#define IS_GANTT_ROW_ITEM_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_GANTT_ROW_ITEM))

typedef struct _GanttRowItem       GanttRowItem;
typedef struct _GanttRowItemPriv   GanttRowItemPriv;

struct _GanttRowItem {
	GnomeCanvasItem  parent;
	GanttRowItemPriv *priv;
};

typedef struct {
	GnomeCanvasItemClass parent_class;
} GanttRowItemClass;

GtkType	   gantt_row_item_get_type        (void);

void       gantt_row_item_add_resource    (GanttRowItem *row,
					   gint          resource_id,
					   const gchar  *name);

void       gantt_row_item_remove_resource (GanttRowItem *row,
					   gint          resource_id);
void       gantt_row_item_update_resource (GanttRowItem *row,
					   GM_Id         resource_id,
					   const gchar  *new_name);
void       gantt_row_item_get_geometry    (GanttRowItem *item,
					   gdouble      *x1,
					   gdouble      *y1,
					   gdouble      *x2,
					   gdouble      *y2);


#endif /* __GANTT_ROW_ITEM_H__ */

