import __main__
import codeop
import keyword
import readline
import traceback

SYMBOLS_DENY = ['self']
SYMBOLS_ALLOW = ['sys', 'os', 'MrProject']

def walk_class (klass):
    list = []
    for item in dir (klass.__class__):
        if item[0] != "_":
            list.append (item)

    for base in klass.__class__.__bases__:
        list = list + walk_class (base())

    return list

class Completer:
    def __init__ (self, lokals):
	self.locals = lokals
	self.completions = []
	self.no_locals = __main__.__dict__.keys()

    def complete (self, text, state):
        if state == 0:
            if "." in text:
                self.matches = self.attr_matches (text)
            else:
                self.matches = self.global_matches (text)
        try:
            return self.matches[state]
        except IndexError:
            return None

    def update (self, locs):
	self.locals = locs
        for key in locs.keys ():
	    if not key in self.no_locals:
		if key in SYMBOLS_DENY:
		    continue
		self.completions.append (key)
	    elif key in SYMPOLS_ALLOW:
		self.completions.append (key)		
	    
    def global_matches (self, text):
        matches = []
        n = len (text)
        for word in self.completions:
            if word[:n] == text:
                matches.append (word)
        return matches

    def attr_matches (self, text):
        m = re.match (r"(\w+(\.\w+)*)\.(\w*)", text)
        if not m:
            return
        expr, attr = m.group(1, 3)

        obj = eval (expr, self.locals)
        if str (obj)[1:4] == "gtk":
            words = walk_class (obj)
        else:
            words = dir (eval (expr, self.locals))
            
        matches = []
        n = len(attr)
        for word in words:
            if word[:n] == attr:
                matches.append ("%s.%s" % (expr, word))
        return matches
    
class Interpreter:
    def __init__ (self):
	self.globs = globals ()
	self.locs = locals ()
	self.completer = Completer (self.locs)
	
	readline.parse_and_bind ('tab: complete')
	readline.set_completer (self.completer.complete)
	
    def feed (self, code):
	if (not code) or (code[-1] != '\n'):
	    code = code + '\n'
	    
	self.completer.update (self.locs)
	
	try:
	    code = codeop.compile_command (code[:-1])
	    if code:
		exec (code, self.globs, self.locs)
		self.completer.update (self.locs)
	except Exception:
	    traceback.print_exc ()

def main ():
    interpreter = Interpreter ()
    interpreter.feed ('import sys')
    interpreter.feed ('import os')
    interpreter.feed ('import MrProject')    
    interpreter.feed ('_MrProject_Shell=1')     
    try:
	while 1:
	    command = raw_input ('>>> ') + '\n'
	    prompt = interpreter.feed (command)
    except (EOFError, KeyboardInterrupt): pass
    print

main ()
