/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000-2001 CodeFactory AB
 * Copyright (C) 2000-2001 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001      Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */


#ifndef __TASK_MANAGER_H__
#define __TASK_MANAGER_H__

#include <bonobo/bonobo-xobject.h>
#include <bonobo/bonobo-event-source.h>
#include "libmrproject/GNOME_MrProject.h"
#include "task-model.h"

#define TYPE_TASK_MANAGER		(task_manager_get_type ())
#define TASK_MANAGER(obj)		(GTK_CHECK_CAST ((obj), TYPE_TASK_MANAGER, TaskManager))
#define TASK_MANAGER_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_TASK_MANAGER, TaskManagerClass))
#define IS_TASK_MANAGER(obj)		(GTK_CHECK_TYPE ((obj), TYPE_TASK_MANAGER))
#define IS_TASK_MANAGER_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_TASK_MANAGER))

typedef struct _TaskManager      TaskManager;
typedef struct _TaskManagerClass TaskManagerClass;
typedef struct _TaskManagerPriv  TaskManagerPriv;


typedef gboolean (*TaskManagerTraverseFunc) (TaskManager *manager, 
 					     TaskModel   *task_model,
 					     gpointer     data);


struct _TaskManager
{
	BonoboXObject	              parent;
	BonoboEventSource            *event_source;
	TaskManagerPriv              *priv;
};

struct _TaskManagerClass
{
	BonoboXObjectClass parent_class;
	POA_GNOME_MrProject_TaskManager__epv epv;

	/* Methods */

	TaskModel *
	(*insert_task)			(TaskManager            *manager, 
					 const GM_Task          *task, 
					 TaskModel		*parent_task_model,
					 TaskModel              *sibling_task_model,
					 GM_TaskOrderType        type,
					 CORBA_Environment      *ev);

	void 
	(*update_task)                  (TaskManager            *manager, 
					 const GM_Id             taskId,
					 const GM_Task          *task,
					 CORBA_Environment      *ev);

	void 
	(*remove_tasks)                 (TaskManager            *manager, 
					 GSList                 *id_list,
					 CORBA_Environment      *ev);
	
        void 
	(*reposition_task)              (TaskManager            *manager, 
					 TaskModel              *task_model,
					 TaskModel              *sibling_task_model,
					 GM_TaskOrderType        type,
					 CORBA_Environment      *ev);

        void 
	(*reparent_task)                (TaskManager            *manager, 
					 TaskModel              *task_model,
					 TaskModel              *parent_task_model,
					 CORBA_Environment      *ev);
	
	GNOME_MrProject_Task *
	(*get_task)			(TaskManager            *manager, 
					 const GM_Id             id,
					 CORBA_Environment      *ev);
	
	GSList *
	(*get_all_tasks)		(TaskManager            *manager, 
					 CORBA_Environment      *ev);

	GNOME_MrProject_Id 
	(*link_tasks)			(TaskManager            *manager,
					 GM_Dependency          *dependency,
					 CORBA_Environment      *ev);

	void 
	(*unlink_tasks)                 (TaskManager            *manager,
					 const GM_Id             dependencyId,
					CORBA_Environment              *ev);

	void 
	(*remove_dependency)            (TaskManager            *manager,
					 GM_Id                   dependencyId,
					 CORBA_Environment      *ev);
	
	GNOME_MrProject_Dependency *
	(*get_dependency)               (TaskManager            *manager,
					 GM_Id                   dependencyId,
					 CORBA_Environment      *ev);
	
	gchar *
	(*get_note)                     (TaskManager            *manager,
					 const GM_Id             taskId,
					 CORBA_Environment      *ev);
	
	void
	(*set_note)                     (TaskManager            *manager,
					 const GM_Id             taskId,
					 const gchar            *note,
					 CORBA_Environment      *ev);
	void 
	(*dump_tree)			(TaskManager            *manager, 
					 CORBA_Environment      *ev);

	/* --- */

	void
	(*traverse)                     (TaskManager            *manager, 
					 TaskModel              *task_model,
					 GTraverseType		 type,
					 TaskManagerTraverseFunc func, 
					 gpointer                data);

	TaskModel *
	(*get_parent_task_model)        (TaskManager            *manager,
					 TaskModel              *task_model);

	TaskModel *
	(*get_task_model)               (TaskManager            *manager,
					 const GM_Id             taskId);

	GSList *
	(*get_children)                 (TaskManager            *manager,
					 TaskModel              *task_model);

	TaskModel *
	(*get_first_sibling)            (TaskManager            *manager,
					 TaskModel              *task_model);
	
	TaskModel *
	(*get_next_sibling)             (TaskManager            *manager,
					 TaskModel              *task_model);

	gint
	(*get_task_depth)               (TaskManager            *manager,
					 TaskModel              *task_model);

	void
	(*remove_task_model)            (TaskManager            *manager,
					 TaskModel              *task_model);
	
};


GtkType      task_manager_get_type      (void);
void         task_manager_construct     (TaskManager            *manager,
					 TaskModel              *root_task_model,
					 BonoboEventSource      *event_source);
TaskModel   *task_manager_get_task_model (TaskManager           *manager, 
					  GM_Id                  id);
TaskModel *task_manager_get_parent_task_model (TaskManager      *manager, 
					       TaskModel        *task);
void         task_manager_traverse      (TaskManager            *manager, 
					 TaskModel              *task_model,
					 GTraverseType		 type,
					 TaskManagerTraverseFunc func, 
					 gpointer                data);
GM_Id    task_manager_dependency_tasks (TaskManager             *manager,
					const GM_Id              dependencyId,
					const GM_Id              taskId,
					const GM_Id              predecessorId,
					const GM_DependencyType  type,
					CORBA_Environment       *ev);
GM_Task *task_manager_create_root_task (TaskManager             *manager);

TaskModel *task_manager_get_first_sibling (TaskManager          *manager, 
					   TaskModel            *task_model);
TaskModel *task_manager_get_next_sibling (TaskManager           *manager, 
					  TaskModel             *task_model);
TaskModel *task_manager_get_root_task_model (TaskManager        *manager);


#endif /* __TASK_MANAGER_H__ */

