/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000-2001 CodeFactory AB
 * Copyright (C) 2000-2001 Mikael Hallendal <micke@codefactory.se>
 * Copyright (C) 2000-2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 *         Richard Hult <rhult@codefactory.se>
 */

#include "marshallers.h"

void
mrproject_marshal_NONE__INT_INT_INT (GtkObject       *object,
				     GtkSignalFunc    func,
				     gpointer         func_data,
				     GtkArg          *args)
{
	(* (void (*)(GtkObject *, int, int, int, gpointer)) func)
		(object,
		 GTK_VALUE_INT (args[0]),
		 GTK_VALUE_INT (args[1]),
		 GTK_VALUE_INT (args[2]),
		 func_data);
}

void
mrproject_marshal_NONE__POINTER_INT_INT_INT (GtkObject       *object,
					     GtkSignalFunc    func,
					     gpointer         func_data,
					     GtkArg          *args)
{
        (* (void (*)(GtkObject *, gpointer, int, int, int, gpointer)) func)
                (object,
		 GTK_VALUE_POINTER (args[0]),
                 GTK_VALUE_INT (args[1]),
                 GTK_VALUE_INT (args[2]),
                 
                 GTK_VALUE_INT (args[3]),
                 func_data);
}

void
mrproject_marshal_NONE__OBJECT_INT_OBJECT (GtkObject       *object,
					   GtkSignalFunc    func,
					   gpointer         func_data,
					   GtkArg          *args)
{
	(* (void (*)(GtkObject *, gpointer, int, gpointer, gpointer)) func)
		(object,
		 GTK_VALUE_OBJECT (args[0]),
		 GTK_VALUE_INT (args[1]),
		 GTK_VALUE_OBJECT (args[2]),
		 func_data);
}

void
mrproject_marshal_NONE__DOUBLE_DOUBLE_DOUBLE_DOUBLE (GtkObject       *object,
						     GtkSignalFunc    func,
						     gpointer         func_data,
						     GtkArg          *args)
{
        (* (void (*)(GtkObject *, double, double, double, double, gpointer)) func)
                (object,
                 GTK_VALUE_DOUBLE (args[0]),
                 GTK_VALUE_DOUBLE (args[1]),
                 GTK_VALUE_DOUBLE (args[2]),
                 GTK_VALUE_DOUBLE (args[3]),
                 func_data);
}

void
mrproject_marshal_NONE__POINTER_POINTER_DOUBLE_DOUBLE_INT_INT_INT_INT (GtkObject       *object,
								       GtkSignalFunc    func,
								       gpointer         func_data,
								       GtkArg          *args)
{
        (* (void (*)(GtkObject *, gpointer, gpointer, double, double, int, int, int, int, gpointer)) func)
                (object,
                 GTK_VALUE_POINTER (args[0]),
                 GTK_VALUE_POINTER (args[1]),
                 GTK_VALUE_DOUBLE (args[2]),
                 GTK_VALUE_DOUBLE (args[3]),
                 GTK_VALUE_INT (args[4]),
                 GTK_VALUE_INT (args[5]),
                 GTK_VALUE_INT (args[6]),
                 GTK_VALUE_INT (args[7]),
                 func_data);
}

typedef double (*GtkSignal_DOUBLE__POINTER) (GtkObject *object,
					     gpointer,
					     gpointer user_data);
void
mrproject_marshal_DOUBLE__POINTER (GtkObject    *object, 
				   GtkSignalFunc func, 
				   gpointer      func_data, 
				   GtkArg       *args)
{
	GtkSignal_DOUBLE__POINTER rfunc;
	double *return_val;
	
	rfunc = (GtkSignal_DOUBLE__POINTER) func;
	return_val = GTK_RETLOC_DOUBLE (args[1]);
	
	*return_val =  (* rfunc) (object,
				  GTK_VALUE_POINTER (args[0]),
				  func_data);
}

typedef double (*GtkSignal_DOUBLE__POINTER_INT_INT) (GtkObject *,
						     gpointer, gint, gint,
						     gpointer user_data);
void
mrproject_marshal_DOUBLE__POINTER_INT_INT (GtkObject *object,
					   GtkSignalFunc func,
					   gpointer func_data,
					   GtkArg *args)
{
	GtkSignal_DOUBLE__POINTER_INT_INT rfunc;
	double *return_val;
	
	rfunc = (GtkSignal_DOUBLE__POINTER_INT_INT) func;
	return_val = GTK_RETLOC_DOUBLE (args[3]);
	
	*return_val = (*rfunc) (object,
				GTK_VALUE_POINTER (args[0]),
				GTK_VALUE_INT (args[1]),
				GTK_VALUE_INT (args[2]), 
				func_data);
}

