/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "ftpd.h"
#include "reply.h"

int ftp_stat(FTPSTATE *peer, char *param)
{
	char replystr[5];
	
	if (config->altlongreplies)
		strcpy(replystr, "211-");
	else
		strcpy(replystr, "    ");
	
	if (param == NULL) 
	{
		char *curdir = dir_getvirtual(peer, peer->pwd);
		
		ftp_write(peer, TRUE, 0, REPLY_STAT1(peer));
		ftp_write(peer, TRUE, 0, REPLY_STAT2(peer));
		ftp_write(peer, TRUE, 0, REPLY_STAT3(curdir));	/* this does current dir */
		ftp_write(peer, TRUE, 0, REPLY_STAT4(peer));
		ftp_write(peer, TRUE, 0, REPLY_STAT5(peer));
		ftp_write(peer, TRUE, 0, REPLY_STAT6(peer));
		ftp_write(peer, TRUE, 0, REPLY_STAT7(peer));
		ftp_write(peer, TRUE, 0, REPLY_STAT8(peer));
		if (peer->ratioinfo)
			ratio_stat(peer, peer->ratioinfo, replystr);
		if (peer->dport)
		{
			ftp_write(peer, TRUE, 0, REPLY_STAT9);
			if (peer->dport->trans_type != TRANS_RUNNING)
				ftp_write(peer, TRUE, 0, REPLY_STAT10);
			else if (peer->dport->tsize == -1)
				ftp_write(peer, TRUE, 0, REPLY_STAT11(peer));
			else
				ftp_write(peer, TRUE, 0, REPLY_STAT12(peer));
		}
	}
	else 
	{
		/* do a listing */
		char *line;
		char *rdir;
		char *cmd = getkeyword(&param);
		char *pattern = (char *)listmakepattern(peer, cmd, &rdir, 0);
		LISTHANDLE *lh = getlisthandle(peer, pattern, FALSE, rdir, 0); 
		LIMITER *lim = NULL;
		
		if (peer->maxtranspd_down)
			lim = limiter_new(peer->maxtranspd_down);
		else if (peer->maxtranspd)
			lim = limiter_new(peer->maxtranspd);
			
		ftp_write(peer, TRUE, 0, REPLY_STATLIST(cmd));
			 
		while ((line = getlisthandleline(peer, lh)) != NULL)
		{
			int sline = strlen(line);
			line[sline - 2] = 0;
			if (config->altlongreplies)
			{
				ftp_write(peer, TRUE, 0, "211-%s", line);
				if (lim)
					limiter_add(lim, sline + 4, FALSE);
			}
			else
			{
				ftp_write(peer, TRUE, 0, "%s", line);
				if (lim)
					limiter_add(lim, sline, FALSE);
			}
			freewrapper(line);
		}
		
		if (lim)
			limiter_add(lim, 0, TRUE);

		freeifnotnull(lim);
		freewrapper(pattern);
		freewrapper(cmd);		
		freelisthandle(lh); 
	}
	ftp_write(peer, FALSE, 211, REPLY_STATEND);
	return(FALSE);
}
