/* Support for Non-ASCII Path Name
   Copyright (C) 1985, 1986 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This part cannot be surround with #ifdef emacs, because it is needed */
/* during generate xmakefile. */
#ifndef MCPATH
# define MCPATH
#endif /* !MCPATH */

/* not to confuse while compiling etc/*.c */
#ifdef emacs
#ifdef MCPATH
#  ifndef _MCPATH_H			/* enable to include twice */

#if 1

/* !!! This page is copied from dired.c except that DIRENTRY is
   changed to SYSTEM_DIRENTRY.  Don't modify this page. */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef VMS
#include <string.h>
#include <rms.h>
#include <rmsdef.h>
#endif

/* The d_nameln member of a struct dirent includes the '\0' character
   on some systems, but not on others.  What's worse, you can't tell
   at compile-time which one it will be, since it really depends on
   the sort of system providing the filesystem you're reading from,
   not the system you are running on.  Paul Eggert
   <eggert@bi.twinsun.com> says this occurs when Emacs is running on a
   SunOS 4.1.2 host, reading a directory that is remote-mounted from a
   Solaris 2.1 host and is in a native Solaris 2.1 filesystem.

   Since applying strlen to the name always works, we'll just do that.  */
#define NAMLEN(p) strlen (p->d_name)

#ifdef SYSV_SYSTEM_DIR

#include <dirent.h>
#define SYSTEM_DIRENTRY struct dirent

#else /* not SYSV_SYSTEM_DIR */

#ifdef NONSYSTEM_DIR_LIBRARY
#include "ndir.h"
#else /* not NONSYSTEM_DIR_LIBRARY */
#ifdef MSDOS
#include <dirent.h>
#else
#include <sys/dir.h>
#endif
#endif /* not NONSYSTEM_DIR_LIBRARY */

#ifndef MSDOS
#define SYSTEM_DIRENTRY struct direct

extern DIR *opendir ();
extern struct direct *readdir ();

#endif /* not MSDOS */
#endif /* not SYSV_SYSTEM_DIR */
#endif

				/* maximum buffer size to do conversion. */
#define MCPATH_BUFSIZ(s) (((s) * 3) + 256)
#define MC_MAXPATHLEN MCPATH_BUFSIZ (MAXPATHLEN)

#define DIRENTRY struct mcpath_direntry
struct mcpath_direntry
{
				/* emacs 19.28 uses d_ino and d_name. */
#ifndef MSDOS
  int d_ino;
#endif /* not MSDOS */
  unsigned char d_name [MCPATH_BUFSIZ (MAXNAMLEN) + 1];
};

extern DIR *mc_opendir ();
extern DIRENTRY *mc_readdir ();


#    ifdef MCPATH_SOURCE
#    else /* not MCPATH_SOURCE (not to define in mcpath.c) */
#      undef creat
#      undef open
#      undef access
#      undef chmod
#      undef lstat
#      undef readlink
#      undef unlink
#      undef link
#      undef symlink
#      undef chdir
#      undef opendir
#      undef readdir
#      define creat mc_creat
#      define open mc_open
#      define access mc_access
#      define chmod mc_chmod
#      define lstat mc_lstat
#      define readlink mc_readlink
#      ifndef MC_STAT_DEFINED		/* may be defined in fake sys/stat.h */
#	 ifdef nec_ews_svr4		/* hir, 1993.10.22 */
#	   define _xstat mc_xstat
#	 else
#	   define stat mc_stat
#	 endif
#      endif /* MC_STAT_DEFINED */
#      define unlink mc_unlink
#      ifdef HAVE_RENAME
#	 define rename mc_rename
#      endif
#      define link mc_link
#      define symlink mc_symlink
#      define chdir mc_chdir
#      ifdef MSDOS
#	 ifndef HAVE_GETWD
#	   define getcwd mc_getcwd
#	 else /* HAVE_GETWD */
#	   define getwd mc_getwd
#	 endif /* HAVE_GETWD */
#      endif /* MSDOS */
#      ifndef NO_MC_EXECVP
#	 define execvp mc_execvp
#      endif /* !NO_MC_EXECVP */
#      define opendir mc_opendir
#      define readdir mc_readdir
#      ifdef HAVE_MKDIR					/* hir, 1994.8.12 */
#	 define mkdir mc_mkdir
#      endif
#      ifdef HAVE_RMDIR					/* hir, 1994.8.12 */
#	 define rmdir mc_rmdir
#      endif
#    endif /* not MCPATH_SOURCE */
#  endif /* _MCPATH_H */
#endif /* MCPATH */
#endif /* emacs */
