//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: pcanvas.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __PCANVAS_H__
#define __PCANVAS_H__

#include "song.h"
#include "canvas.h"

#define TH        20
#define beats     4

//---------------------------------------------------------
//   NPart
//    ''visual'' Part
//    wraps Parts with additional information needed
//    for displaying
//---------------------------------------------------------

class NPart : public CItem {
   public:
      NPart(Part* e, int index);
      const QString name() const     { return part()->name(); }
      void setName(const QString& s) { part()->setName(s); }
      Track* track() const           { return part()->track(); }
      };

class QLineEdit;
class MidiEditor;
class QPopupMenu;

//---------------------------------------------------------
//   PartCanvas
//---------------------------------------------------------

class PartCanvas : public Canvas {
      int* _raster;
      TrackList* tracks;

      Part* resizePart;
      QLineEdit* lineEditor;
      NPart* editPart;
      int curColorIndex;

      int _showPartType;       // 1 - names, 2 events
      int _showPartEvent;      //
      bool showGrid;

      Q_OBJECT
      virtual void keyPress(QKeyEvent*);
      virtual void mousePress(QMouseEvent*);
      virtual void mouseMove(const QPoint&);
      virtual void mouseRelease(const QPoint&);
      virtual void viewMouseDoubleClickEvent(QMouseEvent*);
      virtual void leaveEvent(QEvent*e);
      virtual void drawItem(QPainter&, const CItem*, const QRect&) const;
      virtual void updateSelection();
      virtual QPoint raster(const QPoint&) const;
      virtual int y2pitch(int y) const { return y/TH; } //CDW
      virtual int pitch2y(int p) const { return p*TH; } //CDW
      virtual bool moveItem(CItem*, const QPoint&, bool);
      virtual CItem* newItem(const QPoint&, int);
      virtual void resizeItem(CItem*,bool);
      virtual void newItem(CItem*,bool);
      virtual bool deleteItem(CItem*);
      virtual void startUndo(bool);
      virtual void endUndo(bool);

      virtual void startDrag(CItem*, bool);
      virtual void dragEnterEvent(QDragEnterEvent*);
      virtual void dragMoveEvent(QDragMoveEvent*);
      virtual void dragLeaveEvent(QDragLeaveEvent*);
      virtual void viewDropEvent(QDropEvent*);

      virtual QPopupMenu* genItemPopup(CItem*);
      virtual void itemPopup(CItem*, int, const QPoint&);

      void glueItem(CItem* item);
      void splitItem(CItem* item, const QPoint&);

      void copy(PartList*);
      void paste();
      int pasteAt(const QString&, Track*, int);
      void drawWavePart(QPainter&, const QRect&, WavePart*, const QRect&) const;

   protected:
      virtual void drawCanvas(QPainter&, const QRect&);

   signals:
      void timeChanged(int);
      void tracklistChanged();
      void dclickPart(Track*);
      void selectionChanged();
      void dropFile(const QString&);

      void startEditor(PartList*, int);

   private slots:
      void returnPressed();

   public slots:
      void setCurColorIndex(int);

   public:
      enum { CMD_CUT_PART, CMD_COPY_PART, CMD_PASTE_PART };

      PartCanvas(int* raster, QWidget* parent, int, int);
      void partsChanged();
      int showPartType() const { return _showPartType; }
      void setShowPartType(int val);
      int showPartEvent() const;
      void setShowPartEvent(int val);
      void cmd(int);
      void setGrid(bool);
      bool hasGrid() const { return showGrid; }

      };
#endif
