//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: ncanvas.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//  (C) Copyright 1999,2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __NCANVAS_H__
#define __NCANVAS_H__

#include <stdio.h>

#include <qwidget.h>
#include <qrect.h>
#include <qfont.h>

#include "score.h"
#include "view.h"
#include "symbols.h"
#include "items.h"

#define beats     4

class ScrollScale;
class SystemLayout;
class QString;
class StaveRow;
class QTimer;
class QAction;

class QuantDialog;

//---------------------------------------------------------
//   ScoreCanvas
//---------------------------------------------------------

class ScoreCanvas : public View {
      enum DragMode { DRAG_OFF, DRAG_NEW, DRAG_NEW_START, DRAG_MOVE_START, DRAG_MOVE,
            DRAG_DELETE, DRAG_COPY_START, DRAG_COPY,
            DRAG_RESIZE, DRAG_LASSO_START, DRAG_LASSO
            };

      DragMode drag;
      QPoint start;
      ScoreItem* curItem;
      QRect lasso;
      int page;

      MidiEditor* editor;

      std::list<int> tracks;
      SystemLayout* system;
      ScoreList select;
      ScoreList moving;

      int curVelo;

      int rq;           // rest quantization
      int nq;           // note quantization

      Tool tool;
      int paletteItem;
      int pos[3];

      int oldTick;
      int oldPitch;

      QuantDialog* quantConfig;
      NoteItem* lyricsNote;     // current note & sr
      LyricsItem* ly;
      QTimer* timer;

      StaveRow* lyricsSr;       // during lyrics entry

      virtual void viewMousePressEvent(QMouseEvent* event);
      virtual void viewMouseMoveEvent(QMouseEvent*);
      virtual void viewMouseReleaseEvent(QMouseEvent* ev);
      virtual void draw(QPainter&, const QRect&);
      virtual void leaveEvent(QEvent*e);
      virtual void viewKeyPressEvent(QKeyEvent* event);

      Q_OBJECT
      void layout();
      int tick2xy(int tick, MidiEvent*, int& x, int& y, int& prefix);
      int tick2x(int tick);
      void drawNote(QPainter&, ScoreItem* n);
      void drawPause(QPainter& p, ScoreItem* n);
      void deselectAll();
      void deselectItem(ScoreItem* item);
      int curNoteLen() const;
      void updateSelection();

      // moving
      void startMoving(const QPoint&, bool copyflag);
      void moveItems(const QPoint&);
      void endMoveItems(const QPoint&, bool copyflag);

      void selectAll(bool shift, QRect r);
      bool showQuantDialog(int* tick, int* nq, int* rq);
      void rbClicked();
      void enterLyrics(const QPoint&, int tick, StaveRow*);
      void enterText(int tick, StaveRow*);
      void enterChord(int tick, StaveRow*);
      NoteItem* nextNote(NoteItem* ni) const;
      NoteItem* prevNote(NoteItem* ni) const;
      void endEnterLyrics();
      void enterLyrics(NoteItem* note, StaveRow*);

   private slots:
      void setPos(int, int, bool);
      void blink();

   signals:
      void selectionChanged(int, MidiEvent*, MidiPart*);
      void timeChanged(int);
      void pitchChanged(int);

   public slots:
      void setTool(int t);
      void songChanged(int);
      void setEnh(QAction*);
      void print();
      void preview();
      void setPage(int);
      void voiceUp();
      void voiceDown();
      void flipStems();

   public:
      ScoreCanvas(MidiEditor*, QWidget*, int, int);
      ~ScoreCanvas();
      QString getCaption() const;
      void setPaletteItem(int item);
      int pages() const;
      SystemLayout* getSystem() const { return system; }
      void selectItem(ScoreItem* item);
      };
#endif

