//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: wave.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIO_H__
#define __AUDIO_H__

#include <qstring.h>
#include <list>
#include <qfileinfo.h>

class Xml;
class SndFile;

//---------------------------------------------------------
//   Clip
//---------------------------------------------------------

class Clip {
      QString _name;
      SndFile* f;
      int _spos;                    // start sample position in WaveFile
      int len;                      // len of clip
      int refs;

   public:
      Clip();
      Clip(SndFile* f, int start, int len);
      ~Clip();
      const QString& name() const      { return _name;  }
      void setName(const QString& s)   { _name = s;     }
      void incRef();
      int decRef();
      int spos() const                 { return _spos;  }
      void setSpos(int s)              { _spos = s;     }
      SndFile* file() const            { return f;      }

      void read(unsigned, float**, int, unsigned, int*, const double);
      void read(Xml&);
      void write(int, Xml&) const;
      int samples() const              { return len; }
      void setSamples(int s)           { len = s;    }
      int  references()                { return refs; }
      };

class ClipList : public std::list<Clip*> {
   public:
      int idx(Clip*) const;
      Clip* search(const QString&) const;
      void write(int, Xml&) const;
      void add(Clip* clip) { push_back(clip); }
      void remove(Clip*);
      };

typedef ClipList::iterator iClip;
typedef ClipList::const_iterator ciClip;


#endif

