//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: doublelabel.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __DOUBLELABEL_H__
#define __DOUBLELABEL_H__

#include "dentry.h"

//---------------------------------------------------------
//   DoubleLAbel
//---------------------------------------------------------

class DoubleLabel : public Dentry {
      double min, max;
      QString _specialText;   // text to show if value outside min,max
      int _precision;
      Q_OBJECT

      virtual bool setSValue(const QString&);
      virtual bool setString(double val);
      virtual void incValue(double);
      virtual void decValue(double);

   signals:
      void valueChanged(double);

   public:
      DoubleLabel(double val, double min, double max, QWidget*);
      int precision() const { return _precision; }
      void setPrecision(int val);
      QString specialText() const { return _specialText; }
      void setSpecialText(const QString& s) { _specialText = s; }
      };

#endif
