//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: arranger.h,v 1.1.1.1 2003/10/29 10:06:19 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ARRANGER_H__
#define __ARRANGER_H__

#include <qwidget.h>
#include <qheader.h>
#include <qwhatsthis.h>

#include "midieditor.h"
#include "pcanvas.h"

class QMainWindow;
class QToolButton;
class Header;
class TList;
class ScrollScale;
class QScrollBar;
class MTScale;
class Track;
class Xml;
class Splitter;
class LabelCombo;
class PosLabel;
class QCheckBox;
class QSpinBox;
class MidiTrackInfoBase;
class WaveTrackInfoBase;

class TWhatsThis : public QWhatsThis {
      Header* header;
   protected:
      QString text(const QPoint&);
   public:
      TWhatsThis(QWidget* parent, Header* h) : QWhatsThis(parent) {
            header = h;
            }
      };

//---------------------------------------------------------
//   Arranger
//---------------------------------------------------------

class Arranger : public QWidget {
      int _quant, _raster;
      PartCanvas* canvas;
      ScrollScale* hscroll;
      QScrollBar* vscroll;
      TList* list;
      Header* header;
      MTScale* time;
      QSpinBox* lenEntry;
      bool showTrackinfo;

      MidiTrackInfoBase* midiTrackInfo;
      WaveTrackInfoBase* waveTrackInfo;
      QWidget* noTrackInfo;

      QCheckBox* midiThru;

      Track* selected;

      LabelCombo* typeBox;
      QToolButton* ib;
      int trackInfoType;
      Splitter* split;
      QPopupMenu* pop;
      int songType;
      QString _bgPixmap;
      PosLabel* cursorPos;
      QSpinBox* globalTempoSpinBox;

      int trackInfoSize;

      Q_OBJECT
      void genTrackInfo(QWidget* parent);
      void genMidiTrackInfo();
      void genWaveTrackInfo();
      void updateMidiTrackInfo();
      void updateWaveTrackInfo();
      void updateNoTrackInfo();

   private slots:
      void setOutputRoute(const QString& r);

      void _setRaster(int);
      void songlenChanged(int);
      void showInspector(bool);
      void trackSelectionChanged();

      void iNameChanged();
      void iwNameChanged();
      void nameChanged(const QString&);
      void iHBankChanged(int);
      void iLBankChanged(int);
      void iInputChannelChanged(const QString&);
      void iOutputChannelChanged(int);
      void iInputPortChanged(const QString&);
      void iOutputPortChanged(int);
      void iProgramChanged(int);
      void iLautstChanged(int);
      void iTranspChanged(int);
      void iAnschlChanged(int);
      void iVerzChanged(int);
      void iLenChanged(int);
      void iKomprChanged(int);
      void iPanChanged(int);
      void updateInspector();
      void songChanged(int);
      void modeChange(int);
      void instrPopup();
      void iChannelsChanged(int);
      void setTime(int);
      void midiThruChanged(bool);
      void headerMoved();
      void globalPitchChanged(int);
      void globalTempoChanged(int);
      void setTempo50();
      void setTempo100();
      void setTempo200();

   signals:
      void editPart(Track*);
      void selectionChanged();
      void dropFile(const QString&);
      void startEditor(PartList*, int);
      void toolChanged(int);

   public slots:
      void dclickPart(Track*);
      void setTool(int);
      void setActivityMode(int);
      void setActivityColor(QColor);

   public:
      enum { CMD_CUT_PART, CMD_COPY_PART, CMD_PASTE_PART };

      Arranger(QMainWindow* parent, const char* name = 0);
      void setBgPixmap(const QString&);
      const QString& bgPixmap() const { return _bgPixmap; }
      void setMode(int);
      void reset();
      int showPartType() const;
      int showPartEvent() const;
      void setShowPartType(int val);
      void setShowPartEvent(int val);

      void writeStatus(int level, Xml&);
      void readStatus(Xml&);

      Track* curTrack() const { return selected; }
      void cmd(int);
      bool isSingleSelection() { return canvas->isSingleSelection(); }
      int getActivityMode() const;
      QColor getActivityColor() const;
//      QColor getSelectedTrackColor() const;
      void setGrid(bool);
      bool hasGrid();
      void setGlobalTempo(int);
      };

#endif

