//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: tlist.h,v 1.1.1.1 2003/10/29 10:06:19 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __TLIST_H__
#define __TLIST_H__

#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qheader.h>

class QPainter;
class ScrollScale;
class QScrollBar;
class QLineEdit;
class Track;
class Xml;
class Header;

enum TrackColumn {
      COL_RECORD = 0,
      COL_ACTIVITY,
      COL_MUTE,
      COL_SOLO,
      COL_CLASS,
      COL_NAME,
      COL_OPORT,
      COL_OCHANNEL,
      COL_TIMELOCK,
      COL_NONE = -1
      };

//----------------------------------------------------------
//   THeaderTip
//----------------------------------------------------------

class THeaderTip : public QToolTip {
   public:
      THeaderTip(QWidget * parent) : QToolTip(parent) {}
   protected:
      void maybeTip(const QPoint &);
      };

//---------------------------------------------------------
//   TList
//---------------------------------------------------------

class TList : public QWidget {
      Q_OBJECT

      int ypos;

      QPixmap pm;             // for double buffering
      bool pmValid;
      QPixmap bgPixmap;       // background Pixmap
      QBrush brush;

      bool resizeFlag;        // true if resize cursor is shown

      Header* header;
      QScrollBar* scroll;
      QLineEdit* editor;
      Track* editTrack;

      int startY;
      int curY;
      int sTrack;
      int dragHeight;
      int dragYoff;

      int activityMode;
      QColor activityColor;

      enum { NORMAL, START_DRAG, DRAG, RESIZE} mode;

      virtual void paintEvent(QPaintEvent*);
      virtual void mousePressEvent(QMouseEvent* event);
      virtual void mouseDoubleClickEvent(QMouseEvent*);
      virtual void mouseMoveEvent(QMouseEvent*);
      virtual void mouseReleaseEvent(QMouseEvent*);
      virtual void keyPressEvent(QKeyEvent* e);

      void portsPopupMenu(Track*, int, int);
      void classesPopupMenu(int, int, int);
      void oportPropertyPopupMenu(Track*, int x, int y);
      void moveSelection(int n);
      void adjustScrollbar();
      void paint(const QRect& r);
      virtual void resizeEvent(QResizeEvent*);
      void redraw(const QRect& r);
      Track* y2Track(int y) const;

   private slots:
      void returnPressed();
      void updateActivity();
      void songChanged(int flags);

   signals:
      void selectionChanged();

   public slots:
      void tracklistChanged();
      void setActivityMode(int);
      void setActivityColor(QColor);
      void setYPos(int);
      void redraw();

   public:
      TList(Header*, QWidget* parent, const char* name);
      void setScroll(QScrollBar* s) { scroll = s; }
      Track* track() const { return editTrack; }
      void writeStatus(int level, Xml&, const char* name) const;
      void readStatus(Xml&, const char* name);
      int getActivityMode() const { return activityMode; }
      QColor getActivityColor() const { return activityColor; }
      };

#endif

