//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: value.cpp,v 1.1.1.1 2003/10/29 10:05:11 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "value.h"
#include "xml.h"


IValue::IValue(QObject* parent, const char* name)
   : QObject(parent, name)
      {
      }
BValue::BValue(QObject* parent, const char* name)
   : QObject(parent, name)
      {
      }

//---------------------------------------------------------
//   save
//---------------------------------------------------------

void BValue::save(int level, Xml& xml)
      {
      xml.intTag(level, name(), val);
      }

//---------------------------------------------------------
//   save
//---------------------------------------------------------

void IValue::save(int level, Xml& xml)
      {
      xml.intTag(level, name(), val);
      }

void BValue::setValue(bool v)
      {
      if (val != v) {
            val = v;
            emit valueChanged(val);
            emit valueChanged(int(val));
            }
      }

void IValue::setValue(int v)
      {
      if (val != v) {
            val = v;
            emit valueChanged(val);
            }
      }

