/***************************************************************************
                          event.cpp  -  description
                             -------------------
    begin                : Sun Jan 6 2002
    copyright            : (C) 2002 by 
    email                : 
 ***************************************************************************/

#include "config.h"
#include "mutella.h"
#include "event.h"

// general event class -- abstract
MEvent::MEvent(int type, int severity, DWORD ID /*=0*/) : m_nType(type), m_nSeverity(severity), m_dwID(ID)
{
	m_nTime = xtime();
}

MEvent::~MEvent()
{
}

// simple string event
MStringEvent::MStringEvent(int type, int severity, const CString& value, DWORD ID = 0) :
	TSimpleEvent<CString>(type,severity,value, ID)
{
}

int MStringEvent::GetMemUsage()
{
	return sizeof(MStringEvent)+m_value.buffersize();
}

CString MStringEvent::Format()
{
	return m_value;
}

// event queue
MEventQueue::MEventQueue()
{
}

MEventQueue::~MEventQueue()
{
}

MEventQueue MEventQueue::ms_EventQueue;
MEventQueue& EQ()
{
	return MEventQueue::ms_EventQueue;
}

void MEventQueue::PostEvent(MEvent* pEvent)
{
	m_mutex.lock();
	for (std::list<MEventReceiver*>::iterator it = m_receivers.begin(); it != m_receivers.end(); ++it)
		if ((*it)->IsOfInterest(pEvent))
			(*it)->OnEvent(pEvent);
	m_mutex.unlock();
	// this will free the memory
	pEvent->Release();
}

/*bool MEventQueue::SendEvent(MEvent* pEvent)
{
}*/
	
void MEventQueue::AddReceiver(MEventReceiver* pReceiver)
{
	// possible deadlock if called from OnEvent();
	m_mutex.lock();
	m_receivers.push_back(pReceiver);
	m_mutex.unlock();
}

void MEventQueue::RemoveReceiver(MEventReceiver* pReceiver)
{
	// possible deadlock if called from OnEvent();
	m_mutex.lock();
	m_receivers.remove(pReceiver);
	m_mutex.unlock();
}

// event receivers
MEventReceiver::~MEventReceiver()
{
	EQ().RemoveReceiver(this);
}

MAsyncEventReceiver::MAsyncEventReceiver(int nMaxTime, int nMaxMem /*=INT_MAX*/) : m_nMaxTime(nMaxTime), m_nMaxMem(nMaxMem)
{
	m_nMemUsed = 0;
	m_nMissedEvents = 0;
}

MAsyncEventReceiver::~MAsyncEventReceiver()
{
}

void MAsyncEventReceiver::OnEvent(MEvent* pEvent)
{
	m_mutex.lock();
	m_queue.push_back(pEvent);
	m_nMemUsed += pEvent->GetMemUsage();
	int nTime = xtime()-m_nMaxTime;
	// apply limits
	while(m_queue.size()>1 &&
		  ( m_nMemUsed>m_nMaxMem ||
		    m_queue.front()->GetTime()<nTime ))
	{
		m_nMemUsed -= m_queue.front()->GetMemUsage();
		m_queue.pop_front();
		++m_nMissedEvents;
	}
	m_wait.wakeAll();
	m_mutex.unlock();
	
}

bool MAsyncEventReceiver::Poll(u_long time = ULONG_MAX)
{
	MLock lock(m_mutex);
	if (m_queue.size())
		return true;
	return m_wait.wait(&m_mutex, time);
}

bool MAsyncEventReceiver::HaveEvents()
{
	MLock lock(m_mutex);
	return m_queue.size();
}

int MAsyncEventReceiver::MissedEvents()
{
	MLock lock(m_mutex);
	return m_nMissedEvents;
}

void MAsyncEventReceiver::ResetMissedEvents()
{
	MLock lock(m_mutex);
	m_nMissedEvents = 0;
}

MEvent* MAsyncEventReceiver::Front()
{
	MLock lock(m_mutex);
	if (m_queue.size())
		return m_queue.front();
	return NULL;
}

void MAsyncEventReceiver::Pop()
{
	MLock lock(m_mutex);
	if (!m_queue.size())
		return;
	m_nMemUsed -= m_queue.front()->GetMemUsage();
	m_queue.pop_front();
}


/*protected:
	std::deque<TSmartPtr<MEvent>> m_queue;
	MMutex m_mutex;
	MWaitCondition m_wait;
	int m_nMaxTime;
	int m_nMaxMem;*/
	// virtual methods




