/***************************************************************************
                          gnusearch.h  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __GNUSEARCH_H_INCLUDED__
#define __GNUSEARCH_H_INCLUDED__

class MGnuDirector;
class MGnuNode;

enum SearchType{
	ST_UNKNOWN     = 0,
	ST_USER        = 1, // added by user
	ST_ALTERNATIVE = 2, // added by download
	ST_PARTIAL     = 3  // added on mutella start
};

struct SGnuSearch
{
	CString m_Search;
	int m_nType;
	// push ID
	GUID	m_QueryID;
	// autoget support
	bool    m_bAutoget;
	CString m_Filename;
	// filters
	DWORD   m_MinSpeed;
	int     m_SpeedFilterMode;
	int     m_SpeedFilterValue;
	// size filters
	int     m_SizeFilterMode;
	int     m_SizeFilterValue;
	// numeric ID
	DWORD m_dwID;
	// results
	int m_nHits;
	// member finctions
	bool IsAutomatic(){return m_nType==ST_ALTERNATIVE || m_nType==ST_PARTIAL;}
};

class MGnuSearch : public SGnuSearch
{
friend class MGnuDirector;
public: 
	MGnuSearch(MGnuDirector* pControl,
				const CString& search,
				int type,
				int size = 0,
				int sizeMode = LIMIT_NONE);
	~MGnuSearch();
	
	void SendQuery();
	//void SortList(int);
	//bool Inspect(Result &);

	ResultGroup* AddtoGroup(int);

	bool IsFull();
	bool CheckLimit(int, DWORD, DWORD);
	
	bool CheckAgainstResult(const Result &);
	
	void Clear();
	// some public members
	bool   m_bUpdated; // updated flag for MGnuDownload
	MMutex m_mutex;
	//
	//std::list<ResultGroup> m_ControlList;  // Groups of results
	std::vector<ResultGroup> m_GroupList; // Groups of results
	ResultVec              m_CurrentList;  // List of results
protected:
	// search kitchen
	char*   m_szSearch;
	vector<char*> m_PlusWords;
	vector<char*> m_MinusWords;
	// packet
	BYTE*  m_Packet;
	int    m_nPacketLength;
	//
	MGnuDirector* m_pDirector;
};

#endif //__GNUSEARCH_H_INCLUDED__
